/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.trigger.impl.RemoteEventDistributionTrigger;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={DistributionTrigger.class}, property={"webconsole.configurationFactory.nameHint=Trigger name: {name}"})
@Designate(ocd=Config.class)
public class RemoteEventDistributionTriggerFactory
implements DistributionTrigger {
    @Reference(name="transportSecretProvider")
    private DistributionTransportSecretProvider transportSecretProvider;
    @Reference
    private Scheduler scheduler;
    private RemoteEventDistributionTrigger trigger;

    @Activate
    public void activate(BundleContext bundleContext, Config conf) {
        String endpoint = conf.endpoint();
        this.trigger = new RemoteEventDistributionTrigger(endpoint, this.transportSecretProvider, this.scheduler);
    }

    @Deactivate
    public void deactivate() {
        this.trigger.disable();
    }

    @Override
    public void register(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.register(requestHandler);
    }

    @Override
    public void unregister(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.unregister(requestHandler);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Trigger - Remote Event Triggers Factory")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="The name of the trigger.")
        public String name();

        @AttributeDefinition(name="Endpoint", description="The endpoint from which the remote requests should be polled.")
        public String endpoint();

        @AttributeDefinition
        public String transportSecretProvider_target();
    }
}

