/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.davex;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.client.RepositoryFactoryImpl;
import org.apache.jackrabbit.spi.commons.logging.WriterLogWriterProvider;
import org.apache.jackrabbit.spi2dav.ConnectionOptions;
import org.apache.jackrabbit.spi2davex.Spi2davexRepositoryServiceFactory;
import org.apache.jackrabbit.vault.davex.DefaultBatchReadConfig;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.RepositoryFactory;

public class DAVExRepositoryFactory
implements RepositoryFactory {
    public static final String PARAM_JCR_REMOTING_DEPTH = "jcr.remoting.depth";
    public static final String PARAM_JCR_REMOTING_SPILOG = "jcr.remoting.spilog";
    private static final Set<String> SCHEMES = new HashSet<String>();

    @Override
    public Set<String> getSupportedSchemes() {
        return SCHEMES;
    }

    @Override
    public Repository createRepository(RepositoryAddress address) throws RepositoryException {
        return this.createRepository(address, null);
    }

    @Override
    public Repository createRepository(RepositoryAddress address, ConnectionOptions connectionOptions) throws RepositoryException {
        if (!SCHEMES.contains(address.getSpecificURI().getScheme())) {
            return null;
        }
        try {
            String workspace;
            URI uri = address.getSpecificURI();
            if (uri.getUserInfo() != null) {
                try {
                    uri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("org.apache.jackrabbit.spi.RepositoryServiceFactory", Spi2davexRepositoryServiceFactory.class.getName());
            parameters.put("org.apache.jackrabbit.jcr2spi.ItemCacheSize", Integer.getInteger(PARAM_JCR_REMOTING_DEPTH, 128));
            parameters.put("org.apache.jackrabbit.spi2davex.uri", uri.toString());
            DefaultBatchReadConfig br = new DefaultBatchReadConfig();
            br.setDefaultDepth(Integer.getInteger(PARAM_JCR_REMOTING_DEPTH, 4));
            br.setDepth("/", 2);
            br.setDepth("/jcr:system", 1);
            parameters.put("org.apache.jackrabbit.spi2davex.BatchReadConfig", br);
            String file = System.getProperty(PARAM_JCR_REMOTING_SPILOG);
            if (file != null) {
                WriterLogWriterProvider provider = new WriterLogWriterProvider(new OutputStreamWriter(FileUtils.openOutputStream(new File(file))));
                parameters.put("org.apache.jackrabbit.spi.commons.logging.LogWriterProvider", provider);
            }
            if ((workspace = address.getWorkspace()) != null) {
                parameters.put("org.apache.jackrabbit.spi2davex.WorkspaceNameDefault", workspace);
            }
            if (connectionOptions != null) {
                parameters.putAll(connectionOptions.toServiceFactoryParameters());
            }
            System.out.printf("Connecting via JCR remoting to %s%n", address.getSpecificURI().toString());
            return new RepositoryFactoryImpl().getRepository(parameters);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    static {
        SCHEMES.add("http");
        SCHEMES.add("https");
    }
}

