/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureType;
import org.apache.sis.feature.FieldType;
import org.apache.sis.feature.NamedFeatureType;
import org.apache.sis.feature.internal.Resources;
import org.opengis.metadata.Identifier;
import org.opengis.util.GenericName;

public class DefaultAssociationRole
extends FieldType {
    private static final long serialVersionUID = 1592712639262027124L;
    private volatile FeatureType valueType;
    private volatile transient String titleProperty;

    public DefaultAssociationRole(Map<String, ?> identification, DefaultFeatureType valueType, int minimumOccurs, int maximumOccurs) {
        super(identification, minimumOccurs, maximumOccurs);
        this.valueType = Objects.requireNonNull(valueType);
    }

    public DefaultAssociationRole(Map<String, ?> identification, GenericName valueType, int minimumOccurs, int maximumOccurs) {
        super(identification, minimumOccurs, maximumOccurs);
        this.valueType = new NamedFeatureType(Objects.requireNonNull(valueType));
    }

    public final boolean isResolved() {
        FeatureType type = this.valueType;
        if (type instanceof NamedFeatureType) {
            FeatureType resolved = ((NamedFeatureType)type).resolved;
            if (resolved == null) {
                return false;
            }
            this.valueType = resolved;
        }
        return true;
    }

    final boolean resolve(DefaultFeatureType creating, Collection<AbstractIdentifiedType> properties) {
        FeatureType type = this.valueType;
        if (type instanceof NamedFeatureType) {
            FeatureType resolved = ((NamedFeatureType)type).resolved;
            if (resolved == null) {
                GenericName name = type.getName();
                if (name.equals((Object)creating.getName())) {
                    resolved = creating;
                } else {
                    ArrayList<DefaultFeatureType> deferred = new ArrayList<DefaultFeatureType>();
                    resolved = DefaultAssociationRole.search(creating, properties, name, deferred);
                    if (resolved == null && (deferred.isEmpty() || (resolved = DefaultAssociationRole.deepSearch(deferred, name)) == null)) {
                        return false;
                    }
                }
                ((NamedFeatureType)type).resolved = resolved;
            }
            this.valueType = resolved;
        }
        return true;
    }

    private static DefaultFeatureType search(DefaultFeatureType feature, Collection<? extends AbstractIdentifiedType> properties, GenericName name, List<DefaultFeatureType> deferred) {
        if (properties == null) {
            properties = feature.getProperties(false);
        }
        for (AbstractIdentifiedType abstractIdentifiedType : properties) {
            FeatureType valueType;
            if (!(abstractIdentifiedType instanceof DefaultAssociationRole) || (valueType = ((DefaultAssociationRole)abstractIdentifiedType).valueType) instanceof NamedFeatureType) continue;
            if (name.equals((Object)valueType.getName())) {
                return (DefaultFeatureType)valueType;
            }
            deferred.add((DefaultFeatureType)valueType);
        }
        for (DefaultFeatureType defaultFeatureType : feature.getSuperTypes()) {
            if (name.equals((Object)defaultFeatureType.getName())) {
                return defaultFeatureType;
            }
            DefaultFeatureType defaultFeatureType2 = DefaultAssociationRole.search(defaultFeatureType, null, name, deferred);
            if (defaultFeatureType2 == null) continue;
            return defaultFeatureType2;
        }
        return null;
    }

    private static DefaultFeatureType deepSearch(List<DefaultFeatureType> deferred, GenericName name) {
        IdentityHashMap<DefaultFeatureType, Boolean> done = new IdentityHashMap<DefaultFeatureType, Boolean>(8);
        int i = 0;
        while (i < deferred.size()) {
            DefaultFeatureType valueType;
            if (done.put(valueType = deferred.get(i++), Boolean.TRUE) != null) continue;
            deferred.subList(0, i).clear();
            valueType = DefaultAssociationRole.search(valueType, null, name, deferred);
            if (valueType != null) {
                return valueType;
            }
            i = 0;
        }
        return null;
    }

    public final DefaultFeatureType getValueType() {
        FeatureType type = this.valueType;
        if (type instanceof NamedFeatureType) {
            type = ((NamedFeatureType)type).resolved;
            if (type == null) {
                throw new IllegalStateException(Resources.format((short)71, this.getName()));
            }
            this.valueType = type;
        }
        return (DefaultFeatureType)type;
    }

    static GenericName getValueTypeName(DefaultAssociationRole role) {
        return role.valueType.getName();
    }

    static String getTitleProperty(DefaultAssociationRole role) {
        String p = role.titleProperty;
        if (p != null) {
            return p.isEmpty() ? null : p;
        }
        p = DefaultAssociationRole.searchTitleProperty(role.getValueType());
        role.titleProperty = p != null ? p : "";
        return p;
    }

    private static String searchTitleProperty(DefaultFeatureType ft) {
        String fallback = null;
        if (ft.hasProperty("sis:identifier")) {
            return ft.getProperty("sis:identifier").getName().toString();
        }
        for (AbstractIdentifiedType type : ft.getProperties(true)) {
            DefaultAttributeType pt;
            Class valueClass;
            if (!(type instanceof DefaultAttributeType) || !CharSequence.class.isAssignableFrom(valueClass = (pt = (DefaultAttributeType)type).getValueClass()) && !GenericName.class.isAssignableFrom(valueClass) && !Identifier.class.isAssignableFrom(valueClass)) continue;
            String name = pt.getName().toString();
            if (pt.getMaximumOccurs() != 0) {
                return name;
            }
            if (fallback != null) continue;
            fallback = name;
        }
        return fallback;
    }

    @Override
    public final int getMinimumOccurs() {
        return super.getMinimumOccurs();
    }

    @Override
    public final int getMaximumOccurs() {
        return super.getMaximumOccurs();
    }

    public AbstractAssociation newInstance() {
        return AbstractAssociation.create(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.valueType.getName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (super.equals(obj)) {
            DefaultAssociationRole that = (DefaultAssociationRole)obj;
            return this.valueType.equals(that.valueType);
        }
        return false;
    }

    public String toString() {
        return DefaultAssociationRole.toString(this.deprecated, "FeatureAssociationRole", this.getName(), this.valueType.getName()).toString();
    }
}

