/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import org.apache.sis.math.NumberType;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.Classes;

final class ConcatenatedVector
extends Vector
implements Serializable {
    private static final long serialVersionUID = 4639375525939012394L;
    private final Vector first;
    private final Vector second;
    private final int limit;

    public ConcatenatedVector(Vector first, Vector second) {
        this.first = first;
        this.second = second;
        this.limit = first.size();
    }

    @Override
    public Class<? extends Number> getElementType() {
        return Classes.findCommonClass(this.first.getElementType(), this.second.getElementType()).asSubclass(Number.class);
    }

    @Override
    public boolean isInteger() {
        return this.first.isInteger() && this.second.isInteger();
    }

    @Override
    public boolean isUnsigned() {
        return this.first.isUnsigned() && this.second.isUnsigned();
    }

    @Override
    public int size() {
        return this.limit + this.second.size();
    }

    @Override
    public boolean isEmptyOrNaN() {
        return this.first.isEmptyOrNaN() && this.second.isEmptyOrNaN();
    }

    @Override
    public boolean isNaN(int index) throws IndexOutOfBoundsException {
        Vector v;
        if (index < this.limit) {
            v = this.first;
        } else {
            v = this.second;
            index -= this.limit;
        }
        return v.isNaN(index);
    }

    @Override
    public double doubleValue(int index) {
        Vector v;
        if (index < this.limit) {
            v = this.first;
        } else {
            v = this.second;
            index -= this.limit;
        }
        return v.doubleValue(index);
    }

    @Override
    public float floatValue(int index) {
        Vector v;
        if (index < this.limit) {
            v = this.first;
        } else {
            v = this.second;
            index -= this.limit;
        }
        return v.floatValue(index);
    }

    @Override
    public long longValue(int index) {
        Vector v;
        if (index < this.limit) {
            v = this.first;
        } else {
            v = this.second;
            index -= this.limit;
        }
        return v.longValue(index);
    }

    @Override
    public int intValue(int index) {
        Vector v;
        if (index < this.limit) {
            v = this.first;
        } else {
            v = this.second;
            index -= this.limit;
        }
        return v.intValue(index);
    }

    @Override
    public short shortValue(int index) {
        Vector v;
        if (index < this.limit) {
            v = this.first;
        } else {
            v = this.second;
            index -= this.limit;
        }
        return v.shortValue(index);
    }

    @Override
    public byte byteValue(int index) {
        Vector v;
        if (index < this.limit) {
            v = this.first;
        } else {
            v = this.second;
            index -= this.limit;
        }
        return v.byteValue(index);
    }

    @Override
    public String stringValue(int index) {
        Vector v;
        if (index < this.limit) {
            v = this.first;
        } else {
            v = this.second;
            index -= this.limit;
        }
        return v.stringValue(index);
    }

    @Override
    public Number get(int index) {
        Vector v;
        if (index < this.limit) {
            v = this.first;
        } else {
            v = this.second;
            index -= this.limit;
        }
        return v.get(index);
    }

    @Override
    public Number set(int index, Number value) {
        Vector v;
        if (index < this.limit) {
            v = this.first;
        } else {
            v = this.second;
            index -= this.limit;
        }
        Number old = v.set(index, value);
        ++this.modCount;
        return old;
    }

    @Override
    public void fill(int fromIndex, int toIndex, Number value) {
        if (fromIndex < this.limit) {
            this.first.fill(fromIndex, Math.min(toIndex, this.limit), value);
        }
        if (toIndex > this.limit) {
            this.second.fill(Math.max(0, fromIndex - this.limit), toIndex - this.limit, value);
        }
    }

    @Override
    public Number increment(double tolerance) {
        NumberType type;
        Number check;
        Number inc = this.first.increment(tolerance);
        if (inc != null && (check = this.second.increment(tolerance)) != null && (inc = (type = NumberType.forNumberClasses(inc.getClass(), check.getClass())).cast(inc)).equals(check = type.cast(check))) {
            return inc;
        }
        return null;
    }

    @Override
    public NumberRange<?> range() {
        return this.first.range().unionAny(this.second.range());
    }

    @Override
    Vector createSubSampling(int first, int step, int length) {
        if (first >= this.limit) {
            return this.second.subSampling(first - this.limit, step, length);
        }
        if (first + step * length <= this.limit) {
            return this.first.subSampling(first, step, length);
        }
        return super.createSubSampling(first, step, length);
    }

    @Override
    Vector createConcatenate(Vector toAppend) {
        return this.first.concatenate(this.second.concatenate(toAppend));
    }

    @Override
    Vector createTransform(double scale, double offset) {
        return this.first.transform(scale, offset).concatenate(this.second.transform(scale, offset));
    }
}

