/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Comparator;
import java.util.OptionalLong;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.internal.shared.FeatureProjection;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.Optimization;
import org.apache.sis.pending.geoapi.filter.SortBy;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureQuery;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.UnsupportedQueryException;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.storage.internal.Resources;
import org.opengis.metadata.Metadata;

final class FeatureSubset
extends AbstractFeatureSet {
    private final FeatureSet source;
    private final FeatureQuery query;
    private FeatureProjection projection;
    private DefaultFeatureType resultType;

    FeatureSubset(FeatureSet source, FeatureQuery query) {
        super(source);
        this.source = source;
        this.query = query;
    }

    @Override
    protected void prepareQueryOptimization(FeatureQuery query, Optimization optimizer) throws DataStoreException {
        DefaultFeatureType type = this.getType();
        if (this.projection != null) {
            optimizer.setFinalFeatureType(type);
        } else if (this.source instanceof AbstractFeatureSet) {
            ((AbstractFeatureSet)this.source).prepareQueryOptimization(query, optimizer);
        }
    }

    @Override
    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder builder = new MetadataBuilder();
        builder.addDefaultMetadata(this, this.listeners);
        builder.addLineage((CharSequence)Resources.formatInternational((short)76));
        builder.addProcessDescription((CharSequence)Resources.formatInternational((short)77, StoreUtilities.getLabel(this.source)));
        builder.addSource(this.source.getMetadata());
        return builder.build();
    }

    @Override
    public synchronized DefaultFeatureType getType() throws DataStoreException {
        if (this.resultType == null) {
            DefaultFeatureType type = this.source.getType();
            try {
                this.projection = this.query.project(type, this.listeners.getLocale()).orElse(null);
                this.resultType = this.projection != null ? this.projection.typeRequested : type;
            }
            catch (RuntimeException e) {
                throw new UnsupportedQueryException(Resources.forLocale(this.listeners.getLocale()).getString((short)55, type.getName()), e);
            }
        }
        return this.resultType;
    }

    @Override
    public Stream<AbstractFeature> features(boolean parallel) throws DataStoreException {
        OptionalLong limit;
        long offset;
        SortBy<AbstractFeature> sortBy;
        Stream<Object> stream = this.source.features(parallel);
        Filter<? super AbstractFeature> selection = this.query.getSelection();
        if (selection != null && !selection.equals((Object)Filter.include())) {
            stream = stream.filter((Predicate<AbstractFeature>)selection);
        }
        if ((sortBy = this.query.getSortBy()) != null) {
            stream = stream.sorted((Comparator<AbstractFeature>)sortBy);
        }
        if ((offset = this.query.getOffset()) > 0L) {
            stream = stream.skip(offset);
        }
        if ((limit = this.query.getLimit()).isPresent()) {
            stream = stream.limit(limit.getAsLong());
        }
        this.getType();
        if (this.projection != null) {
            stream = stream.map(this.projection);
        }
        return stream;
    }
}

