/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql.internal.shared;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.sis.metadata.sql.internal.shared.Dialect;
import org.apache.sis.metadata.sql.internal.shared.Initializer;
import org.apache.sis.system.DataDirectory;
import org.apache.sis.system.Reflect;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.logging.Logging;

public final class LocalDataSource
implements DataSource,
Comparable<LocalDataSource> {
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.sql");
    private static final String DERBY_HOME_KEY = "derby.system.home";
    private final Dialect dialect;
    private String dbFile;
    private DataSource source;
    final boolean create;

    private LocalDataSource(Dialect dialect, String dbFile, boolean create) {
        this.dialect = dialect;
        this.dbFile = dbFile;
        this.create = create;
    }

    static LocalDataSource[] create(String database, Dialect ... dialects) {
        Object[] sources = new LocalDataSource[dialects.length];
        int count = 0;
        for (Dialect dialect : dialects) {
            boolean create;
            String dbFile;
            Path path;
            String home;
            switch (dialect) {
                case DERBY: {
                    home = System.getProperty(DERBY_HOME_KEY);
                    break;
                }
                default: {
                    home = null;
                }
            }
            Path dir = DataDirectory.DATABASES.getDirectory();
            if (dir != null) {
                path = dir.resolve(database);
                if (home != null) {
                    try {
                        path = Path.of(home, new String[0]).relativize(path);
                    }
                    catch (IllegalArgumentException | SecurityException e) {
                        Logging.recoverableException((Logger)LOGGER, LocalDataSource.class, (String)"<init>", (Throwable)e);
                    }
                }
                path = path.normalize();
                dbFile = path.toString().replace(path.getFileSystem().getSeparator(), "/");
                switch (dialect) {
                    case HSQL: {
                        path = Path.of(path.toString() + ".data", new String[0]);
                    }
                }
                create = Files.notExists(path, new LinkOption[0]);
            } else {
                if (home == null) continue;
                path = Path.of(home, new String[0]);
                create = !Files.exists(path.resolve(database), new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
                dbFile = database;
            }
            sources[count++] = new LocalDataSource(dialect, dbFile, create);
        }
        if (count == 0) {
            return null;
        }
        sources = (LocalDataSource[])ArraysExt.resize((Object[])sources, (int)count);
        Arrays.sort(sources);
        return sources;
    }

    static DataSource wrap(DataSource ds) {
        Dialect dialect;
        String cn = ds.getClass().getName();
        if (cn.startsWith("org.apache.derby.")) {
            dialect = Dialect.DERBY;
        } else if (cn.startsWith("org.hsqldb.")) {
            dialect = Dialect.HSQL;
        } else {
            return ds;
        }
        LocalDataSource local = new LocalDataSource(dialect, null, false);
        local.source = ds;
        return local;
    }

    private void initialize() throws ReflectiveOperationException {
        Class<?> c;
        String classname;
        switch (this.dialect) {
            case DERBY: {
                classname = "org.apache.derby.jdbc.EmbeddedDataSource";
                break;
            }
            case HSQL: {
                classname = "org.hsqldb.jdbc.JDBCDataSource";
                break;
            }
            default: {
                throw new IllegalArgumentException(this.dialect.toString());
            }
        }
        try {
            c = Class.forName(classname, true, Reflect.getContextClassLoader());
        }
        catch (SecurityException e) {
            Reflect.log(Initializer.class, (String)"getDataSource", (SecurityException)e);
            c = Class.forName(classname);
        }
        this.source = (DataSource)c.getConstructor(new Class[0]).newInstance(new Object[0]);
        Class[] args = new Class[]{String.class};
        switch (this.dialect) {
            case DERBY: {
                c.getMethod("setDataSourceName", args).invoke((Object)this.source, "Apache SIS spatial metadata");
            }
            case HSQL: {
                c.getMethod("setDatabaseName", args).invoke((Object)this.source, this.dbFile);
            }
        }
        this.dbFile = null;
    }

    static LocalDataSource findDriver(LocalDataSource[] sources) throws Exception {
        ClassNotFoundException fail = null;
        for (LocalDataSource local : sources) {
            try {
                local.initialize();
                return local;
            }
            catch (ClassNotFoundException e) {
                if (fail == null) {
                    fail = e;
                    continue;
                }
                fail.addSuppressed(e);
            }
        }
        throw fail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void createDatabase() throws Exception {
        if (this.create) {
            Method enabler;
            switch (this.dialect) {
                case DERBY: {
                    enabler = this.source.getClass().getMethod("setCreateDatabase", String.class);
                    enabler.invoke((Object)this.source, "create");
                    break;
                }
                default: {
                    enabler = null;
                }
            }
            try (Connection c = this.source.getConnection();){
                for (Initializer init : Initializer.load()) {
                    init.createSchema(c);
                }
            }
            catch (Throwable throwable) {
                switch (this.dialect) {
                    case DERBY: {
                        enabler.invoke((Object)this.source, "no");
                    }
                }
                throw throwable;
            }
            switch (this.dialect) {
                case DERBY: {
                    enabler.invoke((Object)this.source, "no");
                }
            }
        }
    }

    final void shutdown() throws ReflectiveOperationException {
        try {
            switch (this.dialect) {
                case HSQL: {
                    try (Connection c = this.source.getConnection();
                         Statement stmt = c.createStatement();){
                        stmt.execute(this.create ? "SHUTDOWN COMPACT" : "SHUTDOWN");
                        break;
                    }
                }
                case DERBY: {
                    this.source.getClass().getMethod("setShutdownDatabase", String.class).invoke((Object)this.source, "shutdown");
                    this.source.getConnection().close();
                }
            }
        }
        catch (SQLException e) {
            LogRecord record = new LogRecord(Level.FINER, e.getMessage());
            if (this.dialect != Dialect.DERBY || !LocalDataSource.isSuccessfulShutdown(e)) {
                record.setLevel(Level.WARNING);
                record.setThrown(e);
            }
            Logging.completeAndLog((Logger)LOGGER, LocalDataSource.class, (String)"shutdown", (LogRecord)record);
        }
    }

    public static boolean isSuccessfulShutdown(SQLException e) {
        String state = e.getSQLState();
        return "08006".equals(state) || "XJ004".equals(state);
    }

    @Override
    public int compareTo(LocalDataSource other) {
        return Boolean.compare(this.create, other.create);
    }

    @Override
    public boolean isWrapperFor(Class<?> type) throws SQLException {
        return type == LocalDataSource.class || this.source.isWrapperFor(type);
    }

    @Override
    public <T> T unwrap(Class<T> type) throws SQLException {
        if (type == LocalDataSource.class) {
            return (T)this;
        }
        return this.source.unwrap(type);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.source.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.source.getConnection(username, password);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.source.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.source.setLoginTimeout(seconds);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.source.getParentLogger();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.source.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.source.setLogWriter(out);
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{null, this.dialect, "dbFile", this.dbFile, "source", this.source});
    }
}

