/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

final class LinkOperation
extends AbstractOperation {
    private static final long serialVersionUID = 765096861589501215L;
    private static final ParameterDescriptorGroup PARAMETERS = LinkOperation.parameters("Link", new ParameterDescriptor[0]);
    final AbstractIdentifiedType result;
    final String referentName;

    LinkOperation(Map<String, ?> identification, AbstractIdentifiedType referent) {
        super(identification);
        if (referent instanceof LinkOperation) {
            referent = ((LinkOperation)referent).result;
        }
        this.result = referent;
        this.referentName = referent.getName().toString();
        if (this.referentName.equals(this.getName().toString())) {
            throw new IllegalArgumentException(Errors.format((short)28));
        }
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return PARAMETERS;
    }

    @Override
    public AbstractIdentifiedType getResult() {
        return this.result;
    }

    @Override
    public Set<String> getDependencies() {
        return Set.of(this.referentName);
    }

    @Override
    public AbstractOperation updateDependencies(Map<String, AbstractIdentifiedType> dependencies) {
        AbstractIdentifiedType target = dependencies.get(this.referentName);
        if (target == null || target.equals(this.result)) {
            return this;
        }
        return (AbstractOperation)FeatureOperations.POOL.unique((Object)new LinkOperation(this.inherit(), target));
    }

    @Override
    public Object apply(AbstractFeature feature, ParameterValueGroup parameters) {
        return feature.getProperty(this.referentName);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.referentName.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.referentName.equals(((LinkOperation)obj).referentName);
    }

    @Override
    void formatResultFormula(Appendable buffer) throws IOException {
        buffer.append(this.referentName);
    }
}

