/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.royale.compiler.css.ICSSPropertyValue;
import org.apache.royale.compiler.internal.css.CSSModelTreeType;
import org.apache.royale.compiler.internal.css.CSSPropertyValue;

public class CSSArrayPropertyValue
extends CSSPropertyValue {
    private final ImmutableList<CSSPropertyValue> elements;

    public CSSArrayPropertyValue(List<CSSPropertyValue> elements, CommonTree ast, TokenStream tokens) {
        super(ast, tokens, CSSModelTreeType.PROPERTY_VALUE);
        this.elements = ImmutableList.copyOf(elements);
        for (CSSPropertyValue element : elements) {
            element.setParent(this);
        }
        this.children.addAll(elements);
    }

    public ImmutableList<? extends ICSSPropertyValue> getElements() {
        return this.elements;
    }

    @Override
    public String toString() {
        return Joiner.on((String)", ").join(this.elements);
    }
}

