/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.semantics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.royale.abc.graph.IBasicBlock;
import org.apache.royale.abc.semantics.Instruction;

public class Block
implements IBasicBlock {
    private ArrayList<Instruction> instructions = new ArrayList();
    private Collection<IBasicBlock> successors = Collections.emptySet();
    public int blocknum;

    public Collection<IBasicBlock> getSuccessors() {
        return this.successors;
    }

    void addSuccessor(IBasicBlock succ) {
        if (this.successors.size() == 0) {
            this.successors = new ArrayList<IBasicBlock>();
        }
        this.successors.add(succ);
    }

    void add(Instruction insn) {
        this.instructions.add(insn);
    }

    @Override
    public int size() {
        return this.instructions.size();
    }

    @Override
    public Instruction get(int idx) {
        return this.instructions.get(idx);
    }

    @Override
    public List<Instruction> getInstructions() {
        return this.instructions;
    }

    @Override
    public boolean canFallThrough() {
        for (int i = this.instructions.size() - 1; i >= 0; --i) {
            Instruction insn = this.instructions.get(i);
            if (!insn.isExecutable()) continue;
            int prev_op = insn.getOpcode();
            return prev_op != 16 && prev_op != 3 && !insn.isReturn();
        }
        return true;
    }
}

