/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.CertificateException;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.InvokeCallback;
import org.apache.rocketmq.remoting.RemotingServer;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.common.TlsMode;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import org.apache.rocketmq.remoting.netty.FileRegionEncoder;
import org.apache.rocketmq.remoting.netty.NettyDecoder;
import org.apache.rocketmq.remoting.netty.NettyEncoder;
import org.apache.rocketmq.remoting.netty.NettyEvent;
import org.apache.rocketmq.remoting.netty.NettyEventType;
import org.apache.rocketmq.remoting.netty.NettyRemotingAbstract;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.netty.RemotingCodeDistributionHandler;
import org.apache.rocketmq.remoting.netty.TlsHelper;
import org.apache.rocketmq.remoting.netty.TlsSystemConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class NettyRemotingServer
extends NettyRemotingAbstract
implements RemotingServer {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqRemoting");
    private static final Logger TRAFFIC_LOGGER = LoggerFactory.getLogger((String)"RocketmqTraffic");
    private final ServerBootstrap serverBootstrap;
    private final EventLoopGroup eventLoopGroupSelector;
    private final EventLoopGroup eventLoopGroupBoss;
    private final NettyServerConfig nettyServerConfig;
    private final ExecutorService publicExecutor;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ChannelEventListener channelEventListener;
    private final Timer timer = new Timer("ServerHouseKeepingService", true);
    private DefaultEventExecutorGroup defaultEventExecutorGroup;
    private final ConcurrentMap<Integer, NettyRemotingAbstract> remotingServerTable = new ConcurrentHashMap<Integer, NettyRemotingAbstract>();
    public static final String HANDSHAKE_HANDLER_NAME = "handshakeHandler";
    public static final String TLS_HANDLER_NAME = "sslHandler";
    public static final String FILE_REGION_ENCODER_NAME = "fileRegionEncoder";
    private HandshakeHandler handshakeHandler;
    private NettyEncoder encoder;
    private NettyConnectManageHandler connectionManageHandler;
    private NettyServerHandler serverHandler;
    private RemotingCodeDistributionHandler distributionHandler;

    public NettyRemotingServer(NettyServerConfig nettyServerConfig) {
        this(nettyServerConfig, null);
    }

    public NettyRemotingServer(NettyServerConfig nettyServerConfig, ChannelEventListener channelEventListener) {
        super(nettyServerConfig.getServerOnewaySemaphoreValue(), nettyServerConfig.getServerAsyncSemaphoreValue());
        this.serverBootstrap = new ServerBootstrap();
        this.nettyServerConfig = nettyServerConfig;
        this.channelEventListener = channelEventListener;
        this.publicExecutor = this.buildPublicExecutor(nettyServerConfig);
        this.scheduledExecutorService = this.buildScheduleExecutor();
        this.eventLoopGroupBoss = this.buildBossEventLoopGroup();
        this.eventLoopGroupSelector = this.buildEventLoopGroupSelector();
        this.loadSslContext();
    }

    private EventLoopGroup buildEventLoopGroupSelector() {
        if (this.useEpoll()) {
            return new EpollEventLoopGroup(this.nettyServerConfig.getServerSelectorThreads(), new ThreadFactory(){
                private final AtomicInteger threadIndex = new AtomicInteger(0);
                private final int threadTotal = NettyRemotingServer.access$000(NettyRemotingServer.this).getServerSelectorThreads();

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, String.format("NettyServerEPOLLSelector_%d_%d", this.threadTotal, this.threadIndex.incrementAndGet()));
                }
            });
        }
        return new NioEventLoopGroup(this.nettyServerConfig.getServerSelectorThreads(), new ThreadFactory(){
            private final AtomicInteger threadIndex = new AtomicInteger(0);
            private final int threadTotal = NettyRemotingServer.access$000(NettyRemotingServer.this).getServerSelectorThreads();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, String.format("NettyServerNIOSelector_%d_%d", this.threadTotal, this.threadIndex.incrementAndGet()));
            }
        });
    }

    private EventLoopGroup buildBossEventLoopGroup() {
        if (this.useEpoll()) {
            return new EpollEventLoopGroup(1, new ThreadFactory(){
                private final AtomicInteger threadIndex = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, String.format("NettyEPOLLBoss_%d", this.threadIndex.incrementAndGet()));
                }
            });
        }
        return new NioEventLoopGroup(1, new ThreadFactory(){
            private final AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, String.format("NettyNIOBoss_%d", this.threadIndex.incrementAndGet()));
            }
        });
    }

    private ExecutorService buildPublicExecutor(NettyServerConfig nettyServerConfig) {
        int publicThreadNums = nettyServerConfig.getServerCallbackExecutorThreads();
        if (publicThreadNums <= 0) {
            publicThreadNums = 4;
        }
        return Executors.newFixedThreadPool(publicThreadNums, new ThreadFactory(){
            private final AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyServerPublicExecutor_" + this.threadIndex.incrementAndGet());
            }
        });
    }

    private ScheduledExecutorService buildScheduleExecutor() {
        return new ScheduledThreadPoolExecutor(1, r -> {
            Thread thread = new Thread(r, "NettyServerScheduler");
            thread.setDaemon(true);
            return thread;
        }, new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    public void loadSslContext() {
        TlsMode tlsMode = TlsSystemConfig.tlsMode;
        log.info("Server is running in TLS {} mode", (Object)tlsMode.getName());
        if (tlsMode != TlsMode.DISABLED) {
            try {
                this.sslContext = TlsHelper.buildSslContext(false);
                log.info("SSLContext created for server");
            }
            catch (IOException | CertificateException e) {
                log.error("Failed to create SSLContext for server", (Throwable)e);
            }
        }
    }

    private boolean useEpoll() {
        return NetworkUtil.isLinuxPlatform() && this.nettyServerConfig.isUseEpollNativeSelector() && Epoll.isAvailable();
    }

    @Override
    public void start() {
        this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.nettyServerConfig.getServerWorkerThreads(), new ThreadFactory(){
            private final AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyServerCodecThread_" + this.threadIndex.incrementAndGet());
            }
        });
        this.prepareSharableHandlers();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(this.eventLoopGroupBoss, this.eventLoopGroupSelector).channel(this.useEpoll() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)false).childOption(ChannelOption.TCP_NODELAY, (Object)true).localAddress((SocketAddress)new InetSocketAddress(this.nettyServerConfig.getBindAddress(), this.nettyServerConfig.getListenPort()))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                NettyRemotingServer.this.configChannel(ch);
            }
        });
        this.addCustomConfig(this.serverBootstrap);
        try {
            ChannelFuture sync = this.serverBootstrap.bind().sync();
            InetSocketAddress addr = (InetSocketAddress)sync.channel().localAddress();
            if (0 == this.nettyServerConfig.getListenPort()) {
                this.nettyServerConfig.setListenPort(addr.getPort());
            }
            log.info("RemotingServer started, listening {}:{}", (Object)this.nettyServerConfig.getBindAddress(), (Object)this.nettyServerConfig.getListenPort());
            this.remotingServerTable.put(this.nettyServerConfig.getListenPort(), this);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to bind to %s:%d", this.nettyServerConfig.getBindAddress(), this.nettyServerConfig.getListenPort()), e);
        }
        if (this.channelEventListener != null) {
            this.nettyEventExecutor.start();
        }
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    NettyRemotingServer.this.scanResponseTable();
                }
                catch (Throwable e) {
                    log.error("scanResponseTable exception", e);
                }
            }
        }, 3000L, 1000L);
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            try {
                this.printRemotingCodeDistribution();
            }
            catch (Throwable e) {
                TRAFFIC_LOGGER.error("NettyRemotingServer print remoting code distribution exception", e);
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    protected ChannelPipeline configChannel(SocketChannel ch) {
        return ch.pipeline().addLast((EventExecutorGroup)this.defaultEventExecutorGroup, HANDSHAKE_HANDLER_NAME, (ChannelHandler)this.handshakeHandler).addLast((EventExecutorGroup)this.defaultEventExecutorGroup, new ChannelHandler[]{this.encoder, new NettyDecoder(), this.distributionHandler, new IdleStateHandler(0, 0, this.nettyServerConfig.getServerChannelMaxIdleTimeSeconds()), this.connectionManageHandler, this.serverHandler});
    }

    private void addCustomConfig(ServerBootstrap childHandler) {
        if (this.nettyServerConfig.getServerSocketSndBufSize() > 0) {
            log.info("server set SO_SNDBUF to {}", (Object)this.nettyServerConfig.getServerSocketSndBufSize());
            childHandler.childOption(ChannelOption.SO_SNDBUF, (Object)this.nettyServerConfig.getServerSocketSndBufSize());
        }
        if (this.nettyServerConfig.getServerSocketRcvBufSize() > 0) {
            log.info("server set SO_RCVBUF to {}", (Object)this.nettyServerConfig.getServerSocketRcvBufSize());
            childHandler.childOption(ChannelOption.SO_RCVBUF, (Object)this.nettyServerConfig.getServerSocketRcvBufSize());
        }
        if (this.nettyServerConfig.getWriteBufferLowWaterMark() > 0 && this.nettyServerConfig.getWriteBufferHighWaterMark() > 0) {
            log.info("server set netty WRITE_BUFFER_WATER_MARK to {},{}", (Object)this.nettyServerConfig.getWriteBufferLowWaterMark(), (Object)this.nettyServerConfig.getWriteBufferHighWaterMark());
            childHandler.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.nettyServerConfig.getWriteBufferLowWaterMark(), this.nettyServerConfig.getWriteBufferHighWaterMark()));
        }
        if (this.nettyServerConfig.isServerPooledByteBufAllocatorEnable()) {
            childHandler.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.timer.cancel();
            this.eventLoopGroupBoss.shutdownGracefully();
            this.eventLoopGroupSelector.shutdownGracefully();
            this.nettyEventExecutor.shutdown();
            if (this.defaultEventExecutorGroup != null) {
                this.defaultEventExecutorGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            log.error("NettyRemotingServer shutdown exception, ", (Throwable)e);
        }
        if (this.publicExecutor != null) {
            try {
                this.publicExecutor.shutdown();
            }
            catch (Exception e) {
                log.error("NettyRemotingServer shutdown exception, ", (Throwable)e);
            }
        }
    }

    @Override
    public void registerProcessor(int requestCode, NettyRequestProcessor processor, ExecutorService executor) {
        ExecutorService executorThis = executor;
        if (null == executor) {
            executorThis = this.publicExecutor;
        }
        Pair pair = new Pair((Object)processor, (Object)executorThis);
        this.processorTable.put(requestCode, pair);
    }

    @Override
    public void registerDefaultProcessor(NettyRequestProcessor processor, ExecutorService executor) {
        this.defaultRequestProcessorPair = new Pair((Object)processor, (Object)executor);
    }

    @Override
    public int localListenPort() {
        return this.nettyServerConfig.getListenPort();
    }

    @Override
    public Pair<NettyRequestProcessor, ExecutorService> getProcessorPair(int requestCode) {
        return (Pair)this.processorTable.get(requestCode);
    }

    @Override
    public Pair<NettyRequestProcessor, ExecutorService> getDefaultProcessorPair() {
        return this.defaultRequestProcessorPair;
    }

    @Override
    public RemotingServer newRemotingServer(int port) {
        SubRemotingServer remotingServer = new SubRemotingServer(port, this.nettyServerConfig.getServerOnewaySemaphoreValue(), this.nettyServerConfig.getServerAsyncSemaphoreValue());
        NettyRemotingAbstract existingServer = this.remotingServerTable.putIfAbsent(port, remotingServer);
        if (existingServer != null) {
            throw new RuntimeException("The port " + port + " already in use by another RemotingServer");
        }
        return remotingServer;
    }

    @Override
    public void removeRemotingServer(int port) {
        this.remotingServerTable.remove(port);
    }

    @Override
    public RemotingCommand invokeSync(Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingSendRequestException, RemotingTimeoutException {
        return this.invokeSyncImpl(channel, request, timeoutMillis);
    }

    @Override
    public void invokeAsync(Channel channel, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        this.invokeAsyncImpl(channel, request, timeoutMillis, invokeCallback);
    }

    @Override
    public void invokeOneway(Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        this.invokeOnewayImpl(channel, request, timeoutMillis);
    }

    @Override
    public ChannelEventListener getChannelEventListener() {
        return this.channelEventListener;
    }

    @Override
    public ExecutorService getCallbackExecutor() {
        return this.publicExecutor;
    }

    private void prepareSharableHandlers() {
        this.handshakeHandler = new HandshakeHandler(TlsSystemConfig.tlsMode);
        this.encoder = new NettyEncoder();
        this.connectionManageHandler = new NettyConnectManageHandler();
        this.serverHandler = new NettyServerHandler();
        this.distributionHandler = new RemotingCodeDistributionHandler();
    }

    private void printRemotingCodeDistribution() {
        if (this.distributionHandler != null) {
            TRAFFIC_LOGGER.info("Port: {}, RequestCode Distribution: {}", (Object)this.nettyServerConfig.getListenPort(), (Object)this.distributionHandler.getInBoundSnapshotString());
            TRAFFIC_LOGGER.info("Port: {}, ResponseCode Distribution: {}", (Object)this.nettyServerConfig.getListenPort(), (Object)this.distributionHandler.getOutBoundSnapshotString());
        }
    }

    public DefaultEventExecutorGroup getDefaultEventExecutorGroup() {
        return this.defaultEventExecutorGroup;
    }

    public HandshakeHandler getHandshakeHandler() {
        return this.handshakeHandler;
    }

    public NettyEncoder getEncoder() {
        return this.encoder;
    }

    public NettyConnectManageHandler getConnectionManageHandler() {
        return this.connectionManageHandler;
    }

    public NettyServerHandler getServerHandler() {
        return this.serverHandler;
    }

    public RemotingCodeDistributionHandler getDistributionHandler() {
        return this.distributionHandler;
    }

    static /* synthetic */ NettyServerConfig access$000(NettyRemotingServer x0) {
        return x0.nettyServerConfig;
    }

    class SubRemotingServer
    extends NettyRemotingAbstract
    implements RemotingServer {
        private volatile int listenPort;
        private volatile Channel serverChannel;

        SubRemotingServer(int port, int permitsOnway, int permitsAsync) {
            super(permitsOnway, permitsAsync);
            this.listenPort = port;
        }

        @Override
        public void registerProcessor(int requestCode, NettyRequestProcessor processor, ExecutorService executor) {
            ExecutorService executorThis = executor;
            if (null == executor) {
                executorThis = NettyRemotingServer.this.publicExecutor;
            }
            Pair pair = new Pair((Object)processor, (Object)executorThis);
            this.processorTable.put(requestCode, pair);
        }

        @Override
        public void registerDefaultProcessor(NettyRequestProcessor processor, ExecutorService executor) {
            this.defaultRequestProcessorPair = new Pair((Object)processor, (Object)executor);
        }

        @Override
        public int localListenPort() {
            return this.listenPort;
        }

        @Override
        public Pair<NettyRequestProcessor, ExecutorService> getProcessorPair(int requestCode) {
            return (Pair)this.processorTable.get(requestCode);
        }

        @Override
        public Pair<NettyRequestProcessor, ExecutorService> getDefaultProcessorPair() {
            return this.defaultRequestProcessorPair;
        }

        @Override
        public RemotingServer newRemotingServer(int port) {
            throw new UnsupportedOperationException("The SubRemotingServer of NettyRemotingServer doesn't support new nested RemotingServer");
        }

        @Override
        public void removeRemotingServer(int port) {
            throw new UnsupportedOperationException("The SubRemotingServer of NettyRemotingServer doesn't support remove nested RemotingServer");
        }

        @Override
        public RemotingCommand invokeSync(Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingSendRequestException, RemotingTimeoutException {
            return this.invokeSyncImpl(channel, request, timeoutMillis);
        }

        @Override
        public void invokeAsync(Channel channel, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
            this.invokeAsyncImpl(channel, request, timeoutMillis, invokeCallback);
        }

        @Override
        public void invokeOneway(Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
            this.invokeOnewayImpl(channel, request, timeoutMillis);
        }

        @Override
        public void start() {
            try {
                if (this.listenPort < 0) {
                    this.listenPort = 0;
                }
                this.serverChannel = NettyRemotingServer.this.serverBootstrap.bind(this.listenPort).sync().channel();
                if (0 == this.listenPort) {
                    InetSocketAddress addr = (InetSocketAddress)this.serverChannel.localAddress();
                    this.listenPort = addr.getPort();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("this.subRemotingServer.serverBootstrap.bind().sync() InterruptedException", e);
            }
        }

        @Override
        public void shutdown() {
            if (this.serverChannel != null) {
                try {
                    this.serverChannel.close().await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        @Override
        public ChannelEventListener getChannelEventListener() {
            return NettyRemotingServer.this.getChannelEventListener();
        }

        @Override
        public ExecutorService getCallbackExecutor() {
            return NettyRemotingServer.this.getCallbackExecutor();
        }
    }

    @ChannelHandler.Sharable
    public class NettyConnectManageHandler
    extends ChannelDuplexHandler {
        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("NETTY SERVER PIPELINE: channelRegistered {}", (Object)remoteAddress);
            super.channelRegistered(ctx);
        }

        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("NETTY SERVER PIPELINE: channelUnregistered, the channel[{}]", (Object)remoteAddress);
            super.channelUnregistered(ctx);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("NETTY SERVER PIPELINE: channelActive, the channel[{}]", (Object)remoteAddress);
            super.channelActive(ctx);
            if (NettyRemotingServer.this.channelEventListener != null) {
                NettyRemotingServer.this.putNettyEvent(new NettyEvent(NettyEventType.CONNECT, remoteAddress, ctx.channel()));
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("NETTY SERVER PIPELINE: channelInactive, the channel[{}]", (Object)remoteAddress);
            super.channelInactive(ctx);
            if (NettyRemotingServer.this.channelEventListener != null) {
                NettyRemotingServer.this.putNettyEvent(new NettyEvent(NettyEventType.CLOSE, remoteAddress, ctx.channel()));
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            IdleStateEvent event;
            if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                log.warn("NETTY SERVER PIPELINE: IDLE exception [{}]", (Object)remoteAddress);
                RemotingHelper.closeChannel(ctx.channel());
                if (NettyRemotingServer.this.channelEventListener != null) {
                    NettyRemotingServer.this.putNettyEvent(new NettyEvent(NettyEventType.IDLE, remoteAddress, ctx.channel()));
                }
            }
            ctx.fireUserEventTriggered(evt);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.warn("NETTY SERVER PIPELINE: exceptionCaught {}", (Object)remoteAddress);
            log.warn("NETTY SERVER PIPELINE: exceptionCaught exception.", cause);
            if (NettyRemotingServer.this.channelEventListener != null) {
                NettyRemotingServer.this.putNettyEvent(new NettyEvent(NettyEventType.EXCEPTION, remoteAddress, ctx.channel()));
            }
            RemotingHelper.closeChannel(ctx.channel());
        }
    }

    @ChannelHandler.Sharable
    public class NettyServerHandler
    extends SimpleChannelInboundHandler<RemotingCommand> {
        protected void channelRead0(ChannelHandlerContext ctx, RemotingCommand msg) {
            int localPort = RemotingHelper.parseSocketAddressPort(ctx.channel().localAddress());
            NettyRemotingAbstract remotingAbstract = (NettyRemotingAbstract)NettyRemotingServer.this.remotingServerTable.get(localPort);
            if (localPort != -1 && remotingAbstract != null) {
                remotingAbstract.processMessageReceived(ctx, msg);
                return;
            }
            RemotingHelper.closeChannel(ctx.channel());
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
            Channel channel = ctx.channel();
            if (channel.isWritable()) {
                if (!channel.config().isAutoRead()) {
                    channel.config().setAutoRead(true);
                    log.info("Channel[{}] turns writable, bytes to buffer before changing channel to un-writable: {}", (Object)RemotingHelper.parseChannelRemoteAddr(channel), (Object)channel.bytesBeforeUnwritable());
                }
            } else {
                channel.config().setAutoRead(false);
                log.warn("Channel[{}] auto-read is disabled, bytes to drain before it turns writable: {}", (Object)RemotingHelper.parseChannelRemoteAddr(channel), (Object)channel.bytesBeforeWritable());
            }
            super.channelWritabilityChanged(ctx);
        }
    }

    @ChannelHandler.Sharable
    public class HandshakeHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final TlsMode tlsMode;
        private static final byte HANDSHAKE_MAGIC_CODE = 22;

        HandshakeHandler(TlsMode tlsMode) {
            this.tlsMode = tlsMode;
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
            byte b = msg.getByte(0);
            if (b == 22) {
                switch (this.tlsMode) {
                    case DISABLED: {
                        ctx.close();
                        log.warn("Clients intend to establish an SSL connection while this server is running in SSL disabled mode");
                        break;
                    }
                    case PERMISSIVE: 
                    case ENFORCING: {
                        if (null != NettyRemotingServer.this.sslContext) {
                            ctx.pipeline().addAfter((EventExecutorGroup)NettyRemotingServer.this.defaultEventExecutorGroup, NettyRemotingServer.HANDSHAKE_HANDLER_NAME, NettyRemotingServer.TLS_HANDLER_NAME, (ChannelHandler)NettyRemotingServer.this.sslContext.newHandler(ctx.channel().alloc())).addAfter((EventExecutorGroup)NettyRemotingServer.this.defaultEventExecutorGroup, NettyRemotingServer.TLS_HANDLER_NAME, NettyRemotingServer.FILE_REGION_ENCODER_NAME, (ChannelHandler)new FileRegionEncoder());
                            log.info("Handlers prepended to channel pipeline to establish SSL connection");
                            break;
                        }
                        ctx.close();
                        log.error("Trying to establish an SSL connection but sslContext is null");
                        break;
                    }
                    default: {
                        log.warn("Unknown TLS mode");
                        break;
                    }
                }
            } else if (this.tlsMode == TlsMode.ENFORCING) {
                ctx.close();
                log.warn("Clients intend to establish an insecure connection while this server is running in SSL enforcing mode");
            }
            try {
                ctx.pipeline().remove((ChannelHandler)this);
            }
            catch (NoSuchElementException e) {
                log.error("Error while removing HandshakeHandler", (Throwable)e);
            }
            ctx.fireChannelRead((Object)msg.retain());
        }
    }
}

