/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.container;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.logfile.DefaultMappedFile;
import org.apache.rocketmq.store.logfile.MappedFile;
import org.apache.rocketmq.tieredstore.common.AppendResult;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.common.TieredStoreExecutor;
import org.apache.rocketmq.tieredstore.container.TieredFileQueue;
import org.apache.rocketmq.tieredstore.provider.TieredFileSegment;

public class TieredIndexFile {
    private static final Logger logger = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    public static final int INDEX_FILE_BEGIN_MAGIC_CODE = -1127939447;
    public static final int INDEX_FILE_END_MAGIC_CODE = -1127939451;
    private static final int INDEX_FILE_HEADER_SIZE = 28;
    public static final int INDEX_FILE_HASH_SLOT_SIZE = 8;
    public static final int INDEX_FILE_HASH_ORIGIN_INDEX_SIZE = 32;
    public static final int INDEX_FILE_HASH_COMPACT_INDEX_SIZE = 28;
    public static final int INDEX_FILE_HEADER_MAGIC_CODE_POSITION = 0;
    public static final int INDEX_FILE_HEADER_BEGIN_TIME_STAMP_POSITION = 4;
    public static final int INDEX_FILE_HEADER_END_TIME_STAMP_POSITION = 12;
    private static final int INDEX_FILE_HEADER_SLOT_NUM_POSITION = 20;
    private static final int INDEX_FILE_HEADER_INDEX_NUM_POSITION = 24;
    private static final String INDEX_FILE_DIR_NAME = "tiered_index_file";
    private static final String CUR_INDEX_FILE_NAME = "0000";
    private static final String PRE_INDEX_FILE_NAME = "1111";
    private static final String COMPACT_FILE_NAME = "2222";
    private final TieredMessageStoreConfig storeConfig;
    private final TieredFileQueue fileQueue;
    private final int maxHashSlotNum;
    private final int maxIndexNum;
    private final int fileMaxSize;
    private final String curFilePath;
    private final String preFilepath;
    private MappedFile preMappedFile;
    private MappedFile curMappedFile;
    private ReentrantLock curFileLock = new ReentrantLock();
    private Future<Void> inflightCompactFuture = CompletableFuture.completedFuture(null);

    protected TieredIndexFile(TieredMessageStoreConfig storeConfig) throws ClassNotFoundException, NoSuchMethodException, IOException {
        this.storeConfig = storeConfig;
        this.fileQueue = new TieredFileQueue(TieredFileSegment.FileSegmentType.INDEX, new MessageQueue("rmq_sys_INDEX", storeConfig.getBrokerName(), 0), storeConfig);
        if (this.fileQueue.getBaseOffset() == -1L) {
            this.fileQueue.setBaseOffset(0L);
        }
        this.maxHashSlotNum = storeConfig.getTieredStoreIndexFileMaxHashSlotNum();
        this.maxIndexNum = storeConfig.getTieredStoreIndexFileMaxIndexNum();
        this.fileMaxSize = 40 + this.maxHashSlotNum * 8 + this.maxIndexNum * 32 + 4;
        this.curFilePath = storeConfig.getStorePathRootDir() + File.separator + INDEX_FILE_DIR_NAME + File.separator + CUR_INDEX_FILE_NAME;
        this.preFilepath = storeConfig.getStorePathRootDir() + File.separator + INDEX_FILE_DIR_NAME + File.separator + PRE_INDEX_FILE_NAME;
        this.initFile();
        TieredStoreExecutor.COMMON_SCHEDULED_EXECUTOR.scheduleWithFixedDelay(() -> {
            try {
                this.curFileLock.lock();
                try {
                    Class<TieredIndexFile> clazz = TieredIndexFile.class;
                    synchronized (TieredIndexFile.class) {
                        MappedByteBuffer mappedByteBuffer = this.curMappedFile.getMappedByteBuffer();
                        int indexNum = mappedByteBuffer.getInt(24);
                        long lastIndexTime = mappedByteBuffer.getLong(12);
                        if (indexNum > 0 && System.currentTimeMillis() - lastIndexTime > (long)storeConfig.getTieredStoreIndexFileRollingIdleInterval()) {
                            mappedByteBuffer.putInt(this.fileMaxSize - 4, -1127939451);
                            this.rollingFile();
                        }
                        if (this.inflightCompactFuture.isDone() && this.preMappedFile != null && this.preMappedFile.isAvailable()) {
                            this.inflightCompactFuture = TieredStoreExecutor.COMPACT_INDEX_FILE_EXECUTOR.submit(new CompactTask(storeConfig, this.preMappedFile, this.fileQueue), null);
                        }
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                    }
                }
                finally {
                    this.curFileLock.unlock();
                }
            }
            catch (Throwable throwable) {
                logger.error("TieredIndexFile: submit compact index file task failed:", throwable);
            }
            {
                return;
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    private static boolean isFileSealed(MappedFile mappedFile) {
        return mappedFile.getMappedByteBuffer().getInt(mappedFile.getFileSize() - 4) == -1127939451;
    }

    private void initIndexFileHeader(MappedFile mappedFile) {
        MappedByteBuffer mappedByteBuffer = mappedFile.getMappedByteBuffer();
        if (mappedByteBuffer.getInt(0) != -1127939447) {
            mappedByteBuffer.putInt(0, -1127939447);
            mappedByteBuffer.putLong(4, -1L);
            mappedByteBuffer.putLong(12, -1L);
            mappedByteBuffer.putInt(20, 0);
            mappedByteBuffer.putInt(24, 0);
            for (int i = 0; i < this.maxHashSlotNum; ++i) {
                mappedByteBuffer.putInt(28 + i * 8, -1);
            }
            mappedByteBuffer.putInt(this.fileMaxSize - 4, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initFile() throws IOException {
        this.curMappedFile = new DefaultMappedFile(this.curFilePath, this.fileMaxSize);
        this.initIndexFileHeader(this.curMappedFile);
        File preFile = new File(this.preFilepath);
        boolean preFileExists = preFile.exists();
        if (preFileExists) {
            this.preMappedFile = new DefaultMappedFile(this.preFilepath, this.fileMaxSize);
        }
        if (TieredIndexFile.isFileSealed(this.curMappedFile)) {
            boolean rename;
            if (preFileExists) {
                preFile.delete();
            }
            if (rename = this.curMappedFile.renameTo(this.preFilepath)) {
                this.preMappedFile = this.curMappedFile;
                this.curMappedFile = new DefaultMappedFile(this.curFilePath, this.fileMaxSize);
                preFileExists = true;
            }
        }
        if (!preFileExists) return;
        Class<TieredIndexFile> clazz = TieredIndexFile.class;
        synchronized (TieredIndexFile.class) {
            if (!this.inflightCompactFuture.isDone()) return;
            this.inflightCompactFuture = TieredStoreExecutor.COMPACT_INDEX_FILE_EXECUTOR.submit(new CompactTask(this.storeConfig, this.preMappedFile, this.fileQueue), null);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    public AppendResult append(MessageQueue mq, int topicId, String key, long offset, int size, long timeStamp) {
        return this.putKey(mq, topicId, TieredIndexFile.indexKeyHashMethod(TieredIndexFile.buildKey(mq.getTopic(), key)), offset, size, timeStamp);
    }

    private boolean rollingFile() throws IOException {
        File preFile = new File(this.preFilepath);
        boolean preFileExists = preFile.exists();
        if (!preFileExists) {
            boolean rename = this.curMappedFile.renameTo(this.preFilepath);
            if (rename) {
                this.preMappedFile = this.curMappedFile;
                this.curMappedFile = new DefaultMappedFile(this.curFilePath, this.fileMaxSize);
                this.initIndexFileHeader(this.curMappedFile);
                this.tryToCompactPreFile();
                return true;
            }
            logger.error("TieredIndexFile#rollingFile: rename current file failed");
            return false;
        }
        this.tryToCompactPreFile();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToCompactPreFile() throws IOException {
        Class<TieredIndexFile> clazz = TieredIndexFile.class;
        synchronized (TieredIndexFile.class) {
            if (this.inflightCompactFuture.isDone()) {
                this.inflightCompactFuture = TieredStoreExecutor.COMPACT_INDEX_FILE_EXECUTOR.submit(new CompactTask(this.storeConfig, this.preMappedFile, this.fileQueue), null);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppendResult putKey(MessageQueue mq, int topicId, int hashCode, long offset, int size, long timeStamp) {
        this.curFileLock.lock();
        try {
            if (TieredIndexFile.isFileSealed(this.curMappedFile) && !this.rollingFile()) {
                AppendResult appendResult = AppendResult.FILE_FULL;
                return appendResult;
            }
            MappedByteBuffer mappedByteBuffer = this.curMappedFile.getMappedByteBuffer();
            int slotPosition = hashCode % this.maxHashSlotNum;
            int slotOffset = 28 + slotPosition * 8;
            int slotValue = mappedByteBuffer.getInt(slotOffset);
            long beginTimeStamp = mappedByteBuffer.getLong(4);
            if (beginTimeStamp == -1L) {
                mappedByteBuffer.putLong(4, timeStamp);
                beginTimeStamp = timeStamp;
            }
            int indexCount = mappedByteBuffer.getInt(24);
            int indexOffset = 28 + this.maxHashSlotNum * 8 + indexCount * 32;
            int timeDiff = (int)(timeStamp - beginTimeStamp);
            mappedByteBuffer.putInt(indexOffset, hashCode);
            mappedByteBuffer.putInt(indexOffset + 4, topicId);
            mappedByteBuffer.putInt(indexOffset + 4 + 4, mq.getQueueId());
            mappedByteBuffer.putLong(indexOffset + 4 + 4 + 4, offset);
            mappedByteBuffer.putInt(indexOffset + 4 + 4 + 4 + 8, size);
            mappedByteBuffer.putInt(indexOffset + 4 + 4 + 4 + 8 + 4, timeDiff);
            mappedByteBuffer.putInt(indexOffset + 4 + 4 + 4 + 8 + 4 + 4, slotValue);
            mappedByteBuffer.putInt(slotOffset, indexCount);
            mappedByteBuffer.putInt(24, ++indexCount);
            mappedByteBuffer.putLong(12, timeStamp);
            if (indexCount == this.maxIndexNum) {
                mappedByteBuffer.putInt(this.fileMaxSize - 4, -1127939451);
                this.rollingFile();
            }
            AppendResult appendResult = AppendResult.SUCCESS;
            return appendResult;
        }
        catch (Exception e) {
            logger.error("TieredIndexFile#putKey: put key failed:", (Throwable)e);
            AppendResult appendResult = AppendResult.IO_ERROR;
            return appendResult;
        }
        finally {
            this.curFileLock.unlock();
        }
    }

    public CompletableFuture<List<Pair<Long, ByteBuffer>>> queryAsync(String topic, String key, long beginTime, long endTime) {
        int hashCode = TieredIndexFile.indexKeyHashMethod(TieredIndexFile.buildKey(topic, key));
        int slotPosition = hashCode % this.maxHashSlotNum;
        List<TieredFileSegment> fileSegmentList = this.fileQueue.getFileListByTime(beginTime, endTime);
        CompletionStage<ArrayList<Object>> future = null;
        for (int i = fileSegmentList.size() - 1; i >= 0; --i) {
            TieredFileSegment fileSegment = fileSegmentList.get(i);
            CompletionStage tmpFuture = fileSegment.readAsync(28 + slotPosition * 8, 8).thenCompose(slotBuffer -> {
                int indexPosition = slotBuffer.getInt();
                if (indexPosition == -1) {
                    return CompletableFuture.completedFuture(null);
                }
                int indexSize = slotBuffer.getInt();
                if (indexSize <= 0) {
                    return CompletableFuture.completedFuture(null);
                }
                return fileSegment.readAsync(indexPosition, indexSize);
            });
            future = future == null ? ((CompletableFuture)tmpFuture).thenApply(indexBuffer -> {
                ArrayList<Pair> result = new ArrayList<Pair>();
                if (indexBuffer != null) {
                    result.add(Pair.of((Object)fileSegment.getBeginTimestamp(), (Object)indexBuffer));
                }
                return result;
            }) : future.thenCombine(tmpFuture, (indexList, indexBuffer) -> {
                if (indexBuffer != null) {
                    indexList.add(Pair.of((Object)fileSegment.getBeginTimestamp(), (Object)indexBuffer));
                }
                return indexList;
            });
        }
        return future == null ? CompletableFuture.completedFuture(new ArrayList()) : future;
    }

    public static String buildKey(String topic, String key) {
        return topic + "#" + key;
    }

    public static int indexKeyHashMethod(String key) {
        int keyHash = key.hashCode();
        int keyHashPositive = Math.abs(keyHash);
        if (keyHashPositive < 0) {
            keyHashPositive = 0;
        }
        return keyHashPositive;
    }

    public void commit(boolean sync) {
        this.fileQueue.commit(sync);
        if (sync) {
            try {
                this.inflightCompactFuture.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void cleanExpiredFile(long expireTimestamp) {
        this.fileQueue.cleanExpiredFile(expireTimestamp);
    }

    public void destroyExpiredFile() {
        this.fileQueue.destroyExpiredFile();
    }

    public void destroy() {
        String compactFilePath;
        File compactFile;
        this.inflightCompactFuture.cancel(true);
        if (this.preMappedFile != null) {
            this.preMappedFile.destroy(-1L);
        }
        if (this.curMappedFile != null) {
            this.curMappedFile.destroy(-1L);
        }
        if ((compactFile = new File(compactFilePath = this.storeConfig.getStorePathRootDir() + File.separator + INDEX_FILE_DIR_NAME + File.separator + COMPACT_FILE_NAME)).exists()) {
            compactFile.delete();
        }
        this.fileQueue.destroy();
    }

    static class CompactTask
    implements Runnable {
        private final TieredMessageStoreConfig storeConfig;
        private final int maxHashSlotNum;
        private final int maxIndexNum;
        private final int fileMaxSize;
        private MappedFile originFile;
        private TieredFileQueue fileQueue;
        private final MappedFile compactFile;

        public CompactTask(TieredMessageStoreConfig storeConfig, MappedFile originFile, TieredFileQueue fileQueue) throws IOException {
            this.storeConfig = storeConfig;
            this.maxHashSlotNum = storeConfig.getTieredStoreIndexFileMaxHashSlotNum();
            this.maxIndexNum = storeConfig.getTieredStoreIndexFileMaxIndexNum();
            this.originFile = originFile;
            this.fileQueue = fileQueue;
            String compactFilePath = storeConfig.getStorePathRootDir() + File.separator + TieredIndexFile.INDEX_FILE_DIR_NAME + File.separator + TieredIndexFile.COMPACT_FILE_NAME;
            this.fileMaxSize = 40 + storeConfig.getTieredStoreIndexFileMaxHashSlotNum() * 8 + storeConfig.getTieredStoreIndexFileMaxIndexNum() * 32 + 4;
            File compactFile = new File(compactFilePath);
            if (compactFile.exists()) {
                compactFile.delete();
            }
            this.compactFile = new DefaultMappedFile(compactFilePath, this.fileMaxSize);
        }

        @Override
        public void run() {
            try {
                this.compact();
            }
            catch (Throwable throwable) {
                logger.error("TieredIndexFile#compactTask: compact index file failed:", throwable);
            }
        }

        public void compact() {
            if (!TieredIndexFile.isFileSealed(this.originFile)) {
                logger.error("[Bug]TieredIndexFile#CompactTask#compact: try to compact unsealed file");
                this.originFile.destroy(-1L);
                this.compactFile.destroy(-1L);
                return;
            }
            this.buildCompactFile();
            this.fileQueue.append(this.compactFile.getMappedByteBuffer());
            this.fileQueue.commit(true);
            this.compactFile.destroy(-1L);
            this.originFile.destroy(-1L);
        }

        private void buildCompactFile() {
            MappedByteBuffer originMappedByteBuffer = this.originFile.getMappedByteBuffer();
            MappedByteBuffer compactMappedByteBuffer = this.compactFile.getMappedByteBuffer();
            compactMappedByteBuffer.putInt(0, -1127939447);
            compactMappedByteBuffer.putLong(4, originMappedByteBuffer.getLong(4));
            compactMappedByteBuffer.putLong(12, originMappedByteBuffer.getLong(12));
            compactMappedByteBuffer.putInt(20, this.maxHashSlotNum);
            compactMappedByteBuffer.putInt(24, originMappedByteBuffer.getInt(24));
            int rePutSlotValue = 28 + this.maxHashSlotNum * 8;
            for (int i = 0; i < this.maxHashSlotNum; ++i) {
                int slotOffset = 28 + i * 8;
                int slotValue = originMappedByteBuffer.getInt(slotOffset);
                if (slotValue == -1) continue;
                int indexTotalSize = 0;
                int indexPosition = slotValue;
                while (indexPosition >= 0 && indexPosition < this.maxIndexNum) {
                    int indexOffset = 28 + this.maxHashSlotNum * 8 + indexPosition * 32;
                    int rePutIndexOffset = rePutSlotValue + indexTotalSize;
                    compactMappedByteBuffer.putInt(rePutIndexOffset, originMappedByteBuffer.getInt(indexOffset));
                    compactMappedByteBuffer.putInt(rePutIndexOffset + 4, originMappedByteBuffer.getInt(indexOffset + 4));
                    compactMappedByteBuffer.putInt(rePutIndexOffset + 4 + 4, originMappedByteBuffer.getInt(indexOffset + 4 + 4));
                    compactMappedByteBuffer.putLong(rePutIndexOffset + 4 + 4 + 4, originMappedByteBuffer.getLong(indexOffset + 4 + 4 + 4));
                    compactMappedByteBuffer.putInt(rePutIndexOffset + 4 + 4 + 4 + 8, originMappedByteBuffer.getInt(indexOffset + 4 + 4 + 4 + 8));
                    compactMappedByteBuffer.putInt(rePutIndexOffset + 4 + 4 + 4 + 8 + 4, originMappedByteBuffer.getInt(indexOffset + 4 + 4 + 4 + 8 + 4));
                    indexTotalSize += 28;
                    indexPosition = originMappedByteBuffer.getInt(indexOffset + 4 + 4 + 4 + 8 + 4 + 4);
                }
                compactMappedByteBuffer.putInt(slotOffset, rePutSlotValue);
                compactMappedByteBuffer.putInt(slotOffset + 4, indexTotalSize);
                rePutSlotValue += indexTotalSize;
            }
            compactMappedByteBuffer.putInt(0, -1127939451);
            compactMappedByteBuffer.putInt(rePutSlotValue, -1127939447);
            compactMappedByteBuffer.limit(rePutSlotValue + 4);
        }
    }
}

