/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.benchmark;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.example.benchmark.AclClient;
import org.apache.rocketmq.example.benchmark.StatsBenchmarkProducer;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.protocol.SerializeType;
import org.apache.rocketmq.srvutil.ServerUtil;

public class Producer {
    private static final Logger log = LoggerFactory.getLogger(Producer.class);
    private static byte[] msgBody;
    private static final int MAX_LENGTH_ASYNC_QUEUE = 10000;
    private static final int SLEEP_FOR_A_WHILE = 100;

    public static void main(String[] args) throws MQClientException {
        boolean asyncEnable;
        System.setProperty("rocketmq.serialize.type", SerializeType.ROCKETMQ.name());
        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
        CommandLine commandLine = ServerUtil.parseCmdLine((String)"benchmarkProducer", (String[])args, (Options)Producer.buildCommandlineOptions(options), (CommandLineParser)new DefaultParser());
        if (null == commandLine) {
            System.exit(-1);
        }
        final String topic = commandLine.hasOption('t') ? commandLine.getOptionValue('t').trim() : "BenchmarkTest";
        int messageSize = commandLine.hasOption('s') ? Integer.parseInt(commandLine.getOptionValue('s')) : 128;
        final boolean keyEnable = commandLine.hasOption('k') && Boolean.parseBoolean(commandLine.getOptionValue('k'));
        final int propertySize = commandLine.hasOption('p') ? Integer.parseInt(commandLine.getOptionValue('p')) : 0;
        final int tagCount = commandLine.hasOption('l') ? Integer.parseInt(commandLine.getOptionValue('l')) : 0;
        boolean msgTraceEnable = commandLine.hasOption('m') && Boolean.parseBoolean(commandLine.getOptionValue('m'));
        boolean aclEnable = commandLine.hasOption('a') && Boolean.parseBoolean(commandLine.getOptionValue('a'));
        final long messageNum = commandLine.hasOption('q') ? Long.parseLong(commandLine.getOptionValue('q')) : 0L;
        final boolean delayEnable = commandLine.hasOption('d') && Boolean.parseBoolean(commandLine.getOptionValue('d'));
        final int delayLevel = commandLine.hasOption('e') ? Integer.parseInt(commandLine.getOptionValue('e')) : 1;
        boolean bl = asyncEnable = commandLine.hasOption('y') && Boolean.parseBoolean(commandLine.getOptionValue('y'));
        int threadCount = asyncEnable ? 1 : (commandLine.hasOption('w') ? Integer.parseInt(commandLine.getOptionValue('w')) : 64);
        System.out.printf("topic: %s, threadCount: %d, messageSize: %d, keyEnable: %s, propertySize: %d, tagCount: %d, traceEnable: %s, aclEnable: %s, messageQuantity: %d, delayEnable: %s, delayLevel: %s, asyncEnable: %s%n", topic, threadCount, messageSize, keyEnable, propertySize, tagCount, msgTraceEnable, aclEnable, messageNum, delayEnable, delayLevel, asyncEnable);
        StringBuilder sb = new StringBuilder(messageSize);
        for (int i = 0; i < messageSize; ++i) {
            sb.append(RandomStringUtils.randomAlphanumeric((int)1));
        }
        msgBody = sb.toString().getBytes(StandardCharsets.UTF_8);
        ExecutorService sendThreadPool = Executors.newFixedThreadPool(threadCount);
        final StatsBenchmarkProducer statsBenchmark = new StatsBenchmarkProducer();
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("BenchmarkTimerThread-%d").daemon(true).build());
        final LinkedList<Long[]> snapshotList = new LinkedList<Long[]>();
        long[] msgNums = new long[threadCount];
        if (messageNum > 0L) {
            Arrays.fill(msgNums, messageNum / (long)threadCount);
            long mod = messageNum % (long)threadCount;
            if (mod > 0L) {
                msgNums[0] = msgNums[0] + mod;
            }
        }
        executorService.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                snapshotList.addLast(statsBenchmark.createSnapshot());
                if (snapshotList.size() > 10) {
                    snapshotList.removeFirst();
                }
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        executorService.scheduleAtFixedRate(new TimerTask(){

            private void printStats() {
                if (snapshotList.size() >= 10) {
                    Producer.doPrintStats(snapshotList, statsBenchmark, false);
                }
            }

            @Override
            public void run() {
                try {
                    this.printStats();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 10000L, 10000L, TimeUnit.MILLISECONDS);
        RPCHook rpcHook = null;
        if (aclEnable) {
            String ak = commandLine.hasOption("ak") ? String.valueOf(commandLine.getOptionValue("ak")) : "rocketmq2";
            String sk = commandLine.hasOption("sk") ? String.valueOf(commandLine.getOptionValue("sk")) : "12345678";
            rpcHook = AclClient.getAclRPCHook(ak, sk);
        }
        final DefaultMQProducer producer = new DefaultMQProducer("benchmark_producer", rpcHook, msgTraceEnable, null);
        producer.setInstanceName(Long.toString(System.currentTimeMillis()));
        if (commandLine.hasOption('n')) {
            String ns = commandLine.getOptionValue('n');
            producer.setNamesrvAddr(ns);
        }
        producer.setCompressMsgBodyOverHowmuch(Integer.MAX_VALUE);
        producer.start();
        for (int i = 0; i < threadCount; ++i) {
            final long msgNumLimit = msgNums[i];
            if (messageNum > 0L && msgNumLimit == 0L) break;
            sendThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    int num = 0;
                    do {
                        try {
                            Message msg = Producer.buildMessage(topic);
                            final long beginTimestamp = System.currentTimeMillis();
                            if (keyEnable) {
                                msg.setKeys(String.valueOf(beginTimestamp / 1000L));
                            }
                            if (delayEnable) {
                                msg.setDelayTimeLevel(delayLevel);
                            }
                            if (tagCount > 0) {
                                msg.setTags(String.format("tag%d", System.currentTimeMillis() % (long)tagCount));
                            }
                            if (propertySize > 0) {
                                if (msg.getProperties() != null) {
                                    msg.getProperties().clear();
                                }
                                int i = 0;
                                int startValue = new Random(System.currentTimeMillis()).nextInt(100);
                                int size = 0;
                                while (true) {
                                    String prop1 = "prop" + i;
                                    String prop1V = "hello" + startValue;
                                    String prop2 = "prop" + (i + 1);
                                    String prop2V = String.valueOf(startValue);
                                    msg.putUserProperty(prop1, prop1V);
                                    msg.putUserProperty(prop2, prop2V);
                                    if ((size += prop1.length() + prop2.length() + prop1V.length() + prop2V.length()) > propertySize) break;
                                    i += 2;
                                    startValue += 2;
                                }
                            }
                            if (asyncEnable) {
                                ThreadPoolExecutor e = (ThreadPoolExecutor)producer.getDefaultMQProducerImpl().getAsyncSenderExecutor();
                                while (e.getQueue().size() > 10000) {
                                    Thread.sleep(100L);
                                }
                                producer.send(msg, new SendCallback(){

                                    public void onSuccess(SendResult sendResult) {
                                        Producer.updateStatsSuccess(statsBenchmark, beginTimestamp);
                                    }

                                    public void onException(Throwable e) {
                                        statsBenchmark.getSendRequestFailedCount().increment();
                                    }
                                });
                                continue;
                            }
                            producer.send(msg);
                            Producer.updateStatsSuccess(statsBenchmark, beginTimestamp);
                        }
                        catch (RemotingException e) {
                            statsBenchmark.getSendRequestFailedCount().increment();
                            log.error("[BENCHMARK_PRODUCER] Send Exception", (Throwable)e);
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        catch (InterruptedException e) {
                            statsBenchmark.getSendRequestFailedCount().increment();
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        catch (MQClientException e) {
                            statsBenchmark.getSendRequestFailedCount().increment();
                            log.error("[BENCHMARK_PRODUCER] Send Exception", (Throwable)e);
                        }
                        catch (MQBrokerException e) {
                            statsBenchmark.getReceiveResponseFailedCount().increment();
                            log.error("[BENCHMARK_PRODUCER] Send Exception", (Throwable)e);
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    } while (messageNum <= 0L || (long)(++num) < msgNumLimit);
                }
            });
        }
        try {
            sendThreadPool.shutdown();
            sendThreadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            executorService.shutdown();
            try {
                executorService.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if (snapshotList.size() > 1) {
                Producer.doPrintStats(snapshotList, statsBenchmark, true);
            } else {
                System.out.printf("[Complete] Send Total: %d Send Failed: %d Response Failed: %d%n", statsBenchmark.getSendRequestSuccessCount().longValue() + statsBenchmark.getSendRequestFailedCount().longValue(), statsBenchmark.getSendRequestFailedCount().longValue(), statsBenchmark.getReceiveResponseFailedCount().longValue());
            }
            producer.shutdown();
        }
        catch (InterruptedException e) {
            log.error("[Exit] Thread Interrupted Exception", (Throwable)e);
        }
    }

    private static void updateStatsSuccess(StatsBenchmarkProducer statsBenchmark, long beginTimestamp) {
        boolean updated;
        statsBenchmark.getSendRequestSuccessCount().increment();
        statsBenchmark.getReceiveResponseSuccessCount().increment();
        long currentRT = System.currentTimeMillis() - beginTimestamp;
        statsBenchmark.getSendMessageSuccessTimeTotal().add(currentRT);
        long prevMaxRT = statsBenchmark.getSendMessageMaxRT().longValue();
        while (currentRT > prevMaxRT && !(updated = statsBenchmark.getSendMessageMaxRT().compareAndSet(prevMaxRT, currentRT))) {
            prevMaxRT = statsBenchmark.getSendMessageMaxRT().longValue();
        }
    }

    public static Options buildCommandlineOptions(Options options) {
        Option opt = new Option("w", "threadCount", true, "Thread count, Default: 64");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("s", "messageSize", true, "Message Size, Default: 128");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("k", "keyEnable", true, "Message Key Enable, Default: false");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("t", "topic", true, "Topic name, Default: BenchmarkTest");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("l", "tagCount", true, "Tag count, Default: 0");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("m", "msgTraceEnable", true, "Message Trace Enable, Default: false");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("a", "aclEnable", true, "Acl Enable, Default: false");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("ak", "accessKey", true, "Acl access key, Default: 12345678");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("sk", "secretKey", true, "Acl secret key, Default: rocketmq2");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("q", "messageQuantity", true, "Send message quantity, Default: 0, running forever");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("d", "delayEnable", true, "Delay message Enable, Default: false");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("e", "delayLevel", true, "Delay message level, Default: 1");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("y", "asyncEnable", true, "Enable async produce, Default: false");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    private static Message buildMessage(String topic) {
        return new Message(topic, msgBody);
    }

    private static void doPrintStats(LinkedList<Long[]> snapshotList, StatsBenchmarkProducer statsBenchmark, boolean done) {
        Long[] begin = snapshotList.getFirst();
        Long[] end = snapshotList.getLast();
        long sendTps = (long)((double)(end[3] - begin[3]) / (double)(end[0] - begin[0]) * 1000.0);
        double averageRT = (double)(end[5] - begin[5]) / (double)(end[3] - begin[3]);
        if (done) {
            System.out.printf("[Complete] Send Total: %d | Send TPS: %d | Max RT(ms): %d | Average RT(ms): %7.3f | Send Failed: %d | Response Failed: %d%n", statsBenchmark.getSendRequestSuccessCount().longValue() + statsBenchmark.getSendRequestFailedCount().longValue(), sendTps, statsBenchmark.getSendMessageMaxRT().longValue(), averageRT, end[2], end[4]);
        } else {
            System.out.printf("Current Time: %s | Send TPS: %d | Max RT(ms): %d | Average RT(ms): %7.3f | Send Failed: %d | Response Failed: %d%n", UtilAll.timeMillisToHumanString2((long)System.currentTimeMillis()), sendTps, statsBenchmark.getSendMessageMaxRT().longValue(), averageRT, end[2], end[4]);
        }
    }
}

