/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import java.util.Objects;

public final class Intrinsics {
    private Intrinsics() {
    }

    public static <T> boolean isEmpty(Object value) {
        return value == null;
    }

    public static <T> T empty() {
        return null;
    }

    public static <T> T cast(Object value) {
        return (T)value;
    }

    public static <T> T[] newArray(int arraySize) {
        return new Object[arraySize];
    }

    public static <T> boolean equals(EqualityFunction delegate, Object e1, Object e2) {
        return delegate.equals(e1, e2);
    }

    public static <T> boolean equals(Object e1, Object e2) {
        return Objects.equals(e1, e2);
    }

    public static <T> T add(T op1, T op2) {
        if (op1.getClass() != op2.getClass()) {
            throw new RuntimeException("Arguments of different classes: " + op1 + " " + op2);
        }
        if (Byte.class.isInstance(op1)) {
            return (T)Byte.valueOf((byte)((Byte)op1 + (Byte)op2));
        }
        if (Short.class.isInstance(op1)) {
            return (T)Short.valueOf((short)((Short)op1 + (Short)op2));
        }
        if (Character.class.isInstance(op1)) {
            return (T)Character.valueOf((char)(((Character)op1).charValue() + ((Character)op2).charValue()));
        }
        if (Integer.class.isInstance(op1)) {
            return (T)Integer.valueOf((Integer)op1 + (Integer)op2);
        }
        if (Float.class.isInstance(op1)) {
            return (T)Float.valueOf(((Float)op1).floatValue() + ((Float)op2).floatValue());
        }
        if (Long.class.isInstance(op1)) {
            return (T)Long.valueOf((Long)op1 + (Long)op2);
        }
        if (Double.class.isInstance(op1)) {
            return (T)Double.valueOf((Double)op1 + (Double)op2);
        }
        throw new UnsupportedOperationException("Invalid for arbitrary types: " + op1 + " " + op2);
    }

    public static interface KeyHasher<T> {
        public int hashKey(T var1);
    }

    public static interface EqualityFunction {
        public boolean equals(Object var1, Object var2);
    }
}

