/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema;

import java.util.Map;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchema;
import org.apache.nifi.minifi.toolkit.schema.common.WritableSchema;

public class SwapSchema
extends BaseSchema
implements WritableSchema {
    public static final String THRESHOLD_KEY = "threshold";
    public static final String IN_PERIOD_KEY = "in period";
    public static final String IN_THREADS_KEY = "in threads";
    public static final String OUT_PERIOD_KEY = "out period";
    public static final String OUT_THREADS_KEY = "out threads";
    public static final int DEFAULT_THRESHOLD = 20000;
    public static final String DEFAULT_IN_PERIOD = "5 sec";
    public static final int DEFAULT_IN_THREADS = 1;
    public static final String DEFAULT_OUT_PERIOD = "5 sec";
    public static final int DEFAULT_OUT_THREADS = 4;
    private Number threshold = 20000;
    private String inPeriod = "5 sec";
    private Number inThreads = 1;
    private String outPeriod = "5 sec";
    private Number outThreads = 4;

    public SwapSchema() {
    }

    public SwapSchema(Map map) {
        this.threshold = this.getOptionalKeyAsType(map, THRESHOLD_KEY, Number.class, "Swap", 20000);
        this.inPeriod = this.getOptionalKeyAsType(map, IN_PERIOD_KEY, String.class, "Swap", "5 sec");
        this.inThreads = this.getOptionalKeyAsType(map, IN_THREADS_KEY, Number.class, "Swap", 1);
        this.outPeriod = this.getOptionalKeyAsType(map, OUT_PERIOD_KEY, String.class, "Swap", "5 sec");
        this.outThreads = this.getOptionalKeyAsType(map, OUT_THREADS_KEY, Number.class, "Swap", 4);
    }

    @Override
    public Map<String, Object> toMap() {
        Map result = (Map)this.mapSupplier.get();
        result.put(THRESHOLD_KEY, this.threshold);
        result.put(IN_PERIOD_KEY, this.inPeriod);
        result.put(IN_THREADS_KEY, this.inThreads);
        result.put(OUT_PERIOD_KEY, this.outPeriod);
        result.put(OUT_THREADS_KEY, this.outThreads);
        return result;
    }

    public Number getThreshold() {
        return this.threshold;
    }

    public String getInPeriod() {
        return this.inPeriod;
    }

    public Number getInThreads() {
        return this.inThreads;
    }

    public String getOutPeriod() {
        return this.outPeriod;
    }

    public Number getOutThreads() {
        return this.outThreads;
    }
}

