/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.exception;

import java.sql.SQLException;
import lombok.Generated;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.output.MigrateErrorResult;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.internal.sqlscript.FlywaySqlScriptException;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.util.ExceptionUtils;

public class FlywayMigrateException
extends FlywayException {
    private final MigrationInfo migration;
    private final boolean executableInTransaction;
    private final boolean outOfOrder;
    private final MigrateErrorResult errorResult;
    private final int lineNumber;
    private final String absolutePathOnDisk;
    private final String sqlState;
    private final int sqlErrorCode;

    public ErrorCode getMigrationErrorCode() {
        if (this.migration.getVersion() != null) {
            if (this.migration.getType().isBaseline()) {
                return CoreErrorCode.FAILED_BASELINE_MIGRATION;
            }
            return CoreErrorCode.FAILED_VERSIONED_MIGRATION;
        }
        return CoreErrorCode.FAILED_REPEATABLE_MIGRATION;
    }

    public FlywayMigrateException(MigrationInfo migration, boolean outOfOrder, SQLException e, boolean canExecuteInTransaction, MigrateResult partialResult) {
        super(ExceptionUtils.toMessage(e), e);
        this.migration = migration;
        this.outOfOrder = outOfOrder;
        this.executableInTransaction = canExecuteInTransaction;
        this.errorResult = new MigrateErrorResult(partialResult, this);
        this.lineNumber = -1;
        this.absolutePathOnDisk = migration.getScript();
        this.sqlState = e.getSQLState();
        this.sqlErrorCode = e.getErrorCode();
    }

    public FlywayMigrateException(MigrationInfo migration, String message, boolean canExecuteInTransaction, MigrateResult partialResult) {
        super(message);
        this.outOfOrder = false;
        this.migration = migration;
        this.executableInTransaction = canExecuteInTransaction;
        this.errorResult = new MigrateErrorResult(partialResult, this);
        this.lineNumber = -1;
        this.absolutePathOnDisk = migration.getScript();
        this.sqlState = null;
        this.sqlErrorCode = 0;
    }

    public FlywayMigrateException(MigrationInfo migration, boolean outOfOrder, FlywayException e, boolean canExecuteInTransaction, MigrateResult partialResult) {
        super(e.getMessage(), e);
        if (e instanceof FlywaySqlScriptException) {
            FlywaySqlScriptException flywaySqlScriptException = (FlywaySqlScriptException)e;
            this.lineNumber = flywaySqlScriptException.getLineNumber();
            this.absolutePathOnDisk = flywaySqlScriptException.getResource().getAbsolutePathOnDisk();
            this.sqlState = flywaySqlScriptException.getSqlState();
            this.sqlErrorCode = flywaySqlScriptException.getSqlErrorCode();
        } else {
            this.lineNumber = -1;
            this.absolutePathOnDisk = migration.getScript();
            this.sqlState = null;
            this.sqlErrorCode = 0;
        }
        this.migration = migration;
        this.outOfOrder = outOfOrder;
        this.executableInTransaction = canExecuteInTransaction;
        this.errorResult = new MigrateErrorResult(partialResult, this);
    }

    public FlywayMigrateException(MigrationInfo migration, boolean outOfOrder, String message, FlywayException e, boolean canExecuteInTransaction, MigrateResult partialResult, SqlStatement sqlStatement) {
        super(message, e.getCause());
        this.lineNumber = sqlStatement.getLineNumber();
        this.absolutePathOnDisk = migration.getScript();
        this.migration = migration;
        this.outOfOrder = outOfOrder;
        this.executableInTransaction = canExecuteInTransaction;
        this.errorResult = new MigrateErrorResult(partialResult, this);
        if (e instanceof FlywaySqlScriptException) {
            FlywaySqlScriptException flywaySqlScriptException = (FlywaySqlScriptException)e;
            this.sqlState = flywaySqlScriptException.getSqlState();
            this.sqlErrorCode = flywaySqlScriptException.getSqlErrorCode();
        } else {
            this.sqlState = null;
            this.sqlErrorCode = 0;
        }
    }

    @Generated
    public MigrationInfo getMigration() {
        return this.migration;
    }

    @Generated
    public boolean isExecutableInTransaction() {
        return this.executableInTransaction;
    }

    @Generated
    public boolean isOutOfOrder() {
        return this.outOfOrder;
    }

    @Generated
    public MigrateErrorResult getErrorResult() {
        return this.errorResult;
    }

    @Generated
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Generated
    public String getAbsolutePathOnDisk() {
        return this.absolutePathOnDisk;
    }

    @Generated
    public String getSqlState() {
        return this.sqlState;
    }

    @Generated
    public int getSqlErrorCode() {
        return this.sqlErrorCode;
    }
}

