/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.output;

import java.util.Collection;
import java.util.List;
import org.flywaydb.core.api.output.MigrateErrorResult;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.api.output.errors.ErrorOutputItem;
import org.flywaydb.core.api.output.errors.ExceptionToErrorObjectConverter;
import org.flywaydb.core.api.output.errors.FaultToErrorObjectConverter;
import org.flywaydb.core.api.output.errors.FlywayExceptionToErrorObjectConverter;
import org.flywaydb.core.api.output.errors.FlywayMigrateExceptionToErrorObjectConverter;
import org.flywaydb.core.api.output.errors.FlywaySqlExceptionToErrorObjectConverter;
import org.flywaydb.core.internal.exception.FlywayMigrateException;

public record ErrorOutput(ErrorOutputItem error) implements OperationResult
{
    private static final Collection<ExceptionToErrorObjectConverter<? extends Exception, ? extends ErrorOutputItem>> ERROR_OBJECT_CONVERTERS = List.of(new FlywayMigrateExceptionToErrorObjectConverter(), new FlywaySqlExceptionToErrorObjectConverter(), new FlywayExceptionToErrorObjectConverter());

    public static ErrorOutput fromException(Exception exception) {
        ExceptionToErrorObjectConverter converter = ERROR_OBJECT_CONVERTERS.stream().filter(x -> x.getSupportedExceptionType().isInstance(exception)).findFirst().orElse(new FaultToErrorObjectConverter());
        return new ErrorOutput((ErrorOutputItem)ErrorOutput.convertException(converter, exception));
    }

    public static MigrateErrorResult fromMigrateException(FlywayMigrateException exception) {
        return exception.getErrorResult();
    }

    public static OperationResult toOperationResult(Exception exception) {
        if (exception instanceof FlywayMigrateException) {
            return ErrorOutput.fromMigrateException((FlywayMigrateException)exception);
        }
        return ErrorOutput.fromException(exception);
    }

    private static <E extends Exception, T extends ErrorOutputItem> T convertException(ExceptionToErrorObjectConverter<E, T> converter, Exception exception) {
        return converter.convert((Exception)converter.getSupportedExceptionType().cast(exception));
    }
}

