/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.search.ahocorasick;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.util.search.SearchTerm;
import org.apache.nifi.util.search.ahocorasick.Node;

public class SearchState<T> {
    private Node currentNode;
    private final Map<SearchTerm<T>, List<Long>> resultMap = new HashMap<SearchTerm<T>, List<Long>>(5);
    private long bytesRead;

    SearchState(Node rootNode) {
        this.currentNode = rootNode;
        this.bytesRead = 0L;
    }

    void incrementBytesRead(long increment) {
        this.bytesRead += increment;
    }

    void setCurrentNode(Node curr) {
        this.currentNode = curr;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public Map<SearchTerm<T>, List<Long>> getResults() {
        return new HashMap<SearchTerm<T>, List<Long>>(this.resultMap);
    }

    void addResult(SearchTerm matchingTerm) {
        List<Object> indexes = this.resultMap.containsKey(matchingTerm) ? this.resultMap.get(matchingTerm) : new ArrayList(5);
        indexes.add(this.bytesRead);
        this.resultMap.put(matchingTerm, indexes);
    }

    public boolean foundMatch() {
        return !this.resultMap.isEmpty();
    }
}

