/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.attribute.expression.language.VariableImpact;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.parameter.StandardParameterTokenList;

public class PropertyConfiguration {
    public static PropertyConfiguration EMPTY = new PropertyConfiguration(null, (ParameterTokenList)new StandardParameterTokenList(null, Collections.emptyList()), Collections.emptyList(), VariableImpact.NEVER_IMPACTED);
    private final String rawValue;
    private final ParameterTokenList parameterTokenList;
    private final List<ParameterReference> parameterReferences;
    private final VariableImpact variableImpact;
    private final AtomicReference<ComputedEffectiveValue> effectiveValue = new AtomicReference();

    public PropertyConfiguration(String rawValue, ParameterTokenList tokenList, List<ParameterReference> parameterReferences, VariableImpact variableImpact) {
        this.rawValue = rawValue;
        this.parameterTokenList = tokenList;
        this.parameterReferences = parameterReferences;
        this.variableImpact = variableImpact;
    }

    public VariableImpact getVariableImpact() {
        return this.variableImpact;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public String getEffectiveValue(ParameterLookup parameterLookup) {
        if (this.rawValue == null) {
            return null;
        }
        if (this.parameterTokenList == null) {
            return this.rawValue;
        }
        ComputedEffectiveValue computedEffectiveValue = this.effectiveValue.get();
        if (computedEffectiveValue != null && computedEffectiveValue.matches(parameterLookup)) {
            return computedEffectiveValue.getValue();
        }
        String substituted = this.parameterTokenList.substitute(parameterLookup);
        ComputedEffectiveValue updatedValue = new ComputedEffectiveValue(parameterLookup, substituted);
        this.effectiveValue.compareAndSet(computedEffectiveValue, updatedValue);
        return substituted;
    }

    public List<ParameterReference> getParameterReferences() {
        return this.parameterReferences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof PropertyConfiguration)) {
            return false;
        }
        PropertyConfiguration that = (PropertyConfiguration)o;
        return Objects.equals(this.rawValue, that.rawValue);
    }

    public int hashCode() {
        return Objects.hash(this.rawValue);
    }

    public static class ComputedEffectiveValue {
        private final ParameterLookup parameterLookup;
        private final long contextVersion;
        private final String value;

        public ComputedEffectiveValue(ParameterLookup parameterLookup, String value) {
            this.parameterLookup = parameterLookup;
            this.contextVersion = parameterLookup == null ? -1L : parameterLookup.getVersion();
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean matches(ParameterLookup parameterLookup) {
            if (!Objects.equals(parameterLookup, this.parameterLookup)) {
                return false;
            }
            if (parameterLookup == null) {
                return true;
            }
            return parameterLookup.getVersion() == this.contextVersion;
        }
    }
}

