/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import jpt30.lang.model.element.ModuleElement;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.indexing.TransactionContext;
import org.netbeans.modules.java.source.usages.BuildArtifactMapperImpl;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public final class ClassIndexEventsTransaction
extends TransactionContext.Service {
    private final boolean source;
    private final Supplier<Boolean> isAllFilesIndexing;
    private Set<URL> removedRoots;
    private ElementHandle<ModuleElement> addedModule;
    private ElementHandle<ModuleElement> removedModule;
    private ElementHandle<ModuleElement> changedModule;
    private Collection<ElementHandle<TypeElement>> addedTypes;
    private Collection<ElementHandle<TypeElement>> removedTypes;
    private Collection<ElementHandle<TypeElement>> changedTypes;
    private Collection<File> addedFiles;
    private Collection<File> removedFiles;
    private URL addedRoot;
    private URL changesInRoot;
    private boolean closed;

    private ClassIndexEventsTransaction(boolean src, Supplier<Boolean> allFilesIndexing) {
        this.source = src;
        this.isAllFilesIndexing = allFilesIndexing;
        this.removedRoots = new HashSet<URL>();
        this.addedTypes = new HashSet<ElementHandle<TypeElement>>();
        this.removedTypes = new HashSet<ElementHandle<TypeElement>>();
        this.changedTypes = new HashSet<ElementHandle<TypeElement>>();
        this.addedFiles = new ArrayDeque<File>();
        this.removedFiles = new ArrayDeque<File>();
    }

    public void rootAdded(@NonNull URL root) {
        this.checkClosedTx();
        assert (root != null);
        assert (this.addedRoot == null || this.addedRoot.equals(root));
        assert (this.changesInRoot == null || this.changesInRoot.equals(root));
        this.addedRoot = root;
    }

    public void rootRemoved(@NonNull URL root) {
        this.checkClosedTx();
        assert (root != null);
        this.removedRoots.add(root);
    }

    public void addedTypes(@NonNull URL root, @NullAllowed ElementHandle<ModuleElement> module, @NonNull Collection<? extends ElementHandle<TypeElement>> added) {
        this.checkClosedTx();
        assert (root != null);
        assert (added != null);
        assert (this.changesInRoot == null || this.changesInRoot.equals(root));
        assert (this.addedRoot == null || this.addedRoot.equals(root));
        assert (this.addedModule == null || module == null);
        this.addedModule = ClassIndexEventsTransaction.reduce(this.addedModule, module);
        this.addedTypes.addAll(added);
        this.changesInRoot = root;
    }

    public void removedTypes(@NonNull URL root, @NullAllowed ElementHandle<ModuleElement> module, @NonNull Collection<? extends ElementHandle<TypeElement>> removed) {
        this.checkClosedTx();
        assert (root != null);
        assert (removed != null);
        assert (this.changesInRoot == null || this.changesInRoot.equals(root));
        assert (this.addedRoot == null || this.addedRoot.equals(root));
        assert (this.removedModule == null || module == null);
        this.removedModule = ClassIndexEventsTransaction.reduce(this.removedModule, module);
        this.removedTypes.addAll(removed);
        this.changesInRoot = root;
    }

    public void changedTypes(@NonNull URL root, @NullAllowed ElementHandle<ModuleElement> module, @NonNull Collection<? extends ElementHandle<TypeElement>> changed) {
        this.checkClosedTx();
        assert (root != null);
        assert (changed != null);
        assert (this.changesInRoot == null || this.changesInRoot.equals(root));
        assert (this.addedRoot == null || this.addedRoot.equals(root));
        assert (this.changedModule == null || module == null);
        this.changedModule = ClassIndexEventsTransaction.reduce(this.changedModule, module);
        this.changedTypes.addAll(changed);
        this.changesInRoot = root;
    }

    public void addedCacheFiles(@NonNull URL root, @NonNull Collection<? extends File> files) throws IllegalStateException {
        this.checkClosedTx();
        Parameters.notNull("root", root);
        Parameters.notNull("files", files);
        if (!this.source) {
            throw new IllegalStateException("The addedCacheFiles can be called only for source root.");
        }
        assert (this.changesInRoot == null || this.changesInRoot.equals(root));
        assert (this.addedRoot == null || this.addedRoot.equals(root));
        this.addedFiles.addAll(files);
        this.changesInRoot = root;
    }

    public void removedCacheFiles(@NonNull URL root, @NonNull Collection<? extends File> files) throws IllegalStateException {
        this.checkClosedTx();
        Parameters.notNull("root", root);
        Parameters.notNull("files", files);
        if (!this.source) {
            throw new IllegalStateException("The removedCacheFiles can be called only for source root.");
        }
        assert (this.changesInRoot == null || this.changesInRoot.equals(root));
        assert (this.addedRoot == null || this.addedRoot.equals(root));
        this.removedFiles.addAll(files);
        this.changesInRoot = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void commit() throws IOException {
        this.closeTx();
        try {
            block12: {
                try {
                    if (this.addedFiles.isEmpty() && this.removedFiles.isEmpty()) break block12;
                    assert (this.changesInRoot != null);
                    BuildArtifactMapperImpl.classCacheUpdated(this.changesInRoot, JavaIndex.getClassFolder(this.changesInRoot), Collections.unmodifiableCollection(this.removedFiles), Collections.unmodifiableCollection(this.addedFiles), false, this.isAllFilesIndexing.get());
                }
                catch (Throwable throwable) {
                    ClassIndexManager ciManager = ClassIndexManager.getDefault();
                    ClassIndexImpl ci = this.addedRoot == null ? null : ciManager.getUsagesQuery(this.addedRoot, false);
                    Set added = ci != null && ci.getState() == ClassIndexImpl.State.INITIALIZED ? Collections.singleton(this.addedRoot) : Collections.emptySet();
                    ciManager.fire(added, Collections.unmodifiableSet(this.removedRoots));
                    if (this.changesInRoot != null) {
                        if (ci == null) {
                            ci = ciManager.getUsagesQuery(this.changesInRoot, false);
                        }
                        if (ci != null) {
                            ci.typesEvent(this.changesInRoot, Pair.of(this.addedModule, Collections.unmodifiableCollection(this.addedTypes)), Pair.of(this.removedModule, Collections.unmodifiableCollection(this.removedTypes)), Pair.of(this.changedModule, Collections.unmodifiableCollection(this.changedTypes)));
                        }
                    }
                    throw throwable;
                }
            }
            ClassIndexManager ciManager = ClassIndexManager.getDefault();
            ClassIndexImpl ci = this.addedRoot == null ? null : ciManager.getUsagesQuery(this.addedRoot, false);
            Set added = ci != null && ci.getState() == ClassIndexImpl.State.INITIALIZED ? Collections.singleton(this.addedRoot) : Collections.emptySet();
            ciManager.fire(added, Collections.unmodifiableSet(this.removedRoots));
            if (this.changesInRoot != null) {
                if (ci == null) {
                    ci = ciManager.getUsagesQuery(this.changesInRoot, false);
                }
                if (ci != null) {
                    ci.typesEvent(this.changesInRoot, Pair.of(this.addedModule, Collections.unmodifiableCollection(this.addedTypes)), Pair.of(this.removedModule, Collections.unmodifiableCollection(this.removedTypes)), Pair.of(this.changedModule, Collections.unmodifiableCollection(this.changedTypes)));
                }
            }
        }
        finally {
            this.clear();
        }
    }

    @Override
    protected void rollBack() throws IOException {
        this.closeTx();
        this.clear();
    }

    private void clear() {
        this.addedRoot = null;
        this.changesInRoot = null;
        this.removedRoots = null;
        this.addedTypes = null;
        this.removedTypes = null;
        this.changedTypes = null;
        this.addedFiles = null;
        this.removedFiles = null;
    }

    private void checkClosedTx() {
        if (this.closed) {
            throw new IllegalStateException("Already commited or rolled back transaction.");
        }
    }

    private void closeTx() {
        this.checkClosedTx();
        this.closed = true;
    }

    private static <T> T reduce(T oldValue, T newValue) {
        return newValue != null ? newValue : oldValue;
    }

    @NonNull
    public static ClassIndexEventsTransaction create(boolean source, Supplier<Boolean> isAllFilesIndexing) {
        return new ClassIndexEventsTransaction(source, isAllFilesIndexing);
    }
}

