/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * CSS variables generated by https://github.com/twbs/bootstrap/blob/v5.3.7/scss/_root.scss.
 */
export class Root {
  static readonly blue = "#0d6efd";
  static readonly indigo = "#6610f2";
  static readonly purple = "#6f42c1";
  static readonly pink = "#d63384";
  static readonly red = "#dc3545";
  static readonly orange = "#fd7e14";
  static readonly yellow = "#ffc107";
  static readonly green = "#198754";
  static readonly teal = "#20c997";
  static readonly cyan = "#0dcaf0";
  static readonly black = "#000";
  static readonly white = "rgb(255, 255, 255)";
  static readonly gray = "#6c757d";
  static readonly grayDark = "#343a40";
  static readonly gray100 = "#f8f9fa";
  static readonly gray200 = "#e9ecef";
  static readonly gray300 = "#dee2e6";
  static readonly gray400 = "#ced4da";
  static readonly gray500 = "#adb5bd";
  static readonly gray600 = "#6c757d";
  static readonly gray700 = "#495057";
  static readonly gray800 = "#343a40";
  static readonly gray900 = "#212529";
  static readonly primary = "rgb(13, 110, 253)";
  static readonly secondary = "#6c757d";
  static readonly success = "#198754";
  static readonly info = "#0dcaf0";
  static readonly warning = "#ffc107";
  static readonly danger = "#dc3545";
  static readonly light = "#f8f9fa";
  static readonly dark = "#212529";
  static readonly primaryRgb = "13, 110, 253";
  static readonly secondaryRgb = "108, 117, 125";
  static readonly successRgb = "25, 135, 84";
  static readonly infoRgb = "13, 202, 240";
  static readonly warningRgb = "255, 193, 7";
  static readonly dangerRgb = "220, 53, 69";
  static readonly lightRgb = "248, 249, 250";
  static readonly darkRgb = "33, 37, 41";
  static readonly primaryTextEmphasis = "rgb(5.2, 44, 101.2)";
  static readonly secondaryTextEmphasis = "rgb(43.2, 46.8, 50)";
  static readonly successTextEmphasis = "rgb(10, 54, 33.6)";
  static readonly infoTextEmphasis = "rgb(5.2, 80.8, 96)";
  static readonly warningTextEmphasis = "rgb(102, 77.2, 2.8)";
  static readonly dangerTextEmphasis = "rgb(88, 21.2, 27.6)";
  static readonly lightTextEmphasis = "#495057";
  static readonly darkTextEmphasis = "#495057";
  static readonly primaryBgSubtle = "rgb(206.6, 226, 254.6)";
  static readonly secondaryBgSubtle = "rgb(225.6, 227.4, 229)";
  static readonly successBgSubtle = "rgb(209, 231, 220.8)";
  static readonly infoBgSubtle = "rgb(206.6, 244.4, 252)";
  static readonly warningBgSubtle = "rgb(255, 242.6, 205.4)";
  static readonly dangerBgSubtle = "rgb(248, 214.6, 217.8)";
  static readonly lightBgSubtle = "rgb(251.5, 252, 252.5)";
  static readonly darkBgSubtle = "#ced4da";
  static readonly primaryBorderSubtle = "rgb(158.2, 197, 254.2)";
  static readonly secondaryBorderSubtle = "rgb(196.2, 199.8, 203)";
  static readonly successBorderSubtle = "rgb(163, 207, 186.6)";
  static readonly infoBorderSubtle = "rgb(158.2, 233.8, 249)";
  static readonly warningBorderSubtle = "rgb(255, 230.2, 155.8)";
  static readonly dangerBorderSubtle = "rgb(241, 174.2, 180.6)";
  static readonly lightBorderSubtle = "#e9ecef";
  static readonly darkBorderSubtle = "#adb5bd";
  static readonly whiteRgb = "255, 255, 255";
  static readonly blackRgb = "0, 0, 0";
  static readonly gradient = "linear-gradient(180deg, rgba(255, 255, 255, 0.15), rgba(255, 255, 255, 0))";
  static readonly bodyFontFamily = "var(--bs-font-sans-serif)";
  static readonly bodyFontSize = "1rem";
  static readonly bodyFontWeight = 400;
  static readonly bodyLineHeight = 1.5;
  static readonly bodyColor = "#212529";
  static readonly bodyColorRgb = "33, 37, 41";
  static readonly bodyBg = "rgb(255, 255, 255)";
  static readonly bodyBgRgb = "255, 255, 255";
  static readonly emphasisColor = "rgb(0, 0, 0)";
  static readonly emphasisColorRgb = "0, 0, 0";
  static readonly secondaryColor = "rgba(33, 37, 41, 0.75)";
  static readonly secondaryColorRgb = "33, 37, 41";
  static readonly secondaryBg = "rgb(233, 236, 239)";
  static readonly secondaryBgRgb = "233, 236, 239";
  static readonly tertiaryColor = "rgba(33, 37, 41, 0.5)";
  static readonly tertiaryColorRgb = "33, 37, 41";
  static readonly tertiaryBg = "#f8f9fa";
  static readonly tertiaryBgRgb = "248, 249, 250";
  static readonly headingColor = "inherit";
  static readonly linkColor = "rgb(13, 110, 253)";
  static readonly linkColorRgb = "13, 110, 253";
  static readonly linkDecoration = "underline";
  static readonly linkHoverColor = "rgb(10, 88, 202)";
  static readonly linkHoverColorRgb = "10, 88, 202";
  static readonly codeColor = "#d63384";
  static readonly highlightColor = "#212529";
  static readonly highlightBg = "rgb(255, 242.6, 205.4)";
  static readonly borderWidth = "1px";
  static readonly borderStyle = "solid";
  static readonly borderColor = "rgb(222, 226, 230)";
  static readonly borderColorTranslucent = "rgba(0, 0, 0, 0.175)";
  static readonly borderRadius = "0.375rem";
  static readonly borderRadiusSm = "0.25rem";
  static readonly borderRadiusLg = "0.5rem";
  static readonly borderRadiusXl = "1rem";
  static readonly borderRadiusXxl = "2rem";
  static readonly borderRadius2xl = "var(--bsBorderRadius-xxl)";
  static readonly borderRadiusPill = "50rem";
  static readonly boxShadow = "0 0.5rem 1rem rgba(0, 0, 0, 0.15)";
  static readonly boxShadowSm = "0 0.125rem 0.25rem rgba(0, 0, 0, 0.075)";
  static readonly boxShadowLg = "0 1rem 3rem rgba(0, 0, 0, 0.175)";
  static readonly boxShadowInset = "inset 0 1px 2px rgba(0, 0, 0, 0.075)";
  static readonly focusRingWidth = "0.25rem";
  static readonly focusRingOpacity = "0.25";
  static readonly focusRingColor = "rgba(13, 110, 253, 0.25)";
  static readonly formValidColor = "#198754";
  static readonly formValidBorderColor = "#198754";
  static readonly formInvalidColor = "#dc3545";
  static readonly formInvalidBorderColor = "#dc3545";
}

/**
 * CSS variables generated by https://github.com/twbs/bootstrap/blob/v5.3.7/scss/_card.scss.
 */
export class Card {
  static readonly spacerY = "1rem";
  static readonly spacerX = "1rem";
  static readonly titleSpacerY = "0.5rem";
  static readonly borderWidth = Root.borderWidth;
  static readonly borderColor = Root.borderColorTranslucent;
  static readonly borderRadius = Root.borderRadius;
  static readonly innerBorderRadius = "calc(var(--bs-border-radius) - (var(--bs-border-width)))";
  static readonly capPaddingY = "0.5rem";
  static readonly capPaddingX = "1rem";
  static readonly capBg = "rgba(33, 37, 41, 0.03)";
  static readonly bg = Root.bodyBg;
  static readonly imgOverlayPadding = "1rem";
  static readonly groupMargin = "0.75rem";
}

/**
 * CSS variables generated by https://github.com/twbs/bootstrap/blob/v5.3.7/scss/_nav.scss.
 */
export class Nav {
  static readonly linkPaddingX = "1rem";
  static readonly linkPaddingY = "0.5rem";
  static readonly linkColor = Root.linkColor;
  static readonly linkHoverColor = Root.linkHoverColor;
  static readonly linkDisabledColor = Root.secondaryColor;
  static readonly tabsBorderWidth = Root.borderWidth;
  static readonly tabsBorderColor = Root.borderColor;
  static readonly tabsBorderRadius = Root.borderRadius;
  static readonly tabsLinkHoverBorderColor = Root.secondaryBg + " " + Root.secondaryBg + " " + Root.borderColor;
  static readonly tabsLinkActiveColor = Root.emphasisColor;
  static readonly tabsLinkActiveBg = Root.bodyBg;
  static readonly tabsLinkActiveBorderColor = Root.borderColor + " " + Root.borderColor + " " + Root.bodyBg;
}

/**
 * CSS variables generated by https://github.com/twbs/bootstrap/blob/v5.3.8/scss/_navbar.scss.
 */
export class Navbar {
  static readonly paddingX = "0";
  static readonly paddingY = "8px";
  static readonly color = "rgba(" + Root.emphasisColorRgb + ", 0.65)";
  static readonly hoverColor = "rgba(" + Root.emphasisColorRgb + ", 0.8)";
  static readonly disabledColor = "rgba(" + Root.emphasisColorRgb + ", 0.3)";
  static readonly activeColor = "rgba(" + Root.emphasisColorRgb + ", 1)";
  static readonly brandPaddingY = "0.3125rem";
  static readonly brandMarginEnd = "1rem";
  static readonly brandFontSize = "1.25rem";
  static readonly brandColor = "rgba(" + Root.emphasisColorRgb + ", 1)";
  static readonly brandHoverColor = "rgba(" + Root.emphasisColorRgb + ", 1)";
  static readonly navLinkPaddingX = "8px";
  static readonly togglerPaddingY = "0.25rem";
  static readonly togglerPaddingX = "0.75rem";
  static readonly togglerFontSize = "1.25rem";
  static readonly togglerIconBg = "url(data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%2833, 37, 41, 0.75%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e)";
  static readonly togglerBorderColor = "rgba(" + Root.emphasisColorRgb + ", 0.15)";
  static readonly togglerBorderRadius = "var(--bs-border-radius)";
  static readonly togglerFocusWidth = "0.25rem";
  static readonly togglerTransition = "box-shadow 0.15s ease-in-out";
}

/**
 * CSS variables generated by https://github.com/twbs/bootstrap/blob/v5.3.8/scss/_tables.scss.
 */
export class Table {
  static readonly colorType = "initial";
  static readonly bgType = "initial";
  static readonly colorState = "initial";
  static readonly bgState = "initial";
  static readonly color = "var(--bs-emphasis-color)";
  static readonly bg = Root.bodyBg;
  static readonly borderColor = "var(--bs-border-color)";
  static readonly accentBg = "transparent";
  static readonly stripedColor = "var(--bs-emphasis-color)";
  static readonly stripedBg = "rgba(" + Root.emphasisColorRgb + ", 0.05)";
  static readonly activeColor = "var(--bs-emphasis-color)";
  static readonly activeBg = "rgba(" + Root.emphasisColorRgb + ", 0.1)";
  static readonly hoverColor = "var(--bs-emphasis-color)";
  static readonly hoverBg = "rgba(" + Root.emphasisColorRgb + ", 0.075)";
}
