/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.message.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.message.MessageResource;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageResource
implements MessageResource {
    private final Logger LOG = LoggerFactory.getLogger(DefaultMessageResource.class);
    private static final String RESOURCE_PATH = "org/apache/ftpserver/message/";
    private final List<String> languages;
    private final Map<String, PropertiesPair> messages;

    public DefaultMessageResource(List<String> languages, File customMessageDirectory) {
        this.languages = languages != null ? Collections.unmodifiableList(languages) : null;
        this.messages = new HashMap<String, PropertiesPair>();
        if (languages != null) {
            for (String language : languages) {
                PropertiesPair pair = this.createPropertiesPair(language, customMessageDirectory);
                this.messages.put(language, pair);
            }
        }
        PropertiesPair pair = this.createPropertiesPair(null, customMessageDirectory);
        this.messages.put(null, pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertiesPair createPropertiesPair(String lang, File customMessageDirectory) {
        InputStream in;
        PropertiesPair pair;
        block11: {
            pair = new PropertiesPair();
            String defaultResourceName = lang == null ? "org/apache/ftpserver/message/FtpStatus.properties" : "org/apache/ftpserver/message/FtpStatus_" + lang + ".properties";
            in = null;
            try {
                in = this.getClass().getClassLoader().getResourceAsStream(defaultResourceName);
                if (in != null) {
                    try {
                        pair.defaultProperties.load(in);
                        break block11;
                    }
                    catch (IOException e) {
                        throw new FtpServerConfigurationException("Failed to load messages from \"" + defaultResourceName + "\", file not found in classpath");
                    }
                }
                throw new FtpServerConfigurationException("Failed to load messages from \"" + defaultResourceName + "\", file not found in classpath");
            }
            catch (Throwable throwable) {
                IoUtils.close(in);
                throw throwable;
            }
        }
        IoUtils.close(in);
        File resourceFile = null;
        resourceFile = lang == null ? new File(customMessageDirectory, "FtpStatus.gen") : new File(customMessageDirectory, "FtpStatus_" + lang + ".gen");
        in = null;
        try {
            if (resourceFile.exists()) {
                in = new FileInputStream(resourceFile);
                pair.customProperties.load(in);
            }
        }
        catch (Exception ex) {
            this.LOG.warn("MessageResourceImpl.createPropertiesPair()", (Throwable)ex);
            throw new FtpServerConfigurationException("MessageResourceImpl.createPropertiesPair()", ex);
        }
        finally {
            IoUtils.close(in);
        }
        return pair;
    }

    @Override
    public List<String> getAvailableLanguages() {
        if (this.languages == null) {
            return null;
        }
        return Collections.unmodifiableList(this.languages);
    }

    @Override
    public String getMessage(int code, String subId, String language) {
        String key = String.valueOf(code);
        if (subId != null) {
            key = key + '.' + subId;
        }
        String value = null;
        PropertiesPair pair = null;
        if (language != null && (pair = this.messages.get(language = language.toLowerCase())) != null && (value = pair.customProperties.getProperty(key)) == null) {
            value = pair.defaultProperties.getProperty(key);
        }
        if (value == null && (pair = this.messages.get(null)) != null && (value = pair.customProperties.getProperty(key)) == null) {
            value = pair.defaultProperties.getProperty(key);
        }
        return value;
    }

    @Override
    public Map<String, String> getMessages(String language) {
        Properties messages = new Properties();
        PropertiesPair pair = this.messages.get(null);
        if (pair != null) {
            messages.putAll((Map<?, ?>)pair.defaultProperties);
            messages.putAll((Map<?, ?>)pair.customProperties);
        }
        if (language != null && (pair = this.messages.get(language = language.toLowerCase())) != null) {
            messages.putAll((Map<?, ?>)pair.defaultProperties);
            messages.putAll((Map<?, ?>)pair.customProperties);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Object key : messages.keySet()) {
            result.put(key.toString(), messages.getProperty(key.toString()));
        }
        return Collections.unmodifiableMap(result);
    }

    public void dispose() {
        for (String language : this.messages.keySet()) {
            PropertiesPair pair = this.messages.get(language);
            pair.customProperties.clear();
            pair.defaultProperties.clear();
        }
        this.messages.clear();
    }

    private static class PropertiesPair {
        public Properties defaultProperties = new Properties();
        public Properties customProperties = new Properties();

        private PropertiesPair() {
        }
    }
}

