/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.eclipse.aether.spi.connector.transport.http;

import org.eclipse.aether.spi.connector.transport.Transporter;

/**
 * A transporter using HTTP protocol.
 *
 * @since 2.0.0
 */
public interface HttpTransporter extends Transporter {
    @Override
    default int classify(Throwable error) {
        if (error instanceof HttpTransporterException) {
            int statusCode = ((HttpTransporterException) error).getStatusCode();
            if (statusCode == HttpConstants.NOT_FOUND || statusCode == HttpConstants.GONE) {
                return ERROR_NOT_FOUND;
            }
        }
        return ERROR_OTHER;
    }
}
