/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.tools;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.collection.CasInitializer;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.internal.util.I18nUtil;
import org.apache.uima.pear.tools.InstallationController;
import org.apache.uima.pear.tools.PackageBrowser;
import org.apache.uima.pear.util.UIMAUtil;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public class InstallationTester {
    private String uimaCategory = null;
    private PackageBrowser pkgBrowser = null;
    private Properties systemProps = null;
    private static final String PEAR_MESSAGE_RESOURCE_BUNDLE = "org.apache.uima.pear.pear_messages";

    public InstallationTester(PackageBrowser pkgBrowser) throws IOException, InvalidXMLException, ResourceInitializationException, UIMAException, UIMARuntimeException {
        Exception err;
        this.pkgBrowser = pkgBrowser;
        this.systemProps = System.getProperties();
        File compDescFile = new File(this.pkgBrowser.getInstallationDescriptor().getMainComponentDesc());
        this.uimaCategory = UIMAUtil.identifyUimaComponentCategory(compDescFile);
        if (this.uimaCategory == null && (err = UIMAUtil.getLastErrorForXmlDesc(compDescFile)) != null) {
            if (err instanceof UIMAException) {
                throw (UIMAException)err;
            }
            if (err instanceof UIMARuntimeException) {
                throw (UIMARuntimeException)err;
            }
            throw new RuntimeException(err);
        }
    }

    public InstallationController.TestStatus doTest() throws IOException, InvalidXMLException, ResourceInitializationException {
        if (this.uimaCategory.equals("AE")) {
            return this.testAnalysisEngine();
        }
        if (this.uimaCategory.equals("CC")) {
            return this.testCasConsumer();
        }
        if (this.uimaCategory.equals("CI")) {
            return this.testCasInitializer();
        }
        if (this.uimaCategory.equals("CR")) {
            return this.testCollectionReader();
        }
        if (this.uimaCategory.equals("CPE")) {
            return this.testCpeCongifuration();
        }
        if (this.uimaCategory.equals("TS")) {
            return this.testTypeSystem();
        }
        InstallationController.TestStatus status = new InstallationController.TestStatus();
        status.setMessage(I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_type_not_detected", new Object[]{this.pkgBrowser.getInstallationDescriptor().getMainComponentId()}, null));
        return status;
    }

    private static ResourceManager getResourceManager(PackageBrowser pkgBrowser) throws IOException {
        ResourceManager resourceMgr = UIMAFramework.newDefaultResourceManager();
        if (pkgBrowser.getComponentDataPath() != null) {
            resourceMgr.setDataPath(pkgBrowser.getComponentDataPath());
        }
        if (pkgBrowser.buildComponentClassPath() != null) {
            resourceMgr.setExtensionClassPath(pkgBrowser.buildComponentClassPath(), true);
        }
        return resourceMgr;
    }

    private static void setSystemProperties(PackageBrowser pkgBrowser) throws IOException {
        Properties props = pkgBrowser.getComponentEnvVars();
        for (String string : props.keySet()) {
            String value = (String)props.get(string);
            System.setProperty(string, value);
        }
    }

    private void resetSystemProperties() {
        System.setProperties(this.systemProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstallationController.TestStatus testAnalysisEngine() throws IOException, InvalidXMLException, ResourceInitializationException {
        InstallationTester.setSystemProperties(this.pkgBrowser);
        try (XMLInputSource xmlIn = null;){
            xmlIn = new XMLInputSource(this.pkgBrowser.getInstallationDescriptor().getMainComponentDesc());
            ResourceSpecifier aeSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(xmlIn);
            AnalysisEngine ae = UIMAFramework.produceAnalysisEngine(aeSpecifier, InstallationTester.getResourceManager(this.pkgBrowser), null);
            CAS cas = null;
            if (ae != null) {
                cas = ae.newCAS();
            }
            InstallationController.TestStatus status = new InstallationController.TestStatus();
            if (ae != null && cas != null) {
                status.setRetCode(0);
            } else {
                status.setRetCode(-1);
                status.setMessage(I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_ae_not_created", new Object[]{this.pkgBrowser.getInstallationDescriptor().getMainComponentId()}, null));
            }
            this.resetSystemProperties();
            InstallationController.TestStatus testStatus = status;
            return testStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstallationController.TestStatus testCasConsumer() throws IOException, InvalidXMLException, ResourceInitializationException {
        InstallationTester.setSystemProperties(this.pkgBrowser);
        try (XMLInputSource xmlIn = null;){
            xmlIn = new XMLInputSource(this.pkgBrowser.getInstallationDescriptor().getMainComponentDesc());
            ResourceSpecifier ccSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(xmlIn);
            CasConsumer cc = UIMAFramework.produceCasConsumer(ccSpecifier, InstallationTester.getResourceManager(this.pkgBrowser), null);
            InstallationController.TestStatus status = new InstallationController.TestStatus();
            if (cc != null) {
                status.setRetCode(0);
            } else {
                status.setRetCode(-1);
                status.setMessage(I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_cc_not_created", new Object[]{this.pkgBrowser.getInstallationDescriptor().getMainComponentId()}, null));
            }
            this.resetSystemProperties();
            InstallationController.TestStatus testStatus = status;
            return testStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstallationController.TestStatus testCasInitializer() throws IOException, InvalidXMLException, ResourceInitializationException {
        InstallationTester.setSystemProperties(this.pkgBrowser);
        try (XMLInputSource xmlIn = null;){
            xmlIn = new XMLInputSource(this.pkgBrowser.getInstallationDescriptor().getMainComponentDesc());
            ResourceSpecifier ciSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(xmlIn);
            CasInitializer ci = UIMAFramework.produceCasInitializer(ciSpecifier, InstallationTester.getResourceManager(this.pkgBrowser), null);
            InstallationController.TestStatus status = new InstallationController.TestStatus();
            if (ci != null) {
                status.setRetCode(0);
            } else {
                status.setRetCode(-1);
                status.setMessage(I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_ci_not_created", new Object[]{this.pkgBrowser.getInstallationDescriptor().getMainComponentId()}, null));
            }
            this.resetSystemProperties();
            InstallationController.TestStatus testStatus = status;
            return testStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstallationController.TestStatus testCollectionReader() throws IOException, InvalidXMLException, ResourceInitializationException {
        InstallationTester.setSystemProperties(this.pkgBrowser);
        try (XMLInputSource xmlIn = null;){
            xmlIn = new XMLInputSource(this.pkgBrowser.getInstallationDescriptor().getMainComponentDesc());
            ResourceSpecifier crSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(xmlIn);
            CollectionReader cr = UIMAFramework.produceCollectionReader(crSpecifier, InstallationTester.getResourceManager(this.pkgBrowser), null);
            InstallationController.TestStatus status = new InstallationController.TestStatus();
            if (cr != null) {
                status.setRetCode(0);
            } else {
                status.setRetCode(-1);
                status.setMessage(I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_cr_not_created", new Object[]{this.pkgBrowser.getInstallationDescriptor().getMainComponentId()}, null));
            }
            this.resetSystemProperties();
            InstallationController.TestStatus testStatus = status;
            return testStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstallationController.TestStatus testCpeCongifuration() throws IOException, InvalidXMLException, ResourceInitializationException {
        InstallationTester.setSystemProperties(this.pkgBrowser);
        try (XMLInputSource xmlIn = null;){
            xmlIn = new XMLInputSource(this.pkgBrowser.getInstallationDescriptor().getMainComponentDesc());
            CpeDescription cpeDescription = UIMAFramework.getXMLParser().parseCpeDescription(xmlIn);
            CollectionProcessingEngine cpe = UIMAFramework.produceCollectionProcessingEngine(cpeDescription, InstallationTester.getResourceManager(this.pkgBrowser), null);
            InstallationController.TestStatus status = new InstallationController.TestStatus();
            if (cpe != null) {
                status.setRetCode(0);
            } else {
                status.setRetCode(-1);
                status.setMessage(I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_cpe_not_created", new Object[]{this.pkgBrowser.getInstallationDescriptor().getMainComponentId()}, null));
            }
            this.resetSystemProperties();
            InstallationController.TestStatus testStatus = status;
            return testStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstallationController.TestStatus testTypeSystem() throws IOException, InvalidXMLException, ResourceInitializationException {
        InstallationTester.setSystemProperties(this.pkgBrowser);
        try (XMLInputSource xmlIn = null;){
            xmlIn = new XMLInputSource(this.pkgBrowser.getInstallationDescriptor().getMainComponentDesc());
            TypeSystemDescription tsDescription = UIMAFramework.getXMLParser().parseTypeSystemDescription(xmlIn);
            TypePriorities tPriorities = UIMAFramework.getResourceSpecifierFactory().createTypePriorities();
            FsIndexDescription[] fsIndexes = new FsIndexDescription[]{};
            CAS cas = CasCreationUtils.createCas(tsDescription, tPriorities, fsIndexes);
            InstallationController.TestStatus status = new InstallationController.TestStatus();
            if (cas != null) {
                status.setRetCode(0);
            } else {
                status.setRetCode(-1);
                status.setMessage(I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_cas_not_created", new Object[]{this.pkgBrowser.getInstallationDescriptor().getMainComponentId()}, null));
            }
            this.resetSystemProperties();
            InstallationController.TestStatus testStatus = status;
            return testStatus;
        }
    }
}

