/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.AbstractIterator$State;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractIterator
extends UnmodifiableIterator {
    private AbstractIterator$State state = AbstractIterator$State.NOT_READY;
    private @Nullable Object next;

    protected AbstractIterator() {
    }

    protected abstract Object computeNext();

    @CanIgnoreReturnValue
    protected final Object endOfData() {
        this.state = AbstractIterator$State.DONE;
        return null;
    }

    @Override
    @CanIgnoreReturnValue
    public final boolean hasNext() {
        Preconditions.checkState(this.state != AbstractIterator$State.FAILED);
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        this.state = AbstractIterator$State.FAILED;
        this.next = this.computeNext();
        if (this.state != AbstractIterator$State.DONE) {
            this.state = AbstractIterator$State.READY;
            return true;
        }
        return false;
    }

    @CanIgnoreReturnValue
    public final Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = AbstractIterator$State.NOT_READY;
        Object object = this.next;
        this.next = null;
        return object;
    }

    public final Object peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next;
    }
}

