/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.FloatDocValues;
import org.apache.lucene.queries.payloads.PayloadDecoder;
import org.apache.lucene.queries.payloads.PayloadFunction;
import org.apache.lucene.util.BytesRef;

public class FloatPayloadValueSource
extends ValueSource {
    protected final String field;
    protected final String val;
    protected final String indexedField;
    protected final BytesRef indexedBytes;
    protected final PayloadDecoder decoder;
    protected final PayloadFunction payloadFunction;
    protected final ValueSource defaultValueSource;

    public FloatPayloadValueSource(String field, String val, String indexedField, BytesRef indexedBytes, PayloadDecoder decoder, PayloadFunction payloadFunction, ValueSource defaultValueSource) {
        this.field = field;
        this.val = val;
        this.indexedField = indexedField;
        this.indexedBytes = indexedBytes;
        this.decoder = decoder;
        this.payloadFunction = payloadFunction;
        this.defaultValueSource = defaultValueSource;
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final Terms terms = readerContext.reader().terms(this.indexedField);
        final FunctionValues defaultValues = this.defaultValueSource.getValues(context, readerContext);
        return new FloatDocValues(this){
            PostingsEnum docs;
            int atDoc;
            int lastDocRequested;
            float docScore;
            {
                super(x0);
                this.lastDocRequested = -1;
                this.docScore = 0.0f;
                this.reset();
            }

            public void reset() throws IOException {
                TermsEnum termsEnum;
                this.docs = terms != null ? ((termsEnum = terms.iterator()).seekExact(FloatPayloadValueSource.this.indexedBytes) ? termsEnum.postings(null, 120) : null) : null;
                if (this.docs == null) {
                    this.docs = new PostingsEnum(){

                        public int freq() {
                            return 0;
                        }

                        public int nextPosition() throws IOException {
                            return -1;
                        }

                        public int startOffset() throws IOException {
                            return -1;
                        }

                        public int endOffset() throws IOException {
                            return -1;
                        }

                        public BytesRef getPayload() throws IOException {
                            return null;
                        }

                        public int docID() {
                            return Integer.MAX_VALUE;
                        }

                        public int nextDoc() {
                            return Integer.MAX_VALUE;
                        }

                        public int advance(int target) {
                            return Integer.MAX_VALUE;
                        }

                        public long cost() {
                            return 0L;
                        }
                    };
                }
                this.atDoc = -1;
            }

            public float floatVal(int doc) {
                try {
                    if (doc < this.lastDocRequested) {
                        this.reset();
                    } else if (doc == this.lastDocRequested) {
                        return this.docScore;
                    }
                    this.lastDocRequested = doc;
                    if (this.atDoc < doc) {
                        this.atDoc = this.docs.advance(doc);
                    }
                    if (this.atDoc > doc) {
                        this.docScore = defaultValues.floatVal(doc);
                        return this.docScore;
                    }
                    int freq = this.docs.freq();
                    int numPayloadsSeen = 0;
                    float currentScore = 0.0f;
                    for (int i = 0; i < freq; ++i) {
                        this.docs.nextPosition();
                        BytesRef payload = this.docs.getPayload();
                        if (payload == null) continue;
                        float payloadVal = FloatPayloadValueSource.this.decoder.computePayloadFactor(payload);
                        if (FloatPayloadValueSource.this.payloadFunction == null) {
                            return payloadVal;
                        }
                        currentScore = FloatPayloadValueSource.this.payloadFunction.currentScore(doc, FloatPayloadValueSource.this.indexedField, this.docs.startOffset(), this.docs.endOffset(), numPayloadsSeen, currentScore, payloadVal);
                        ++numPayloadsSeen;
                    }
                    this.docScore = numPayloadsSeen > 0 ? FloatPayloadValueSource.this.payloadFunction.docScore(doc, FloatPayloadValueSource.this.indexedField, numPayloadsSeen, currentScore) : defaultValues.floatVal(doc);
                    return this.docScore;
                }
                catch (IOException e) {
                    throw new RuntimeException("caught exception in function " + FloatPayloadValueSource.this.description() + " : doc=" + doc, e);
                }
            }
        };
    }

    public String name() {
        return "payload";
    }

    public String description() {
        return this.name() + '(' + this.field + ',' + this.val + ',' + this.defaultValueSource.toString() + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FloatPayloadValueSource that = (FloatPayloadValueSource)((Object)o);
        if (!this.indexedField.equals(that.indexedField)) {
            return false;
        }
        if (this.indexedBytes != null ? !this.indexedBytes.equals((Object)that.indexedBytes) : that.indexedBytes != null) {
            return false;
        }
        if (!this.decoder.equals(that.decoder)) {
            return false;
        }
        if (this.payloadFunction != null ? !this.payloadFunction.equals((Object)that.payloadFunction) : that.payloadFunction != null) {
            return false;
        }
        return this.defaultValueSource.equals((Object)that.defaultValueSource);
    }

    public int hashCode() {
        int result = this.indexedField.hashCode();
        result = 31 * result + (this.indexedBytes != null ? this.indexedBytes.hashCode() : 0);
        result = 31 * result + this.decoder.hashCode();
        result = 31 * result + (this.payloadFunction != null ? this.payloadFunction.hashCode() : 0);
        result = 31 * result + this.defaultValueSource.hashCode();
        return result;
    }
}

