/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.rules.AggregateReduceFunctionsRule;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AggregateReduceFunctionsRule", generator="Immutables")
final class ImmutableAggregateReduceFunctionsRule {
    private ImmutableAggregateReduceFunctionsRule() {
    }

    @CheckReturnValue
    @Generated(from="AggregateReduceFunctionsRule.Config", generator="Immutables")
    @Immutable
    static final class Config
    implements AggregateReduceFunctionsRule.Config {
        private final RelBuilderFactory relBuilderFactory;
        @Nullable
        private final @org.checkerframework.checker.nullness.qual.Nullable String description;
        private final RelRule.OperandTransform operandSupplier;
        private final ImmutableSet<SqlKind> functionsToReduce;
        private final Predicate<AggregateCall> extraCondition;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();
        private static final Config INSTANCE = Config.validate(new Config());

        private Config() {
            this.description = null;
            this.functionsToReduce = null;
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.operandSupplier = this.initShim.operandSupplier();
            this.extraCondition = this.initShim.extraCondition();
            this.initShim = null;
        }

        private Config(Builder builder) {
            this.description = builder.description;
            ImmutableSet<SqlKind> immutableSet = this.functionsToReduce = builder.functionsToReduce == null ? null : Sets.immutableEnumSet((Iterable)builder.functionsToReduce.build());
            if (builder.relBuilderFactory != null) {
                this.initShim.withRelBuilderFactory(builder.relBuilderFactory);
            }
            if (builder.operandSupplier != null) {
                this.initShim.withOperandSupplier(builder.operandSupplier);
            }
            if (builder.extraCondition != null) {
                this.initShim.withExtraCondition(builder.extraCondition);
            }
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.operandSupplier = this.initShim.operandSupplier();
            this.extraCondition = this.initShim.extraCondition();
            this.initShim = null;
        }

        private Config(RelBuilderFactory relBuilderFactory, @Nullable @org.checkerframework.checker.nullness.qual.Nullable String description, RelRule.OperandTransform operandSupplier, ImmutableSet<SqlKind> functionsToReduce, Predicate<AggregateCall> extraCondition) {
            this.relBuilderFactory = relBuilderFactory;
            this.description = description;
            this.operandSupplier = operandSupplier;
            this.functionsToReduce = functionsToReduce;
            this.extraCondition = extraCondition;
            this.initShim = null;
        }

        private RelBuilderFactory relBuilderFactoryInitialize() {
            return AggregateReduceFunctionsRule.Config.super.relBuilderFactory();
        }

        private RelRule.OperandTransform operandSupplierInitialize() {
            return AggregateReduceFunctionsRule.Config.super.operandSupplier();
        }

        private Predicate<AggregateCall> extraConditionInitialize() {
            return AggregateReduceFunctionsRule.Config.super.extraCondition();
        }

        @Override
        public RelBuilderFactory relBuilderFactory() {
            InitShim shim = this.initShim;
            return shim != null ? shim.relBuilderFactory() : this.relBuilderFactory;
        }

        @Override
        @Nullable
        public @org.checkerframework.checker.nullness.qual.Nullable String description() {
            return this.description;
        }

        @Override
        public RelRule.OperandTransform operandSupplier() {
            InitShim shim = this.initShim;
            return shim != null ? shim.operandSupplier() : this.operandSupplier;
        }

        public ImmutableSet<SqlKind> functionsToReduce() {
            return this.functionsToReduce;
        }

        @Override
        public Predicate<AggregateCall> extraCondition() {
            InitShim shim = this.initShim;
            return shim != null ? shim.extraCondition() : this.extraCondition;
        }

        @Override
        public final Config withRelBuilderFactory(RelBuilderFactory value) {
            if (this.relBuilderFactory == value) {
                return this;
            }
            RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
            return Config.validate(new Config(newValue, this.description, this.operandSupplier, this.functionsToReduce, this.extraCondition));
        }

        @Override
        public final Config withDescription(@Nullable @org.checkerframework.checker.nullness.qual.Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return Config.validate(new Config(this.relBuilderFactory, value, this.operandSupplier, this.functionsToReduce, this.extraCondition));
        }

        @Override
        public final Config withOperandSupplier(RelRule.OperandTransform value) {
            if (this.operandSupplier == value) {
                return this;
            }
            RelRule.OperandTransform newValue = Objects.requireNonNull(value, "operandSupplier");
            return Config.validate(new Config(this.relBuilderFactory, this.description, newValue, this.functionsToReduce, this.extraCondition));
        }

        public final Config withFunctionsToReduce(SqlKind ... elements) {
            if (elements == null) {
                return Config.validate(new Config(this.relBuilderFactory, this.description, this.operandSupplier, null, this.extraCondition));
            }
            ImmutableSet newValue = Arrays.asList(elements) == null ? null : Sets.immutableEnumSet(Arrays.asList(elements));
            return Config.validate(new Config(this.relBuilderFactory, this.description, this.operandSupplier, (ImmutableSet<SqlKind>)newValue, this.extraCondition));
        }

        @Override
        public final Config withFunctionsToReduce(Iterable<SqlKind> elements) {
            if (this.functionsToReduce == elements) {
                return this;
            }
            ImmutableSet newValue = elements == null ? null : Sets.immutableEnumSet(elements);
            return Config.validate(new Config(this.relBuilderFactory, this.description, this.operandSupplier, (ImmutableSet<SqlKind>)newValue, this.extraCondition));
        }

        @Override
        public final Config withExtraCondition(Predicate<AggregateCall> value) {
            if (this.extraCondition == value) {
                return this;
            }
            Predicate<AggregateCall> newValue = Objects.requireNonNull(value, "extraCondition");
            return Config.validate(new Config(this.relBuilderFactory, this.description, this.operandSupplier, this.functionsToReduce, newValue));
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Config && this.equalTo((Config)another);
        }

        private boolean equalTo(Config another) {
            return this.relBuilderFactory.equals(another.relBuilderFactory) && Objects.equals(this.description, another.description) && this.operandSupplier.equals(another.operandSupplier) && Objects.equals(this.functionsToReduce, another.functionsToReduce) && this.extraCondition.equals(another.extraCondition);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.relBuilderFactory.hashCode();
            h += (h << 5) + Objects.hashCode(this.description);
            h += (h << 5) + this.operandSupplier.hashCode();
            h += (h << 5) + Objects.hashCode(this.functionsToReduce);
            h += (h << 5) + this.extraCondition.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Config").omitNullValues().add("relBuilderFactory", (Object)this.relBuilderFactory).add("description", (Object)this.description).add("operandSupplier", (Object)this.operandSupplier).add("functionsToReduce", this.functionsToReduce).add("extraCondition", this.extraCondition).toString();
        }

        public static Config of() {
            return INSTANCE;
        }

        private static Config validate(Config instance) {
            return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
        }

        public static Config copyOf(AggregateReduceFunctionsRule.Config instance) {
            if (instance instanceof Config) {
                return (Config)instance;
            }
            return Config.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="AggregateReduceFunctionsRule.Config", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            @Nullable
            private RelBuilderFactory relBuilderFactory;
            @Nullable
            private @org.checkerframework.checker.nullness.qual.Nullable String description;
            @Nullable
            private RelRule.OperandTransform operandSupplier;
            private ImmutableSet.Builder<SqlKind> functionsToReduce = null;
            @Nullable
            private Predicate<AggregateCall> extraCondition;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(AggregateReduceFunctionsRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(RelRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                RelRule.Config instance;
                if (object instanceof AggregateReduceFunctionsRule.Config) {
                    instance = (AggregateReduceFunctionsRule.Config)object;
                    @org.checkerframework.checker.nullness.qual.Nullable Set<SqlKind> functionsToReduceValue = instance.functionsToReduce();
                    if (functionsToReduceValue != null) {
                        this.addAllFunctionsToReduce(functionsToReduceValue);
                    }
                    this.withExtraCondition(instance.extraCondition());
                }
                if (object instanceof RelRule.Config) {
                    instance = (RelRule.Config)object;
                    this.withRelBuilderFactory(instance.relBuilderFactory());
                    this.withOperandSupplier(instance.operandSupplier());
                    @org.checkerframework.checker.nullness.qual.Nullable String descriptionValue = instance.description();
                    if (descriptionValue != null) {
                        this.withDescription(descriptionValue);
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withDescription(@Nullable @org.checkerframework.checker.nullness.qual.Nullable String description) {
                this.description = description;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = Objects.requireNonNull(operandSupplier, "operandSupplier");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addFunctionsToReduce(SqlKind element) {
                if (this.functionsToReduce == null) {
                    this.functionsToReduce = ImmutableSet.builder();
                }
                this.functionsToReduce.add((Object)element);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addFunctionsToReduce(SqlKind ... elements) {
                if (this.functionsToReduce == null) {
                    this.functionsToReduce = ImmutableSet.builder();
                }
                this.functionsToReduce.addAll(Arrays.asList(elements));
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withFunctionsToReduce(Iterable<SqlKind> elements) {
                if (elements == null) {
                    this.functionsToReduce = null;
                    return this;
                }
                this.functionsToReduce = ImmutableSet.builder();
                return this.addAllFunctionsToReduce(elements);
            }

            @CanIgnoreReturnValue
            public final Builder addAllFunctionsToReduce(Iterable<SqlKind> elements) {
                Objects.requireNonNull(elements, "functionsToReduce element");
                if (this.functionsToReduce == null) {
                    this.functionsToReduce = ImmutableSet.builder();
                }
                this.functionsToReduce.addAll(elements);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withExtraCondition(Predicate<AggregateCall> extraCondition) {
                this.extraCondition = Objects.requireNonNull(extraCondition, "extraCondition");
                return this;
            }

            public Config build() {
                return Config.validate(new Config(this));
            }
        }

        @Generated(from="AggregateReduceFunctionsRule.Config", generator="Immutables")
        private final class InitShim {
            private byte relBuilderFactoryBuildStage = 0;
            private RelBuilderFactory relBuilderFactory;
            private byte operandSupplierBuildStage = 0;
            private RelRule.OperandTransform operandSupplier;
            private byte extraConditionBuildStage = 0;
            private Predicate<AggregateCall> extraCondition;

            private InitShim() {
            }

            RelBuilderFactory relBuilderFactory() {
                if (this.relBuilderFactoryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.relBuilderFactoryBuildStage == 0) {
                    this.relBuilderFactoryBuildStage = (byte)-1;
                    this.relBuilderFactory = Objects.requireNonNull(Config.this.relBuilderFactoryInitialize(), "relBuilderFactory");
                    this.relBuilderFactoryBuildStage = 1;
                }
                return this.relBuilderFactory;
            }

            void withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = relBuilderFactory;
                this.relBuilderFactoryBuildStage = 1;
            }

            RelRule.OperandTransform operandSupplier() {
                if (this.operandSupplierBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.operandSupplierBuildStage == 0) {
                    this.operandSupplierBuildStage = (byte)-1;
                    this.operandSupplier = Objects.requireNonNull(Config.this.operandSupplierInitialize(), "operandSupplier");
                    this.operandSupplierBuildStage = 1;
                }
                return this.operandSupplier;
            }

            void withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = operandSupplier;
                this.operandSupplierBuildStage = 1;
            }

            Predicate<AggregateCall> extraCondition() {
                if (this.extraConditionBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.extraConditionBuildStage == 0) {
                    this.extraConditionBuildStage = (byte)-1;
                    this.extraCondition = Objects.requireNonNull(Config.this.extraConditionInitialize(), "extraCondition");
                    this.extraConditionBuildStage = 1;
                }
                return this.extraCondition;
            }

            void withExtraCondition(Predicate<AggregateCall> extraCondition) {
                this.extraCondition = extraCondition;
                this.extraConditionBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.relBuilderFactoryBuildStage == -1) {
                    attributes.add("relBuilderFactory");
                }
                if (this.operandSupplierBuildStage == -1) {
                    attributes.add("operandSupplier");
                }
                if (this.extraConditionBuildStage == -1) {
                    attributes.add("extraCondition");
                }
                return "Cannot build Config, attribute initializers form cycle " + attributes;
            }
        }
    }
}

