/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.solr.handler.export.DoubleValueSortDoc;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.SortValue;

class TripleValueSortDoc
extends DoubleValueSortDoc {
    protected SortValue value3;

    @Override
    public SortValue getSortValue(String field) {
        if (this.value1.getField().equals(field)) {
            return this.value1;
        }
        if (this.value2.getField().equals(field)) {
            return this.value2;
        }
        if (this.value3.getField().equals(field)) {
            return this.value3;
        }
        return null;
    }

    @Override
    public void setNextReader(LeafReaderContext context) throws IOException {
        this.ord = context.ord;
        this.docBase = context.docBase;
        this.value1.setNextReader(context);
        this.value2.setNextReader(context);
        this.value3.setNextReader(context);
    }

    @Override
    public void reset() {
        this.docId = -1;
        this.docBase = -1;
        this.ord = -1;
        this.value1.reset();
        this.value2.reset();
        this.value3.reset();
    }

    @Override
    public void setValues(int docId) throws IOException {
        this.docId = docId;
        this.value1.setCurrentValue(docId);
        this.value2.setCurrentValue(docId);
        this.value3.setCurrentValue(docId);
    }

    @Override
    public void setValues(SortDoc sortDoc) {
        this.docId = sortDoc.docId;
        this.ord = sortDoc.ord;
        this.docBase = sortDoc.docBase;
        this.value1.setCurrentValue(((TripleValueSortDoc)sortDoc).value1);
        this.value2.setCurrentValue(((TripleValueSortDoc)sortDoc).value2);
        this.value3.setCurrentValue(((TripleValueSortDoc)sortDoc).value3);
    }

    public TripleValueSortDoc(SortValue value1, SortValue value2, SortValue value3) {
        super(value1, value2);
        this.value3 = value3;
    }

    @Override
    public SortDoc copy() {
        return new TripleValueSortDoc(this.value1.copy(), this.value2.copy(), this.value3.copy());
    }

    @Override
    public boolean lessThan(Object o) {
        TripleValueSortDoc sd = (TripleValueSortDoc)o;
        int comp = this.value1.compareTo(sd.value1);
        if (comp == -1) {
            return true;
        }
        if (comp == 1) {
            return false;
        }
        comp = this.value2.compareTo(sd.value2);
        if (comp == -1) {
            return true;
        }
        if (comp == 1) {
            return false;
        }
        comp = this.value3.compareTo(sd.value3);
        if (comp == -1) {
            return true;
        }
        if (comp == 1) {
            return false;
        }
        return this.docId + this.docBase > sd.docId + sd.docBase;
    }

    @Override
    public int compareTo(Object o) {
        TripleValueSortDoc sd = (TripleValueSortDoc)o;
        int comp = this.value1.compareTo(sd.value1);
        if (comp == 0) {
            comp = this.value2.compareTo(sd.value2);
            if (comp == 0) {
                return this.value3.compareTo(sd.value3);
            }
            return comp;
        }
        return comp;
    }
}

