/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Ordered;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.BuilderSupport;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.LambdaRouteBuilder;
import org.apache.camel.builder.RouteBuilderLifecycleStrategy;
import org.apache.camel.builder.TransformerBuilder;
import org.apache.camel.builder.ValidatorBuilder;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.OnCamelContextEvent;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RouteBuilder
extends BuilderSupport
implements RoutesBuilder,
Ordered {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private AtomicBoolean initialized = new AtomicBoolean();
    private RestsDefinition restCollection = new RestsDefinition();
    private RestConfigurationDefinition restConfiguration;
    private List<TransformerBuilder> transformerBuilders = new ArrayList<TransformerBuilder>();
    private List<ValidatorBuilder> validatorBuilders = new ArrayList<ValidatorBuilder>();
    private RoutesDefinition routeCollection = new RoutesDefinition();
    private RouteTemplatesDefinition routeTemplateCollection = new RouteTemplatesDefinition();
    private final List<RouteBuilderLifecycleStrategy> lifecycleInterceptors = new ArrayList<RouteBuilderLifecycleStrategy>();

    public RouteBuilder() {
        this(null);
    }

    public RouteBuilder(CamelContext context) {
        super(context);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public static void addRoutes(CamelContext context, final LambdaRouteBuilder rbc) throws Exception {
        context.addRoutes((RoutesBuilder)new RouteBuilder(context){

            @Override
            public void configure() throws Exception {
                rbc.accept(this);
            }
        });
    }

    public String toString() {
        return this.getRouteCollection().toString();
    }

    public abstract void configure() throws Exception;

    public void bindToRegistry(String id, Object bean) {
        this.getContext().getRegistry().bind(id, bean);
    }

    public void bindToRegistry(String id, Class<?> type, Object bean) {
        this.getContext().getRegistry().bind(id, type, bean);
    }

    public RestConfigurationDefinition restConfiguration() {
        if (this.restConfiguration == null) {
            this.restConfiguration = new RestConfigurationDefinition();
        }
        return this.restConfiguration;
    }

    public RouteTemplateDefinition routeTemplate(String id) {
        this.getRouteTemplateCollection().setCamelContext(this.getContext());
        RouteTemplateDefinition answer = this.getRouteTemplateCollection().routeTemplate(id);
        this.configureRouteTemplate(answer);
        return answer;
    }

    public RestDefinition rest() {
        this.getRestCollection().setCamelContext(this.getContext());
        RestDefinition answer = this.getRestCollection().rest();
        this.configureRest(answer);
        return answer;
    }

    public RestDefinition rest(String path) {
        this.getRestCollection().setCamelContext(this.getContext());
        RestDefinition answer = this.getRestCollection().rest(path);
        this.configureRest(answer);
        return answer;
    }

    public TransformerBuilder transformer() {
        TransformerBuilder tdb = new TransformerBuilder();
        this.transformerBuilders.add(tdb);
        return tdb;
    }

    public ValidatorBuilder validator() {
        ValidatorBuilder vb = new ValidatorBuilder();
        this.validatorBuilders.add(vb);
        return vb;
    }

    public RouteDefinition from(String uri) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(uri);
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition fromF(String uri, Object ... args) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(String.format(uri, args));
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition from(Endpoint endpoint) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(endpoint);
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition from(EndpointConsumerBuilder endpointDefinition) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(endpointDefinition);
        this.configureRoute(answer);
        return answer;
    }

    public void errorHandler(ErrorHandlerBuilder errorHandlerBuilder) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("errorHandler must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        this.setErrorHandlerBuilder(errorHandlerBuilder);
    }

    public <T> T propertyInject(String key, Class<T> type) throws Exception {
        StringHelper.notEmpty((String)key, (String)"key");
        ObjectHelper.notNull(type, (String)"Class type");
        PropertiesComponent pc = this.getContext().getPropertiesComponent();
        Optional value = pc.resolveProperty(key);
        if (value.isPresent()) {
            return (T)this.getContext().getTypeConverter().mandatoryConvertTo(type, value.get());
        }
        return null;
    }

    public InterceptDefinition intercept() {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("intercept must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().intercept();
    }

    public InterceptFromDefinition interceptFrom() {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("interceptFrom must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().interceptFrom();
    }

    public InterceptFromDefinition interceptFrom(String uri) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("interceptFrom must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().interceptFrom(uri);
    }

    public InterceptSendToEndpointDefinition interceptSendToEndpoint(String uri) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("interceptSendToEndpoint must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().interceptSendToEndpoint(uri);
    }

    public OnExceptionDefinition onException(Class<? extends Throwable> exception) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("onException must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().onException(exception);
    }

    public OnExceptionDefinition onException(Class<? extends Throwable> ... exceptions) {
        OnExceptionDefinition last = null;
        for (Class<? extends Throwable> ex : exceptions) {
            last = last == null ? this.onException(ex) : last.onException(ex);
        }
        return last != null ? last : this.onException((Class<? extends Throwable>)Exception.class);
    }

    public OnCompletionDefinition onCompletion() {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("onCompletion must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().onCompletion();
    }

    public void addRoutesToCamelContext(CamelContext context) throws Exception {
        this.configureRoutes(context);
        this.configureRests(context);
        this.populateRests();
        this.populateTransformers();
        this.populateValidators();
        this.populateRouteTemplates();
        this.populateRoutes();
        if (this instanceof OnCamelContextEvent) {
            context.addLifecycleStrategy(LifecycleStrategySupport.adapt((OnCamelContextEvent)((OnCamelContextEvent)this)));
        }
    }

    public RoutesDefinition configureRoutes(CamelContext context) throws Exception {
        this.setContext(context);
        this.checkInitialized();
        this.routeCollection.setCamelContext(context);
        return this.routeCollection;
    }

    public RestsDefinition configureRests(CamelContext context) throws Exception {
        this.setContext(context);
        this.restCollection.setCamelContext(context);
        return this.restCollection;
    }

    @Override
    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        super.setErrorHandlerBuilder(errorHandlerBuilder);
        this.getRouteCollection().setErrorHandlerFactory(this.getErrorHandlerBuilder());
    }

    public void addLifecycleInterceptor(RouteBuilderLifecycleStrategy interceptor) {
        this.lifecycleInterceptors.add(interceptor);
    }

    public void removeLifecycleInterceptor(RouteBuilderLifecycleStrategy interceptor) {
        this.lifecycleInterceptors.remove(interceptor);
    }

    protected void checkInitialized() throws Exception {
        if (this.initialized.compareAndSet(false, true)) {
            CamelContext camelContext = this.getContext();
            if (((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getErrorHandlerFactory() instanceof ErrorHandlerBuilder) {
                this.setErrorHandlerBuilder((ErrorHandlerBuilder)((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getErrorHandlerFactory());
            }
            for (RouteBuilderLifecycleStrategy interceptor : this.lifecycleInterceptors) {
                interceptor.beforeConfigure(this);
            }
            this.configure();
            for (RouteDefinition route : this.getRouteCollection().getRoutes()) {
                route.markPrepared();
            }
            for (RouteBuilderLifecycleStrategy interceptor : this.lifecycleInterceptors) {
                interceptor.afterConfigure(this);
            }
        }
    }

    protected void populateRouteTemplates() throws Exception {
        CamelContext camelContext = this.getContext();
        if (camelContext == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        this.getRouteTemplateCollection().setCamelContext(camelContext);
        ((Model)camelContext.getExtension(Model.class)).addRouteTemplateDefinitions(this.getRouteTemplateCollection().getRouteTemplates());
    }

    protected void populateRoutes() throws Exception {
        CamelContext camelContext = this.getContext();
        if (camelContext == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        this.getRouteCollection().setCamelContext(camelContext);
        ((Model)camelContext.getExtension(Model.class)).addRouteDefinitions(this.getRouteCollection().getRoutes());
    }

    protected void populateRests() throws Exception {
        CamelContext camelContext = this.getContext();
        if (camelContext == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        this.getRestCollection().setCamelContext(camelContext);
        if (this.restConfiguration != null) {
            this.restConfiguration.asRestConfiguration(this.getContext(), camelContext.getRestConfiguration());
        }
        ((Model)camelContext.getExtension(Model.class)).addRestDefinitions(this.getRestCollection().getRests(), false);
        RestConfiguration config = camelContext.getRestConfiguration();
        if (config.getApiContextPath() != null) {
            boolean hasRestApi = false;
            for (RouteDefinition route : ((Model)camelContext.getExtension(Model.class)).getRouteDefinitions()) {
                FromDefinition from = route.getInput();
                if (from.getEndpointUri() == null || !from.getEndpointUri().startsWith("rest-api:")) continue;
                hasRestApi = true;
            }
            if (!hasRestApi) {
                RouteDefinition route = RestDefinition.asRouteApiDefinition(camelContext, config);
                this.log.debug("Adding routeId: {} as rest-api route", (Object)route.getId());
                this.getRouteCollection().route(route);
            }
        }
        this.getRestCollection().getRests().forEach(rest -> rest.asRouteDefinition(this.getContext()).forEach(route -> this.getRouteCollection().route((RouteDefinition)route)));
    }

    protected void populateTransformers() {
        CamelContext camelContext = this.getContext();
        if (camelContext == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        for (TransformerBuilder tdb : this.transformerBuilders) {
            tdb.configure(camelContext);
        }
    }

    protected void populateValidators() {
        CamelContext camelContext = this.getContext();
        if (camelContext == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        for (ValidatorBuilder vb : this.validatorBuilders) {
            vb.configure(camelContext);
        }
    }

    public RestsDefinition getRestCollection() {
        return this.restCollection;
    }

    public RestConfigurationDefinition getRestConfiguration() {
        return this.restConfiguration;
    }

    public void setRestCollection(RestsDefinition restCollection) {
        this.restCollection = restCollection;
    }

    public void setRouteCollection(RoutesDefinition routeCollection) {
        this.routeCollection = routeCollection;
    }

    public RoutesDefinition getRouteCollection() {
        return this.routeCollection;
    }

    public RouteTemplatesDefinition getRouteTemplateCollection() {
        return this.routeTemplateCollection;
    }

    public void setRouteTemplateCollection(RouteTemplatesDefinition routeTemplateCollection) {
        this.routeTemplateCollection = routeTemplateCollection;
    }

    protected void configureRest(RestDefinition rest) {
    }

    protected void configureRoute(RouteDefinition route) {
    }

    protected void configureRouteTemplate(RouteTemplateDefinition routeTemplate) {
    }
}

