/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.NumericUtils;

final class LatLonPointDistanceQuery
extends Query {
    final String field;
    final double latitude;
    final double longitude;
    final double radiusMeters;

    public LatLonPointDistanceQuery(String field, double latitude, double longitude, double radiusMeters) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (!Double.isFinite(radiusMeters) || radiusMeters < 0.0) {
            throw new IllegalArgumentException("radiusMeters: '" + radiusMeters + "' is invalid");
        }
        GeoUtils.checkLatitude(latitude);
        GeoUtils.checkLongitude(longitude);
        this.field = field;
        this.latitude = latitude;
        this.longitude = longitude;
        this.radiusMeters = radiusMeters;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        int minLon2;
        int maxLon;
        int minLon;
        Rectangle box = Rectangle.fromPointDistance(this.latitude, this.longitude, this.radiusMeters);
        final int minLat = GeoEncodingUtils.encodeLatitude(box.minLat);
        final int maxLat = GeoEncodingUtils.encodeLatitude(box.maxLat);
        if (box.crossesDateline()) {
            minLon = Integer.MIN_VALUE;
            maxLon = GeoEncodingUtils.encodeLongitude(box.maxLon);
            minLon2 = GeoEncodingUtils.encodeLongitude(box.minLon);
        } else {
            minLon = GeoEncodingUtils.encodeLongitude(box.minLon);
            maxLon = GeoEncodingUtils.encodeLongitude(box.maxLon);
            minLon2 = Integer.MAX_VALUE;
        }
        final double sortKey = GeoUtils.distanceQuerySortKey(this.radiusMeters);
        final double axisLat = Rectangle.axisLat(this.latitude, this.radiusMeters);
        return new ConstantScoreWeight(this, boost){
            final GeoEncodingUtils.DistancePredicate distancePredicate;
            {
                super(query2, score);
                this.distancePredicate = GeoEncodingUtils.createDistancePredicate(LatLonPointDistanceQuery.this.latitude, LatLonPointDistanceQuery.this.longitude, LatLonPointDistanceQuery.this.radiusMeters);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context2) throws IOException {
                final LeafReader reader = context2.reader();
                final PointValues values = reader.getPointValues(LatLonPointDistanceQuery.this.field);
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(LatLonPointDistanceQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                LatLonPoint.checkCompatible(fieldInfo);
                final DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values);
                final PointValues.IntersectVisitor visitor = this.getIntersectVisitor(result);
                return new ScorerSupplier(){
                    long cost = -1L;

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        if (values.getDocCount() == reader.maxDoc() && (long)values.getDocCount() == values.size() && this.cost() > (long)(reader.maxDoc() / 2)) {
                            FixedBitSet result2 = new FixedBitSet(reader.maxDoc());
                            result2.set(0, reader.maxDoc());
                            long[] cost = new long[]{reader.maxDoc()};
                            values.intersect(this.getInverseIntersectVisitor(result2, cost));
                            BitSetIterator iterator = new BitSetIterator(result2, cost[0]);
                            return new ConstantScoreScorer(this.score(), scoreMode, iterator);
                        }
                        values.intersect(visitor);
                        return new ConstantScoreScorer(this.score(), scoreMode, result.build().iterator());
                    }

                    @Override
                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = values.estimateDocCount(visitor);
                        }
                        assert (this.cost >= 0L);
                        return this.cost;
                    }
                };
            }

            private boolean matches(byte[] packedValue) {
                int lat = NumericUtils.sortableBytesToInt(packedValue, 0);
                if (lat > maxLat || lat < minLat) {
                    return false;
                }
                int lon = NumericUtils.sortableBytesToInt(packedValue, 4);
                if ((lon > maxLon || lon < minLon) && lon < minLon2) {
                    return false;
                }
                return this.distancePredicate.test(lat, lon);
            }

            private PointValues.Relation relate(byte[] minPackedValue, byte[] maxPackedValue) {
                int latLowerBound = NumericUtils.sortableBytesToInt(minPackedValue, 0);
                int latUpperBound = NumericUtils.sortableBytesToInt(maxPackedValue, 0);
                if (latLowerBound > maxLat || latUpperBound < minLat) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                int lonLowerBound = NumericUtils.sortableBytesToInt(minPackedValue, 4);
                int lonUpperBound = NumericUtils.sortableBytesToInt(maxPackedValue, 4);
                if ((lonLowerBound > maxLon || lonUpperBound < minLon) && lonUpperBound < minLon2) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                double latMin = GeoEncodingUtils.decodeLatitude(latLowerBound);
                double lonMin = GeoEncodingUtils.decodeLongitude(lonLowerBound);
                double latMax = GeoEncodingUtils.decodeLatitude(latUpperBound);
                double lonMax = GeoEncodingUtils.decodeLongitude(lonUpperBound);
                return GeoUtils.relate(latMin, latMax, lonMin, lonMax, LatLonPointDistanceQuery.this.latitude, LatLonPointDistanceQuery.this.longitude, sortKey, axisLat);
            }

            private PointValues.IntersectVisitor getIntersectVisitor(final DocIdSetBuilder result) {
                return new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    @Override
                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    @Override
                    public void visit(int docID) {
                        this.adder.add(docID);
                    }

                    @Override
                    public void visit(IntsRef ref) {
                        this.adder.add(ref);
                    }

                    @Override
                    public void visit(DocIdSetIterator iterator) throws IOException {
                        this.adder.add(iterator);
                    }

                    @Override
                    public void visit(int docID, byte[] packedValue) {
                        if (this.matches(packedValue)) {
                            this.visit(docID);
                        }
                    }

                    @Override
                    public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
                        if (this.matches(packedValue)) {
                            this.adder.add(iterator);
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        return this.relate(minPackedValue, maxPackedValue);
                    }
                };
            }

            private PointValues.IntersectVisitor getInverseIntersectVisitor(final FixedBitSet result, final long[] cost) {
                return new PointValues.IntersectVisitor(){

                    @Override
                    public void visit(int docID) {
                        result.clear(docID);
                        cost[0] = cost[0] - 1L;
                    }

                    @Override
                    public void visit(IntsRef ref) {
                        for (int i = 0; i < ref.length; ++i) {
                            result.clear(ref.ints[ref.offset + i]);
                        }
                        cost[0] = Math.max(0L, cost[0] - (long)ref.length);
                    }

                    @Override
                    public void visit(DocIdSetIterator iterator) throws IOException {
                        result.andNot(iterator);
                        cost[0] = Math.max(0L, cost[0] - iterator.cost());
                    }

                    @Override
                    public void visit(int docID, byte[] packedValue) {
                        if (!this.matches(packedValue)) {
                            this.visit(docID);
                        }
                    }

                    @Override
                    public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
                        if (!this.matches(packedValue)) {
                            this.visit(iterator);
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        PointValues.Relation relation = this.relate(minPackedValue, maxPackedValue);
                        switch (relation) {
                            case CELL_INSIDE_QUERY: {
                                return PointValues.Relation.CELL_OUTSIDE_QUERY;
                            }
                            case CELL_OUTSIDE_QUERY: {
                                return PointValues.Relation.CELL_INSIDE_QUERY;
                            }
                        }
                        return relation;
                    }
                };
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getRadiusMeters() {
        return this.radiusMeters;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + this.field.hashCode();
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.radiusMeters);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((LatLonPointDistanceQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(LatLonPointDistanceQuery other) {
        return this.field.equals(other.field) && Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(other.latitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(other.longitude) && Double.doubleToLongBits(this.radiusMeters) == Double.doubleToLongBits(other.radiusMeters);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.latitude);
        sb.append(",");
        sb.append(this.longitude);
        sb.append(" +/- ");
        sb.append(this.radiusMeters);
        sb.append(" meters");
        return sb.toString();
    }
}

