/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.impl;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.graph.impl.LiteralValue;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.JenaParameters;
import org.apache.jena.vocabulary.RDF;

public final class LiteralLabel {
    private String lexicalForm;
    private final String lang;
    private final TextDirection textDir;
    private RDFDatatype dtype;
    private Object value = null;
    private static ValueMode valueMode = ValueMode.LAZY;
    private boolean wellformed = false;
    private final int hash;
    private volatile Object value1 = null;
    private static final Object invalidValue = new Object();

    LiteralLabel(String lex, RDFDatatype datatype) {
        this(lex, "", null, datatype);
    }

    LiteralLabel(String lex, String lang, TextDirection textDir, RDFDatatype datatype) {
        this.lexicalForm = lex;
        this.dtype = Objects.requireNonNull(datatype);
        this.lang = lang;
        this.textDir = textDir;
        this.hash = this.calcHashCode();
        switch (valueMode.ordinal()) {
            case 0: {
                this.wellformed = this.setValue(lex, this.dtype);
                this.dtype = LiteralLabel.normalize(this.value, this.dtype);
                break;
            }
            case 1: {
                this.value = null;
            }
        }
    }

    LiteralLabel(Object value) {
        this(value, LiteralValue.datatypeForValueAny(value));
    }

    LiteralLabel(Object value, RDFDatatype datatype) throws DatatypeFormatException {
        this.dtype = datatype;
        this.lang = "";
        this.textDir = null;
        if (value instanceof String) {
            String lex;
            this.lexicalForm = lex = (String)value;
            this.wellformed = this.setValue(lex, datatype);
            this.dtype = LiteralLabel.normalize(value, datatype);
            this.hash = this.calcHashCode();
            return;
        }
        this.value = datatype == null ? value : datatype.cannonicalise(value);
        this.dtype = LiteralLabel.normalize(value, datatype);
        this.wellformed = this.dtype.isValidValue(value);
        if (JenaParameters.enableEagerLiteralValidation && !this.wellformed) {
            throw new DatatypeFormatException(value.toString(), datatype, "in literal creation");
        }
        this.lexicalForm = datatype == null ? value.toString() : datatype.unparse(value);
        this.hash = this.calcHashCode();
    }

    LiteralLabel(String lex, Object value, RDFDatatype dtype) throws DatatypeFormatException {
        this.dtype = Objects.requireNonNull(dtype);
        this.lexicalForm = Objects.requireNonNull(lex);
        this.value = Objects.requireNonNull(value);
        this.lang = "";
        this.textDir = null;
        this.wellformed = true;
        this.hash = this.calcHashCode();
    }

    private boolean setValue(String lex, RDFDatatype dtype) throws DatatypeFormatException {
        try {
            this.value = dtype.parse(lex);
            return true;
        }
        catch (DatatypeFormatException e2) {
            if (JenaParameters.enableEagerLiteralValidation) {
                throw e2;
            }
            return false;
        }
    }

    private static String indexingLang(String lang) {
        return lang;
    }

    public Object getValue() throws DatatypeFormatException {
        Object val = this.getValueInternal();
        if (!this.wellformed) {
            throw new DatatypeFormatException(this.lexicalForm, this.dtype, (Throwable)null);
        }
        if (val != null) {
            return val;
        }
        if (!JenaParameters.enableEagerLiteralValidation) {
            throw new DatatypeFormatException();
        }
        return null;
    }

    private Object getValueInternal() {
        ValueMode valueMode = LiteralLabel.valueMode;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"EAGER", "LAZY"}, (ValueMode)valueMode, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                return this.value;
            }
            case 1: {
                Object v = this.getValueLazy();
                return v == invalidValue ? null : v;
            }
            case -1: 
        }
        throw new InternalErrorException();
    }

    private Object getValueLazy() {
        switch (valueMode.ordinal()) {
            case 0: {
                return this.value;
            }
            case 1: {
                return this.getSetValueLazily();
            }
        }
        throw new InternalErrorException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getSetValueLazily() {
        if (this.value != null) {
            return this.value;
        }
        if (this.value1 != null) {
            return this.value1;
        }
        LiteralLabel literalLabel = this;
        synchronized (literalLabel) {
            if (this.value1 == null) {
                this.value1 = this.calcValueFromLex(this.lexicalForm);
            }
            return this.value1;
        }
    }

    private Object calcValueFromLex(String lex) {
        try {
            Object v = this.dtype.parse(lex);
            this.wellformed = true;
            this.dtype = this.dtype.normalizeSubType(v, this.dtype);
            return v;
        }
        catch (DatatypeFormatException e2) {
            this.wellformed = false;
            return invalidValue;
        }
    }

    protected static RDFDatatype normalize(Object value, RDFDatatype datatype) {
        if (datatype != null && value != null) {
            return datatype.normalizeSubType(value, datatype);
        }
        return datatype;
    }

    public boolean isWellFormed() {
        return this.dtype != null && this.isWellFormedRaw();
    }

    private boolean isWellFormedRaw() {
        if (this.wellformed) {
            return true;
        }
        this.getValueInternal();
        return this.wellformed;
    }

    public String toString(boolean quoting) {
        return this.toString(PrefixMapping.Standard, quoting);
    }

    public String toString(PrefixMapping pmap, boolean quoting) {
        StringBuilder b = new StringBuilder();
        if (!quoting && this.dtype.equals(XSDDatatype.XSDstring)) {
            return this.getLexicalForm();
        }
        quoting = true;
        if (quoting) {
            b.append('\"');
        }
        String elex = EscapeStr.stringEsc(this.getLexicalForm());
        b.append(elex);
        if (quoting) {
            b.append('\"');
        }
        if (this.lang != null && !this.lang.equals("")) {
            b.append("@").append(this.lang);
            if (this.textDir != null) {
                b.append("--").append((Object)this.textDir);
            }
        } else if (!this.dtype.equals(XSDDatatype.XSDstring)) {
            String dtStr = pmap != null ? PrefixMapping.Standard.shortForm(this.dtype.getURI()) : this.dtype.getURI();
            b.append("^^").append(dtStr);
        }
        return b.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public String getLexicalForm() {
        return this.lexicalForm;
    }

    public Object getIndexingValue() {
        if (this.indexingValueIsSelf()) {
            return this;
        }
        if (!this.lang.equals("")) {
            return this.getLexicalForm() + "@" + LiteralLabel.indexingLang(this.lang);
        }
        Object value = this.getValueInternal();
        if (this.wellformed) {
            if (value instanceof byte[]) {
                return new ByteArray((byte[])value);
            }
            return value;
        }
        return this.getLexicalForm();
    }

    private boolean indexingValueIsSelf() {
        return this.dtype == RDF.dtXMLLiteral || this.dtype == RDF.dtRDFJSON || this.dtype == RDF.dtRDFHTML;
    }

    public String language() {
        return this.lang;
    }

    public TextDirection baseDirection() {
        return this.textDir;
    }

    public RDFDatatype getDatatype() {
        return this.dtype;
    }

    public String getDatatypeURI() {
        if (this.dtype == null) {
            return null;
        }
        return this.dtype.getURI();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof LiteralLabel)) {
            return false;
        }
        LiteralLabel otherLiteral = (LiteralLabel)other;
        boolean typeEquals = Objects.equals(this.dtype, otherLiteral.getDatatype());
        if (!typeEquals) {
            return false;
        }
        boolean lexEquals = Objects.equals(this.getLexicalForm(), otherLiteral.getLexicalForm());
        if (!lexEquals) {
            return false;
        }
        boolean langEquals = Objects.equals(this.lang, otherLiteral.language());
        if (!langEquals) {
            return false;
        }
        boolean dirEquals = Objects.equals((Object)this.textDir, (Object)otherLiteral.baseDirection());
        return dirEquals;
    }

    public boolean sameValueAs(LiteralLabel other) {
        return LiteralLabel.sameValueAs(this, other);
    }

    private static boolean sameValueAs(LiteralLabel lit1, LiteralLabel lit2) {
        if (lit1 == null) {
            throw new NullPointerException();
        }
        if (lit2 == null) {
            throw new NullPointerException();
        }
        if (LiteralLabel.isStringValue(lit1) && LiteralLabel.isStringValue(lit2)) {
            return lit1.getLexicalForm().equals(lit2.getLexicalForm());
        }
        if (LiteralLabel.isStringValue(lit1)) {
            return false;
        }
        if (LiteralLabel.isStringValue(lit2)) {
            return false;
        }
        if (LiteralLabel.isLangString(lit1) && LiteralLabel.isLangString(lit2)) {
            String lex2;
            String lex1 = lit1.getLexicalForm();
            return lex1.equals(lex2 = lit2.getLexicalForm()) && lit1.language().equalsIgnoreCase(lit2.language());
        }
        if (LiteralLabel.isLangString(lit1)) {
            return false;
        }
        if (LiteralLabel.isLangString(lit2)) {
            return false;
        }
        if (LiteralLabel.isLangStringDir(lit1) && LiteralLabel.isLangStringDir(lit2)) {
            String lex2;
            String lex1 = lit1.getLexicalForm();
            return lex1.equals(lex2 = lit2.getLexicalForm()) && lit1.language().equalsIgnoreCase(lit2.language()) && lit1.baseDirection().equals((Object)lit2.baseDirection());
        }
        if (LiteralLabel.isLangStringDir(lit1)) {
            return false;
        }
        if (LiteralLabel.isLangStringDir(lit2)) {
            return false;
        }
        if (lit1.isWellFormedRaw() && lit2.isWellFormedRaw()) {
            return lit1.getDatatype().isEqual(lit1, lit2);
        }
        if (!lit1.isWellFormedRaw() && !lit2.isWellFormedRaw()) {
            return lit1.equals(lit2);
        }
        return false;
    }

    private static boolean isStringValue(LiteralLabel lit) {
        if (lit.getDatatype() == null) {
            return !LiteralLabel.isLangString(lit);
        }
        return lit.getDatatype().equals(XSDDatatype.XSDstring);
    }

    private static boolean isLangString(LiteralLabel lit) {
        if (Lib.isEmpty(lit.language())) {
            return false;
        }
        if (lit.baseDirection() != null) {
            return false;
        }
        if (!Objects.equals(lit.getDatatype(), RDF.dtLangString)) {
            throw new JenaException("Literal with language string which is not rdf:langString: " + String.valueOf(lit));
        }
        return true;
    }

    private static boolean isLangStringDir(LiteralLabel lit) {
        String lang = lit.language();
        if (lit.baseDirection() == null) {
            return false;
        }
        if (!Objects.equals(lit.getDatatype(), RDF.dtDirLangString)) {
            throw new JenaException("Literal with language string and base direction which is not rdf:dirLangString: " + String.valueOf(lit));
        }
        return true;
    }

    private int calcHashCode() {
        return Objects.hash(this.lexicalForm, this.lang, this.dtype);
    }

    public int hashCode() {
        return this.hash;
    }

    public int getValueHashCode() {
        if (this.indexingValueIsSelf()) {
            return this.hashCode();
        }
        Object v = this.getIndexingValue();
        if (!this.wellformed) {
            return this.hashCode();
        }
        return v.hashCode();
    }

    private static enum ValueMode {
        EAGER,
        LAZY;

    }

    static class ByteArray {
        private int hashCode = 0;
        private final byte[] bytes;

        ByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int prime = 31;
                int result = 1;
                this.hashCode = 31 * result + Arrays.hashCode(this.bytes);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ByteArray other = (ByteArray)obj;
            return Arrays.equals(this.bytes, other.bytes);
        }
    }
}

