/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.pushsubscription;

import java.time.OffsetDateTime;
import java.util.UUID;
import org.apache.james.backends.postgres.PostgresCommons;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public interface PostgresPushSubscriptionDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{PushSubscriptionTable.TABLE}).addIndex(new PostgresIndex[]{PushSubscriptionTable.USERNAME_INDEX, PushSubscriptionTable.USERNAME_ID_INDEX}).build();

    public static interface PushSubscriptionTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"push_subscription");
        public static final String PRIMARY_KEY_CONSTRAINT = "push_subscription_primary_key_constraint";
        public static final Field<String> USER = DSL.field((String)"username", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> DEVICE_CLIENT_ID = DSL.field((String)"device_client_id", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<UUID> ID = DSL.field((String)"id", (DataType)SQLDataType.UUID.notNull());
        public static final Field<OffsetDateTime> EXPIRES = DSL.field((String)"expires", (DataType)PostgresCommons.DataTypes.TIMESTAMP_WITH_TIMEZONE);
        public static final Field<String[]> TYPES = DSL.field((String)"types", (DataType)PostgresCommons.DataTypes.STRING_ARRAY.notNull());
        public static final Field<String> URL = DSL.field((String)"url", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> VERIFICATION_CODE = DSL.field((String)"verification_code", (DataType)SQLDataType.VARCHAR);
        public static final Field<String> ENCRYPT_PUBLIC_KEY = DSL.field((String)"encrypt_public_key", (DataType)SQLDataType.VARCHAR);
        public static final Field<String> ENCRYPT_AUTH_SECRET = DSL.field((String)"encrypt_auth_secret", (DataType)SQLDataType.VARCHAR);
        public static final Field<Boolean> VALIDATED = DSL.field((String)"validated", (DataType)SQLDataType.BOOLEAN.notNull());
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(USER).column(DEVICE_CLIENT_ID).column(ID).column(EXPIRES).column(TYPES).column(URL).column(VERIFICATION_CODE).column(ENCRYPT_PUBLIC_KEY).column(ENCRYPT_AUTH_SECRET).column(VALIDATED).constraint((Constraint)DSL.constraint((String)PRIMARY_KEY_CONSTRAINT).primaryKey(new Field[]{USER, DEVICE_CLIENT_ID}))).supportsRowLevelSecurity().build();
        public static final PostgresIndex USERNAME_INDEX = PostgresIndex.name((String)"push_subscription_username_index").createIndexStep((dslContext, indexName) -> dslContext.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{USER}));
        public static final PostgresIndex USERNAME_ID_INDEX = PostgresIndex.name((String)"push_subscription_username_id_index").createIndexStep((dslContext, indexName) -> dslContext.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{USER, ID}));
    }
}

