/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Set;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.eventsourcing.Subscriber;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.modules.blobstore.validation.RegisterStorageStrategy;
import org.apache.james.modules.blobstore.validation.RegisterStorageStrategyCommandHandler;
import org.apache.james.server.blob.deduplication.StorageStrategy;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class EventsourcingStorageStrategy {
    private static final ImmutableSet<Subscriber> NO_SUBSCRIBER = ImmutableSet.of();
    private final EventSourcingSystem eventSourcingSystem;

    @Inject
    public EventsourcingStorageStrategy(EventStore eventStore) {
        this.eventSourcingSystem = EventSourcingSystem.fromJava((Set)ImmutableSet.of((Object)new RegisterStorageStrategyCommandHandler(eventStore)), NO_SUBSCRIBER, (EventStore)eventStore);
    }

    public void registerStorageStrategy(StorageStrategy newStorageStrategy) {
        Preconditions.checkNotNull((Object)newStorageStrategy);
        Mono.from((Publisher)this.eventSourcingSystem.dispatch((Command)new RegisterStorageStrategy(newStorageStrategy))).block();
    }
}

