/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import java.io.Serializable;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.JmapConfigProperties$;
import org.apache.james.jmap.core.JmapEmailGetFullMaxSize;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.JmapUploadQuotaLimit;
import org.apache.james.jmap.core.JmapUploadQuotaLimit$;
import org.apache.james.jmap.core.MaxObjectsInGet;
import org.apache.james.jmap.core.MaxObjectsInSet;
import org.apache.james.jmap.core.MaxSizeAttachmentsPerEmail;
import org.apache.james.jmap.core.MaxSizeAttachmentsPerEmail$;
import org.apache.james.jmap.core.MaxSizeUpload;
import org.apache.james.jmap.core.MaxSizeUpload$;
import org.apache.james.jmap.core.UnsignedInt$;
import org.apache.james.util.DurationParser;
import org.apache.james.util.Size;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple16;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.jdk.DurationConverters;
import scala.jdk.DurationConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class JmapRfc8621Configuration$
implements Serializable {
    public static final JmapRfc8621Configuration$ MODULE$ = new JmapRfc8621Configuration$();
    private static final String URL_PREFIX_DEFAULT = "http://localhost";
    private static final String WEBSOCKET_URL_PREFIX_DEFAULT = "ws://localhost";
    private static final MaxSizeUpload UPLOAD_LIMIT_DEFAULT = (MaxSizeUpload)MaxSizeUpload$.MODULE$.of(Size.of((Long)Predef$.MODULE$.long2Long(30L), (Size.Unit)Size.Unit.M)).get();
    private static final MaxSizeAttachmentsPerEmail MAX_SIZE_ATTACHMENTS_PER_MAIL_DEFAULT = (MaxSizeAttachmentsPerEmail)MaxSizeAttachmentsPerEmail$.MODULE$.of(Size.of((Long)Predef$.MODULE$.long2Long(20000000L), (Size.Unit)Size.Unit.B)).get();
    private static final JmapUploadQuotaLimit JMAP_UPLOAD_QUOTA_LIMIT_DEFAULT = (JmapUploadQuotaLimit)JmapUploadQuotaLimit$.MODULE$.of(Size.of((Long)Predef$.MODULE$.long2Long(200L), (Size.Unit)Size.Unit.M)).get();
    private static final JmapEmailGetFullMaxSize JMAP_EMAIL_GET_FULL_MAX_SIZE_DEFAULT = new JmapEmailGetFullMaxSize(UnsignedInt$.MODULE$.liftOrThrow(5L));
    private static final MaxObjectsInGet JMAP_MAX_OBJECT_IN_GET = new MaxObjectsInGet(UnsignedInt$.MODULE$.liftOrThrow(500L));
    private static final MaxObjectsInSet JMAP_MAX_OBJECT_IN_SET = new MaxObjectsInSet(UnsignedInt$.MODULE$.liftOrThrow(500L));
    private static final JmapRfc8621Configuration LOCALHOST_CONFIGURATION;

    static {
        String x$1 = MODULE$.URL_PREFIX_DEFAULT();
        String x$2 = MODULE$.WEBSOCKET_URL_PREFIX_DEFAULT();
        MaxSizeUpload x$3 = MODULE$.UPLOAD_LIMIT_DEFAULT();
        Option<Duration> x$4 = MODULE$.apply$default$3();
        boolean x$5 = MODULE$.apply$default$4();
        boolean x$6 = MODULE$.apply$default$5();
        MaxSizeAttachmentsPerEmail x$7 = MODULE$.apply$default$7();
        JmapUploadQuotaLimit x$8 = MODULE$.apply$default$8();
        JmapEmailGetFullMaxSize x$9 = MODULE$.apply$default$9();
        MaxObjectsInGet x$10 = MODULE$.apply$default$10();
        MaxObjectsInSet x$11 = MODULE$.apply$default$11();
        Option<Object> x$12 = MODULE$.apply$default$12();
        Option<Object> x$13 = MODULE$.apply$default$13();
        Option<List<String>> x$14 = MODULE$.apply$default$14();
        boolean x$15 = MODULE$.apply$default$15();
        Set<Refined<String, string.Uri>> x$16 = MODULE$.apply$default$16();
        LOCALHOST_CONFIGURATION = new JmapRfc8621Configuration(x$1, x$2, x$4, x$5, x$6, x$3, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
    }

    public Option<Duration> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public boolean $lessinit$greater$default$4() {
        return false;
    }

    public boolean $lessinit$greater$default$5() {
        return false;
    }

    public MaxSizeUpload $lessinit$greater$default$6() {
        return this.UPLOAD_LIMIT_DEFAULT();
    }

    public MaxSizeAttachmentsPerEmail $lessinit$greater$default$7() {
        return this.MAX_SIZE_ATTACHMENTS_PER_MAIL_DEFAULT();
    }

    public JmapUploadQuotaLimit $lessinit$greater$default$8() {
        return this.JMAP_UPLOAD_QUOTA_LIMIT_DEFAULT();
    }

    public JmapEmailGetFullMaxSize $lessinit$greater$default$9() {
        return this.JMAP_EMAIL_GET_FULL_MAX_SIZE_DEFAULT();
    }

    public MaxObjectsInGet $lessinit$greater$default$10() {
        return this.JMAP_MAX_OBJECT_IN_GET();
    }

    public MaxObjectsInSet $lessinit$greater$default$11() {
        return this.JMAP_MAX_OBJECT_IN_SET();
    }

    public Option<Object> $lessinit$greater$default$12() {
        return None$.MODULE$;
    }

    public Option<Object> $lessinit$greater$default$13() {
        return None$.MODULE$;
    }

    public Option<List<String>> $lessinit$greater$default$14() {
        return None$.MODULE$;
    }

    public boolean $lessinit$greater$default$15() {
        return true;
    }

    public Set<Refined<String, string.Uri>> $lessinit$greater$default$16() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }

    public String URL_PREFIX_DEFAULT() {
        return URL_PREFIX_DEFAULT;
    }

    public String WEBSOCKET_URL_PREFIX_DEFAULT() {
        return WEBSOCKET_URL_PREFIX_DEFAULT;
    }

    public MaxSizeUpload UPLOAD_LIMIT_DEFAULT() {
        return UPLOAD_LIMIT_DEFAULT;
    }

    public MaxSizeAttachmentsPerEmail MAX_SIZE_ATTACHMENTS_PER_MAIL_DEFAULT() {
        return MAX_SIZE_ATTACHMENTS_PER_MAIL_DEFAULT;
    }

    public JmapUploadQuotaLimit JMAP_UPLOAD_QUOTA_LIMIT_DEFAULT() {
        return JMAP_UPLOAD_QUOTA_LIMIT_DEFAULT;
    }

    public JmapEmailGetFullMaxSize JMAP_EMAIL_GET_FULL_MAX_SIZE_DEFAULT() {
        return JMAP_EMAIL_GET_FULL_MAX_SIZE_DEFAULT;
    }

    public MaxObjectsInGet JMAP_MAX_OBJECT_IN_GET() {
        return JMAP_MAX_OBJECT_IN_GET;
    }

    public MaxObjectsInSet JMAP_MAX_OBJECT_IN_SET() {
        return JMAP_MAX_OBJECT_IN_SET;
    }

    public JmapRfc8621Configuration LOCALHOST_CONFIGURATION() {
        return LOCALHOST_CONFIGURATION;
    }

    public JmapRfc8621Configuration from(Configuration configuration) {
        String x$12 = (String)Option$.MODULE$.apply((Object)configuration.getString(JmapConfigProperties$.MODULE$.URL_PREFIX_PROPERTY())).getOrElse((Function0 & Serializable)() -> MODULE$.URL_PREFIX_DEFAULT());
        String x$22 = (String)Option$.MODULE$.apply((Object)configuration.getString(JmapConfigProperties$.MODULE$.WEBSOCKET_URL_PREFIX_PROPERTY())).getOrElse((Function0 & Serializable)() -> MODULE$.WEBSOCKET_URL_PREFIX_DEFAULT());
        Option x$32 = Option$.MODULE$.apply((Object)configuration.getString(JmapConfigProperties$.MODULE$.WEBSOCKET_PING_INTERVAL_PROPERTY())).map((Function1 & Serializable)x$1 -> DurationParser.parse((String)x$1, (ChronoUnit)ChronoUnit.SECONDS)).map((Function1 & Serializable)duration -> {
            Preconditions.checkArgument((!duration.isZero() && !duration.isNegative() ? 1 : 0) != 0, (Object)("`" + JmapConfigProperties$.MODULE$.WEBSOCKET_PING_INTERVAL_PROPERTY() + "` must be positive"));
            return DurationConverters.JavaDurationOps$.MODULE$.toScala$extension(DurationConverters$.MODULE$.JavaDurationOps(duration));
        });
        boolean x$42 = configuration.getBoolean(JmapConfigProperties$.MODULE$.DYNAMIC_JMAP_PREFIX_RESOLUTION_ENABLED_PROPERTY(), false);
        boolean x$5 = configuration.getBoolean(JmapConfigProperties$.MODULE$.DELAY_SENDS_ENABLED(), false);
        MaxSizeUpload x$6 = (MaxSizeUpload)Option$.MODULE$.apply((Object)configuration.getString(JmapConfigProperties$.MODULE$.UPLOAD_LIMIT_PROPERTY(), null)).map((Function1 & Serializable)providedLongWithUnitString -> Size.parse((String)providedLongWithUnitString)).map((Function1 & Serializable)x$2 -> (MaxSizeUpload)MaxSizeUpload$.MODULE$.of((Size)x$2).get()).getOrElse((Function0 & Serializable)() -> MODULE$.UPLOAD_LIMIT_DEFAULT());
        MaxSizeAttachmentsPerEmail x$7 = (MaxSizeAttachmentsPerEmail)Option$.MODULE$.apply((Object)configuration.getString(JmapConfigProperties$.MODULE$.MAX_SIZE_ATTACHMENTS_PER_MAIL_PROPERTY(), null)).map((Function1 & Serializable)providedLongWithUnitString -> Size.parse((String)providedLongWithUnitString)).map((Function1 & Serializable)x$3 -> (MaxSizeAttachmentsPerEmail)MaxSizeAttachmentsPerEmail$.MODULE$.of((Size)x$3).get()).getOrElse((Function0 & Serializable)() -> MODULE$.MAX_SIZE_ATTACHMENTS_PER_MAIL_DEFAULT());
        JmapUploadQuotaLimit x$8 = (JmapUploadQuotaLimit)Option$.MODULE$.apply((Object)configuration.getString(JmapConfigProperties$.MODULE$.JMAP_UPLOAD_QUOTA_LIMIT_PROPERTY(), null)).map((Function1 & Serializable)providedLongWithUnitString -> Size.parse((String)providedLongWithUnitString)).map((Function1 & Serializable)x$4 -> (JmapUploadQuotaLimit)JmapUploadQuotaLimit$.MODULE$.of((Size)x$4).get()).getOrElse((Function0 & Serializable)() -> MODULE$.JMAP_UPLOAD_QUOTA_LIMIT_DEFAULT());
        JmapEmailGetFullMaxSize x$9 = (JmapEmailGetFullMaxSize)Option$.MODULE$.apply((Object)configuration.getLong(JmapConfigProperties$.MODULE$.JMAP_EMAIL_GET_FULL_MAX_SIZE_PROPERTY(), null)).map((Function1 & Serializable)value -> new JmapEmailGetFullMaxSize(UnsignedInt$.MODULE$.liftOrThrow(Predef$.MODULE$.Long2long(value)))).getOrElse((Function0 & Serializable)() -> MODULE$.JMAP_EMAIL_GET_FULL_MAX_SIZE_DEFAULT());
        MaxObjectsInGet x$10 = (MaxObjectsInGet)Option$.MODULE$.apply((Object)configuration.getLong(JmapConfigProperties$.MODULE$.JMAP_GET_MAX_SIZE_PROPERTY(), null)).map((Function1 & Serializable)value -> new MaxObjectsInGet(UnsignedInt$.MODULE$.liftOrThrow(Predef$.MODULE$.Long2long(value)))).getOrElse((Function0 & Serializable)() -> MODULE$.JMAP_MAX_OBJECT_IN_GET());
        MaxObjectsInSet x$11 = (MaxObjectsInSet)Option$.MODULE$.apply((Object)configuration.getLong(JmapConfigProperties$.MODULE$.JMAP_SET_MAX_SIZE_PROPERTY(), null)).map((Function1 & Serializable)value -> new MaxObjectsInSet(UnsignedInt$.MODULE$.liftOrThrow(Predef$.MODULE$.Long2long(value)))).getOrElse((Function0 & Serializable)() -> MODULE$.JMAP_MAX_OBJECT_IN_SET());
        Option x$122 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(Optional.ofNullable(configuration.getInteger(JmapConfigProperties$.MODULE$.WEB_PUSH_MAX_TIMEOUT_SECONDS_PROPERTY(), null)).map(x -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x)))));
        Option x$13 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(Optional.ofNullable(configuration.getInteger(JmapConfigProperties$.MODULE$.WEB_PUSH_MAX_CONNECTIONS_PROPERTY(), null)).map(x -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x)))));
        boolean x$14 = Predef$.MODULE$.Boolean2boolean(Optional.ofNullable(configuration.getBoolean(JmapConfigProperties$.MODULE$.WEB_PUSH_PREVENT_SERVER_SIDE_REQUEST_FORGERY(), null)).orElse(Predef$.MODULE$.boolean2Boolean(true)));
        Option x$15 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(Optional.ofNullable(configuration.getList(String.class, JmapConfigProperties$.MODULE$.AUTHENTICATION_STRATEGIES(), null))));
        Set x$16 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(Optional.ofNullable(configuration.getList(String.class, JmapConfigProperties$.MODULE$.DISABLED_CAPABILITIES(), null)).orElse((List)ImmutableList.of())).asScala().flatMap((Function1 & Serializable)s -> CapabilityIdentifier$.MODULE$.parse((String)s).toOption())).toSet();
        return new JmapRfc8621Configuration(x$12, x$22, (Option<Duration>)x$32, x$42, x$5, x$6, x$7, x$8, x$9, x$10, x$11, (Option<Object>)x$122, (Option<Object>)x$13, (Option<List<String>>)x$15, x$14, (Set<Refined<String, string.Uri>>)x$16);
    }

    public JmapRfc8621Configuration apply(String urlPrefixString, String websocketPrefixString, Option<Duration> websocketPingInterval, boolean dynamicJmapPrefixResolutionEnabled, boolean supportsDelaySends, MaxSizeUpload maxUploadSize, MaxSizeAttachmentsPerEmail maxSizeAttachmentsPerEmail, JmapUploadQuotaLimit jmapUploadQuotaLimit, JmapEmailGetFullMaxSize jmapEmailGetFullMaxSize, MaxObjectsInGet maxObjectsInGet, MaxObjectsInSet maxObjectsInSet, Option<Object> maxTimeoutSeconds, Option<Object> maxConnections, Option<List<String>> authenticationStrategies, boolean preventServerSideRequestForgery, Set<Refined<String, string.Uri>> disabledCapabilities) {
        return new JmapRfc8621Configuration(urlPrefixString, websocketPrefixString, websocketPingInterval, dynamicJmapPrefixResolutionEnabled, supportsDelaySends, maxUploadSize, maxSizeAttachmentsPerEmail, jmapUploadQuotaLimit, jmapEmailGetFullMaxSize, maxObjectsInGet, maxObjectsInSet, maxTimeoutSeconds, maxConnections, authenticationStrategies, preventServerSideRequestForgery, disabledCapabilities);
    }

    public MaxObjectsInGet apply$default$10() {
        return this.JMAP_MAX_OBJECT_IN_GET();
    }

    public MaxObjectsInSet apply$default$11() {
        return this.JMAP_MAX_OBJECT_IN_SET();
    }

    public Option<Object> apply$default$12() {
        return None$.MODULE$;
    }

    public Option<Object> apply$default$13() {
        return None$.MODULE$;
    }

    public Option<List<String>> apply$default$14() {
        return None$.MODULE$;
    }

    public boolean apply$default$15() {
        return true;
    }

    public Set<Refined<String, string.Uri>> apply$default$16() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }

    public Option<Duration> apply$default$3() {
        return None$.MODULE$;
    }

    public boolean apply$default$4() {
        return false;
    }

    public boolean apply$default$5() {
        return false;
    }

    public MaxSizeUpload apply$default$6() {
        return this.UPLOAD_LIMIT_DEFAULT();
    }

    public MaxSizeAttachmentsPerEmail apply$default$7() {
        return this.MAX_SIZE_ATTACHMENTS_PER_MAIL_DEFAULT();
    }

    public JmapUploadQuotaLimit apply$default$8() {
        return this.JMAP_UPLOAD_QUOTA_LIMIT_DEFAULT();
    }

    public JmapEmailGetFullMaxSize apply$default$9() {
        return this.JMAP_EMAIL_GET_FULL_MAX_SIZE_DEFAULT();
    }

    public Option<Tuple16<String, String, Option<Duration>, Object, Object, MaxSizeUpload, MaxSizeAttachmentsPerEmail, JmapUploadQuotaLimit, JmapEmailGetFullMaxSize, MaxObjectsInGet, MaxObjectsInSet, Option<Object>, Option<Object>, Option<List<String>>, Object, Set<Refined<String, string.Uri>>>> unapply(JmapRfc8621Configuration x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple16((Object)x$0.urlPrefixString(), (Object)x$0.websocketPrefixString(), x$0.websocketPingInterval(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.dynamicJmapPrefixResolutionEnabled()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.supportsDelaySends()), (Object)x$0.maxUploadSize(), (Object)x$0.maxSizeAttachmentsPerEmail(), (Object)x$0.jmapUploadQuotaLimit(), (Object)x$0.jmapEmailGetFullMaxSize(), (Object)x$0.maxObjectsInGet(), (Object)x$0.maxObjectsInSet(), x$0.maxTimeoutSeconds(), x$0.maxConnections(), x$0.authenticationStrategies(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.preventServerSideRequestForgery()), x$0.disabledCapabilities()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JmapRfc8621Configuration$.class);
    }

    private JmapRfc8621Configuration$() {
    }
}

