/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.backend.BackendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;

public final class ParameterStatus
implements BackendMessage {
    private final String name;
    private final String value;

    public ParameterStatus(String name, String value) {
        this.name = Assert.requireNonNull(name, "name must not be null");
        this.value = Assert.requireNonNull(value, "value must not be null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterStatus that = (ParameterStatus)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        return "ParameterStatus{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
    }

    static ParameterStatus decode(ByteBuf in) {
        Assert.requireNonNull(in, "in must not be null");
        return new ParameterStatus(BackendMessageUtils.readCStringUTF8(in), BackendMessageUtils.readCStringUTF8(in));
    }
}

