/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.internal.core.channel.EventCallback;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class DriverChannelOptions {
    public static DriverChannelOptions DEFAULT = DriverChannelOptions.builder().build();
    public final CqlIdentifier keyspace;
    public final List<String> eventTypes;
    public final EventCallback eventCallback;
    public final String ownerLogPrefix;

    public static Builder builder() {
        return new Builder();
    }

    private DriverChannelOptions(CqlIdentifier keyspace, List<String> eventTypes, EventCallback eventCallback, String ownerLogPrefix) {
        this.keyspace = keyspace;
        this.eventTypes = eventTypes;
        this.eventCallback = eventCallback;
        this.ownerLogPrefix = ownerLogPrefix;
    }

    public static class Builder {
        private CqlIdentifier keyspace = null;
        private List<String> eventTypes = Collections.emptyList();
        private EventCallback eventCallback = null;
        private String ownerLogPrefix = null;

        public Builder withKeyspace(CqlIdentifier keyspace) {
            this.keyspace = keyspace;
            return this;
        }

        public Builder withEvents(List<String> eventTypes, EventCallback eventCallback) {
            Preconditions.checkArgument((eventTypes != null && !eventTypes.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)eventCallback);
            this.eventTypes = eventTypes;
            this.eventCallback = eventCallback;
            return this;
        }

        public Builder withOwnerLogPrefix(String ownerLogPrefix) {
            this.ownerLogPrefix = ownerLogPrefix;
            return this;
        }

        public DriverChannelOptions build() {
            return new DriverChannelOptions(this.keyspace, this.eventTypes, this.eventCallback, this.ownerLogPrefix);
        }
    }
}

