/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.mailbox.cassandra.mail.task.RecomputeMailboxCountersService;
import org.apache.james.mailbox.cassandra.mail.task.RecomputeMailboxCountersTask;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import spark.Request;

public class RecomputeMailboxCountersRequestToTask
extends TaskFromRequestRegistry.TaskRegistration {
    private static final TaskRegistrationKey REGISTRATION_KEY = TaskRegistrationKey.of((String)"RecomputeMailboxCounters");
    private static final String TRUST_PARAM = "trustMessageProjection";

    @Inject
    public RecomputeMailboxCountersRequestToTask(RecomputeMailboxCountersService service) {
        super(REGISTRATION_KEY, request -> new RecomputeMailboxCountersTask(service, RecomputeMailboxCountersRequestToTask.parseOptions(request)));
    }

    private static RecomputeMailboxCountersService.Options parseOptions(Request request) {
        Optional<String> stringValue = Optional.ofNullable(request.queryParams(TRUST_PARAM));
        return RecomputeMailboxCountersRequestToTask.parseOptions(stringValue);
    }

    @VisibleForTesting
    static RecomputeMailboxCountersService.Options parseOptions(Optional<String> stringValue) {
        return stringValue.map(RecomputeMailboxCountersRequestToTask::parseOptions).orElse(RecomputeMailboxCountersService.Options.recheckMessageProjection());
    }

    private static RecomputeMailboxCountersService.Options parseOptions(String stringValue) {
        Preconditions.checkArgument((boolean)RecomputeMailboxCountersRequestToTask.isValid(stringValue), (String)"'%s' needs to be a valid boolean", (Object)TRUST_PARAM);
        return RecomputeMailboxCountersService.Options.of((boolean)Boolean.valueOf(stringValue));
    }

    private static boolean isValid(String stringValue) {
        return stringValue.equalsIgnoreCase("true") || stringValue.equalsIgnoreCase("false");
    }
}

