/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.MappingsImpl;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraRecipientRewriteTableDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insertStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement retrieveMappingStatement;
    private final PreparedStatement retrieveAllMappingsStatement;

    @Inject
    public CassandraRecipientRewriteTableDAO(CqlSession session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insertStatement = session.prepare(QueryBuilder.insertInto((String)"rrt").value("user", (Term)QueryBuilder.bindMarker((String)"user")).value("domain", (Term)QueryBuilder.bindMarker((String)"domain")).value("mapping", (Term)QueryBuilder.bindMarker((String)"mapping")).build());
        this.retrieveMappingStatement = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"rrt").column("mapping").whereColumn("user").isEqualTo((Term)QueryBuilder.bindMarker((String)"user"))).whereColumn("domain").isEqualTo((Term)QueryBuilder.bindMarker((String)"domain"))).build());
        this.retrieveAllMappingsStatement = session.prepare(QueryBuilder.selectFrom((String)"rrt").columns(new String[]{"user", "domain", "mapping"}).build());
        this.deleteStatement = session.prepare(((Delete)((Delete)((Delete)QueryBuilder.deleteFrom((String)"rrt").whereColumn("user").isEqualTo((Term)QueryBuilder.bindMarker((String)"user"))).whereColumn("domain").isEqualTo((Term)QueryBuilder.bindMarker((String)"domain"))).whereColumn("mapping").isEqualTo((Term)QueryBuilder.bindMarker((String)"mapping"))).build());
    }

    public Mono<Void> addMapping(MappingSource source, Mapping mapping) {
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.insertStatement.bind(new Object[0]).setString("user", source.getFixedUser())).setString("domain", source.getFixedDomain())).setString("mapping", mapping.asString()));
    }

    Mono<Void> removeMapping(MappingSource source, Mapping mapping) {
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.deleteStatement.bind(new Object[0]).setString("user", source.getFixedUser())).setString("domain", source.getFixedDomain())).setString("mapping", mapping.asString()));
    }

    Mono<MappingsImpl> retrieveMappings(MappingSource source) {
        return this.executor.executeRows((Statement)((BoundStatement)this.retrieveMappingStatement.bind(new Object[0]).setString("user", source.getFixedUser())).setString("domain", source.getFixedDomain())).mapNotNull(row -> row.getString("mapping")).collect(ImmutableList.toImmutableList()).map(MappingsImpl::fromCollection).filter(Predicate.not(MappingsImpl::isEmpty));
    }

    public Flux<Pair<MappingSource, Mapping>> getAllMappings() {
        return this.executor.executeRows((Statement)this.retrieveAllMappingsStatement.bind(new Object[0])).map(row -> Pair.of((Object)MappingSource.fromUser((String)row.getString("user"), (String)row.getString("domain")), (Object)Mapping.of((String)row.getString("mapping"))));
    }
}

