/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.binary;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.util.TransformUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeEnum;

public abstract class CompareBinaryColumnTransformer
extends BinaryColumnTransformer {
    protected CompareBinaryColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType, leftTransformer, rightTransformer);
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount) {
        if (leftColumn.mayHaveNull() && leftColumn instanceof RunLengthEncodedColumn || rightColumn.mayHaveNull() && rightColumn instanceof RunLengthEncodedColumn) {
            builder.appendNull(positionCount);
            return;
        }
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                boolean flag = false;
                if (TypeEnum.BINARY.equals((Object)this.leftTransformer.getType().getTypeEnum())) {
                    flag = this.transform(TransformUtils.compare(this.leftTransformer.getType().getBinary(leftColumn, i), this.rightTransformer.getType().getBinary(rightColumn, i)));
                } else if (TypeEnum.BOOLEAN.equals((Object)this.leftTransformer.getType().getTypeEnum())) {
                    flag = this.transform(Boolean.compare(this.leftTransformer.getType().getBoolean(leftColumn, i), this.rightTransformer.getType().getBoolean(rightColumn, i)));
                } else {
                    double left = this.leftTransformer.getType().getDouble(leftColumn, i);
                    double right = this.rightTransformer.getType().getDouble(rightColumn, i);
                    if (!Double.isNaN(left) && !Double.isNaN(right)) {
                        flag = this.transform(Double.compare(left, right));
                    }
                }
                this.returnType.writeBoolean(builder, flag);
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void checkType() {
        if (this.leftTransformer.typeNotEquals(TypeEnum.BOOLEAN) && this.rightTransformer.typeNotEquals(TypeEnum.BOOLEAN)) {
            return;
        }
        throw new UnsupportedOperationException("Unsupported Type");
    }

    protected abstract boolean transform(int var1);
}

