/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.exception;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.thrift.annotation.Nullable;

public class IoTDBException
extends Exception {
    private static final long serialVersionUID = 8480450962311247736L;
    private final int errorCode;
    private final boolean isUserException;
    @Nullable
    private TSStatus status;

    public IoTDBException(String message, int errorCode) {
        super(message);
        this.errorCode = errorCode;
        this.isUserException = false;
    }

    public IoTDBException(String message, int errorCode, boolean isUserException) {
        super(message);
        this.errorCode = errorCode;
        this.isUserException = isUserException;
    }

    public IoTDBException(String message, Throwable cause, int errorCode) {
        super(message, cause);
        this.errorCode = errorCode;
        this.isUserException = false;
    }

    public IoTDBException(Throwable cause, int errorCode) {
        super(cause);
        this.errorCode = errorCode;
        this.isUserException = false;
    }

    public IoTDBException(Throwable cause, int errorCode, boolean isUserException) {
        super(cause);
        this.errorCode = errorCode;
        this.isUserException = isUserException;
    }

    public IoTDBException(TSStatus status) {
        super(status.message);
        this.errorCode = status.getCode();
        this.status = status;
        this.isUserException = false;
    }

    public boolean isUserException() {
        return this.isUserException;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @Nullable
    public TSStatus getStatus() {
        return this.status;
    }
}

