/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite3.internal.table.AntiHijackAsyncCursor;
import org.apache.ignite3.internal.thread.PublicApiThreading;
import org.apache.ignite3.lang.AsyncCursor;
import org.apache.ignite3.lang.Cursor;
import org.apache.ignite3.table.DataStreamerItem;
import org.apache.ignite3.table.DataStreamerOptions;
import org.apache.ignite3.table.DataStreamerReceiverDescriptor;
import org.apache.ignite3.table.DataStreamerTarget;
import org.apache.ignite3.table.criteria.Criteria;
import org.apache.ignite3.table.criteria.CriteriaQueryOptions;
import org.apache.ignite3.table.criteria.CriteriaQuerySource;
import org.apache.ignite3.tx.Transaction;
import org.jetbrains.annotations.Nullable;

abstract class PublicApiThreadingViewBase<T>
implements DataStreamerTarget<T>,
CriteriaQuerySource<T> {
    private final DataStreamerTarget<T> streamerTarget;
    private final CriteriaQuerySource<T> querySource;
    private final Executor asyncContinuationExecutor;

    PublicApiThreadingViewBase(DataStreamerTarget<T> streamerTarget, CriteriaQuerySource<T> querySource, Executor asyncContinuationExecutor) {
        this.streamerTarget = streamerTarget;
        this.querySource = querySource;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    @Override
    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<T>> publisher, @Nullable DataStreamerOptions options) {
        return this.executeAsyncOp(() -> this.streamerTarget.streamData(publisher, options));
    }

    @Override
    public <E, V, A, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R> receiver, Function<E, T> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options) {
        return this.executeAsyncOp(() -> this.streamerTarget.streamData(publisher, receiver, keyFunc, payloadFunc, receiverArg, resultSubscriber, options));
    }

    @Override
    public Cursor<T> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return PublicApiThreadingViewBase.executeSyncOp(() -> this.querySource.query(tx, criteria, indexName, opts));
    }

    @Override
    public CompletableFuture<AsyncCursor<T>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return this.executeAsyncOp(() -> this.querySource.queryAsync(tx, criteria, indexName, opts)).thenApply(cursor -> new AntiHijackAsyncCursor(cursor, this.asyncContinuationExecutor));
    }

    final <U> CompletableFuture<U> executeAsyncOp(Supplier<CompletableFuture<U>> operation) {
        CompletableFuture future = PublicApiThreading.execUserAsyncOperation(operation);
        return PublicApiThreading.preventThreadHijack(future, this.asyncContinuationExecutor);
    }

    static <T> T executeSyncOp(Supplier<T> operation) {
        return PublicApiThreading.execUserSyncOperation(operation);
    }

    static void executeSyncOp(Runnable operation) {
        PublicApiThreading.execUserSyncOperation(operation);
    }
}

