/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster;

public final class ClusterMath {
    private ClusterMath() {
    }

    public static double gossipConvergencePercent(int fanout, int repeatMult, int clusterSize, double lossPercent) {
        double msgLossProb = lossPercent / 100.0;
        return ClusterMath.gossipConvergenceProbability(fanout, repeatMult, clusterSize, msgLossProb) * 100.0;
    }

    public static double gossipConvergenceProbability(int fanout, int repeatMult, int clusterSize, double loss) {
        double fanoutWithLoss = (1.0 - loss) * (double)fanout;
        double spreadSize = (double)clusterSize - Math.pow(clusterSize, -(fanoutWithLoss * (double)repeatMult - 2.0));
        return spreadSize / (double)clusterSize;
    }

    public static int maxMessagesPerGossipTotal(int fanout, int repeatMult, int clusterSize) {
        return clusterSize * ClusterMath.maxMessagesPerGossipPerNode(fanout, repeatMult, clusterSize);
    }

    public static int maxMessagesPerGossipPerNode(int fanout, int repeatMult, int clusterSize) {
        return fanout * repeatMult * ClusterMath.ceilLog2(clusterSize);
    }

    public static long gossipDisseminationTime(int repeatMult, int clusterSize, long gossipInterval) {
        return (long)ClusterMath.gossipPeriodsToSpread(repeatMult, clusterSize) * gossipInterval;
    }

    public static long gossipTimeoutToSweep(int repeatMult, int clusterSize, long gossipInterval) {
        return (long)ClusterMath.gossipPeriodsToSweep(repeatMult, clusterSize) * gossipInterval;
    }

    public static int gossipPeriodsToSweep(int repeatMult, int clusterSize) {
        int periodsToSpread = ClusterMath.gossipPeriodsToSpread(repeatMult, clusterSize);
        return 2 * (periodsToSpread + 1);
    }

    public static int gossipPeriodsToSpread(int repeatMult, int clusterSize) {
        return repeatMult * ClusterMath.ceilLog2(clusterSize);
    }

    public static long suspicionTimeout(int suspicionMult, int clusterSize, long pingInterval) {
        return (long)(suspicionMult * ClusterMath.ceilLog2(clusterSize)) * pingInterval;
    }

    private static int ceilLog2(int num) {
        return 32 - Integer.numberOfLeadingZeros(num);
    }
}

