/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.recovery;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.recovery.DisasterRecoveryApi;
import org.apache.ignite.internal.rest.api.recovery.GlobalPartitionStateResponse;
import org.apache.ignite.internal.rest.api.recovery.GlobalPartitionStatesResponse;
import org.apache.ignite.internal.rest.api.recovery.GlobalZonePartitionStateResponse;
import org.apache.ignite.internal.rest.api.recovery.GlobalZonePartitionStatesResponse;
import org.apache.ignite.internal.rest.api.recovery.LocalPartitionStateResponse;
import org.apache.ignite.internal.rest.api.recovery.LocalPartitionStatesResponse;
import org.apache.ignite.internal.rest.api.recovery.LocalZonePartitionStateResponse;
import org.apache.ignite.internal.rest.api.recovery.LocalZonePartitionStatesResponse;
import org.apache.ignite.internal.rest.api.recovery.ResetPartitionsRequest;
import org.apache.ignite.internal.rest.api.recovery.ResetZonePartitionsRequest;
import org.apache.ignite.internal.rest.api.recovery.RestartPartitionsRequest;
import org.apache.ignite.internal.rest.api.recovery.RestartZonePartitionsRequest;
import org.apache.ignite.internal.rest.exception.handler.IgniteInternalExceptionHandler;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryManager;
import org.apache.ignite.internal.table.distributed.disaster.GlobalPartitionState;
import org.apache.ignite.internal.table.distributed.disaster.GlobalTablePartitionState;
import org.apache.ignite.internal.table.distributed.disaster.LocalPartitionState;
import org.apache.ignite.internal.table.distributed.disaster.LocalPartitionStateByNode;
import org.apache.ignite.internal.table.distributed.disaster.LocalTablePartitionState;
import org.apache.ignite.internal.table.distributed.disaster.LocalTablePartitionStateByNode;
import org.apache.ignite.table.QualifiedName;

@Controller(value="/management/v1/recovery/")
@Requires(classes={IgniteInternalExceptionHandler.class})
public class DisasterRecoveryController
implements DisasterRecoveryApi,
ResourceHolder {
    private DisasterRecoveryManager disasterRecoveryManager;
    private NodeProperties nodeProperties;

    public DisasterRecoveryController(DisasterRecoveryManager disasterRecoveryManager, NodeProperties nodeProperties) {
        this.disasterRecoveryManager = disasterRecoveryManager;
        this.nodeProperties = nodeProperties;
    }

    public CompletableFuture<LocalPartitionStatesResponse> getLocalPartitionStates(Optional<Set<String>> zoneNames, Optional<Set<String>> nodeNames, Optional<Set<Integer>> partitionIds) {
        return this.disasterRecoveryManager.localTablePartitionStates(zoneNames.orElse(Set.of()), nodeNames.orElse(Set.of()), partitionIds.orElse(Set.of())).thenApply(DisasterRecoveryController::convertLocalTableStates);
    }

    public CompletableFuture<GlobalPartitionStatesResponse> getGlobalPartitionStates(Optional<Set<String>> zoneNames, Optional<Set<Integer>> partitionIds) {
        return this.disasterRecoveryManager.globalTablePartitionStates(zoneNames.orElse(Set.of()), partitionIds.orElse(Set.of())).thenApply(DisasterRecoveryController::convertGlobalStates);
    }

    public CompletableFuture<Void> resetPartitions(@Body ResetPartitionsRequest command) {
        if (this.nodeProperties.colocationEnabled()) {
            return this.resetZonePartitions(new ResetZonePartitionsRequest(command.zoneName(), (Collection)command.partitionIds()));
        }
        QualifiedName tableName = QualifiedName.parse((String)command.tableName());
        return this.disasterRecoveryManager.resetTablePartitions(command.zoneName(), tableName.schemaName(), tableName.objectName(), command.partitionIds());
    }

    public CompletableFuture<Void> restartPartitions(@Body RestartPartitionsRequest command) {
        if (this.nodeProperties.colocationEnabled()) {
            return this.restartZonePartitions(new RestartZonePartitionsRequest(command.nodeNames(), command.zoneName(), (Collection)command.partitionIds()));
        }
        QualifiedName tableName = QualifiedName.parse((String)command.tableName());
        return this.disasterRecoveryManager.restartTablePartitions(command.nodeNames(), command.zoneName(), tableName.schemaName(), tableName.objectName(), command.partitionIds());
    }

    public CompletableFuture<Void> restartPartitionsWithCleanup(@Body RestartPartitionsRequest command) {
        if (this.nodeProperties.colocationEnabled()) {
            return this.restartZonePartitionsWithCleanup(new RestartZonePartitionsRequest(command.nodeNames(), command.zoneName(), (Collection)command.partitionIds()));
        }
        QualifiedName tableName = QualifiedName.parse((String)command.tableName());
        return this.disasterRecoveryManager.restartTablePartitionsWithCleanup(command.nodeNames(), command.zoneName(), tableName.schemaName(), tableName.objectName(), command.partitionIds());
    }

    public CompletableFuture<Void> resetZonePartitions(ResetZonePartitionsRequest command) {
        this.checkColocationEnabled();
        return this.disasterRecoveryManager.resetPartitions(command.zoneName(), command.partitionIds());
    }

    public CompletableFuture<Void> restartZonePartitions(RestartZonePartitionsRequest command) {
        this.checkColocationEnabled();
        return this.disasterRecoveryManager.restartPartitions(command.nodeNames(), command.zoneName(), command.partitionIds());
    }

    public CompletableFuture<Void> restartZonePartitionsWithCleanup(RestartZonePartitionsRequest command) {
        this.checkColocationEnabled();
        return this.disasterRecoveryManager.restartPartitionsWithCleanup(command.nodeNames(), command.zoneName(), command.partitionIds());
    }

    public CompletableFuture<LocalZonePartitionStatesResponse> getZoneLocalPartitionStates(Optional<Set<String>> zoneNames, Optional<Set<String>> nodeNames, Optional<Set<Integer>> partitionIds) {
        this.checkColocationEnabled();
        return this.disasterRecoveryManager.localPartitionStates(zoneNames.orElse(Collections.emptySet()), nodeNames.orElse(Collections.emptySet()), partitionIds.orElse(Collections.emptySet())).thenApply(DisasterRecoveryController::convertLocalZoneStates);
    }

    public CompletableFuture<GlobalZonePartitionStatesResponse> getZoneGlobalPartitionStates(Optional<Set<String>> zoneNames, Optional<Set<Integer>> partitionIds) {
        this.checkColocationEnabled();
        return this.disasterRecoveryManager.globalPartitionStates(zoneNames.orElse(Collections.emptySet()), partitionIds.orElse(Collections.emptySet())).thenApply(DisasterRecoveryController::convertGlobalZoneStates);
    }

    private static LocalPartitionStatesResponse convertLocalTableStates(Map<TablePartitionId, LocalTablePartitionStateByNode> localStates) {
        ArrayList<LocalPartitionStateResponse> states = new ArrayList<LocalPartitionStateResponse>();
        for (LocalTablePartitionStateByNode map : localStates.values()) {
            for (Map.Entry entry : map.entrySet()) {
                String nodeName = (String)entry.getKey();
                LocalTablePartitionState state = (LocalTablePartitionState)entry.getValue();
                states.add(new LocalPartitionStateResponse(nodeName, state.zoneName, state.schemaName, state.tableId, state.tableName, state.partitionId, state.state.name(), state.estimatedRows));
            }
        }
        return DisasterRecoveryController.createLocalPartitionStatesResponse(states);
    }

    private static LocalPartitionStatesResponse createLocalPartitionStatesResponse(List<LocalPartitionStateResponse> states) {
        states.sort(Comparator.comparing(LocalPartitionStateResponse::schemaName).thenComparing(LocalPartitionStateResponse::tableName).thenComparingInt(LocalPartitionStateResponse::partitionId).thenComparing(LocalPartitionStateResponse::nodeName));
        return new LocalPartitionStatesResponse(states);
    }

    private static LocalZonePartitionStatesResponse convertLocalZoneStates(Map<ZonePartitionId, LocalPartitionStateByNode> localStates) {
        ArrayList<LocalZonePartitionStateResponse> states = new ArrayList<LocalZonePartitionStateResponse>();
        for (LocalPartitionStateByNode map : localStates.values()) {
            for (Map.Entry entry : map.entrySet()) {
                String nodeName = (String)entry.getKey();
                LocalPartitionState state = (LocalPartitionState)entry.getValue();
                states.add(new LocalZonePartitionStateResponse(nodeName, state.zoneName, state.partitionId, state.state.name(), state.estimatedRows));
            }
        }
        states.sort(Comparator.comparing(LocalZonePartitionStateResponse::partitionId).thenComparing(LocalZonePartitionStateResponse::nodeName));
        return new LocalZonePartitionStatesResponse(states);
    }

    private static GlobalPartitionStatesResponse convertGlobalStates(Map<TablePartitionId, GlobalTablePartitionState> globalStates) {
        ArrayList<GlobalPartitionStateResponse> states = new ArrayList<GlobalPartitionStateResponse>();
        for (GlobalTablePartitionState state : globalStates.values()) {
            states.add(new GlobalPartitionStateResponse(state.zoneName, state.schemaName, state.tableId, state.tableName, state.partitionId, state.state.name()));
        }
        return DisasterRecoveryController.createGlobalPartitionStatesResponse(states);
    }

    private static GlobalPartitionStatesResponse createGlobalPartitionStatesResponse(List<GlobalPartitionStateResponse> states) {
        states.sort(Comparator.comparing(GlobalPartitionStateResponse::schemaName).thenComparing(GlobalPartitionStateResponse::tableName).thenComparingInt(GlobalPartitionStateResponse::partitionId));
        return new GlobalPartitionStatesResponse(states);
    }

    private static GlobalZonePartitionStatesResponse convertGlobalZoneStates(Map<ZonePartitionId, GlobalPartitionState> globalStates) {
        ArrayList<GlobalZonePartitionStateResponse> states = new ArrayList<GlobalZonePartitionStateResponse>();
        for (GlobalPartitionState state : globalStates.values()) {
            states.add(new GlobalZonePartitionStateResponse(state.zoneName, state.partitionId, state.state.name()));
        }
        states.sort(Comparator.comparing(GlobalZonePartitionStateResponse::partitionId));
        return new GlobalZonePartitionStatesResponse(states);
    }

    private void checkColocationEnabled() {
        if (!this.nodeProperties.colocationEnabled()) {
            throw new UnsupportedOperationException("This method is unsupported when colocation is disabled.");
        }
    }

    public void cleanResources() {
        this.disasterRecoveryManager = null;
        this.nodeProperties = null;
    }
}

