/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.notifications;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.configuration.tree.NamedListNode;

class NamedListChanges {
    final Set<String> created;
    final Set<String> deleted;
    final Map<String, String> renamed;
    final Set<String> updated;

    NamedListChanges(Set<String> created, Set<String> deleted, Map<String, String> renamed, Set<String> updated) {
        this.created = created;
        this.deleted = deleted;
        this.renamed = renamed;
        this.updated = updated;
    }

    static NamedListChanges of(NamedListNode<?> oldNamedList, NamedListNode<?> newNamedList) {
        List<String> oldNames = oldNamedList.namedListKeys();
        List<String> newNames = newNamedList.namedListKeys();
        HashSet<String> created = new HashSet<String>(newNames);
        created.removeAll(oldNames);
        HashSet<String> deleted = new HashSet<String>(oldNames);
        deleted.removeAll(newNames);
        HashSet<String> updated = new HashSet<String>(newNames);
        updated.retainAll(oldNames);
        HashMap<String, String> renamed = new HashMap<String, String>();
        if (!created.isEmpty() && !deleted.isEmpty()) {
            HashMap<UUID, String> createdIds = new HashMap<UUID, String>();
            for (String createdKey : created) {
                createdIds.put(newNamedList.internalId(createdKey), createdKey);
            }
            for (String deletedKey : Set.copyOf(deleted)) {
                UUID internalId = oldNamedList.internalId(deletedKey);
                String maybeRenamedKey = (String)createdIds.get(internalId);
                if (maybeRenamedKey == null) continue;
                deleted.remove(deletedKey);
                created.remove(maybeRenamedKey);
                renamed.put(deletedKey, maybeRenamedKey);
            }
        }
        return new NamedListChanges(created, deleted, renamed, updated);
    }
}

