/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.server;

import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.raft.IndexWithTerm;
import org.apache.ignite.internal.raft.Peer;
import org.apache.ignite.internal.raft.PeersAndLearners;
import org.apache.ignite.internal.raft.RaftGroupEventsListener;
import org.apache.ignite.internal.raft.RaftNodeId;
import org.apache.ignite.internal.raft.server.RaftGroupOptions;
import org.apache.ignite.internal.raft.service.RaftGroupListener;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.raft.jraft.option.NodeOptions;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public interface RaftServer
extends IgniteComponent {
    @TestOnly
    public ClusterService clusterService();

    public boolean startRaftNode(RaftNodeId var1, PeersAndLearners var2, RaftGroupListener var3, RaftGroupOptions var4);

    public boolean startRaftNode(RaftNodeId var1, PeersAndLearners var2, RaftGroupEventsListener var3, RaftGroupListener var4, RaftGroupOptions var5);

    public boolean isStarted(RaftNodeId var1);

    public boolean stopRaftNode(RaftNodeId var1);

    public boolean stopRaftNodes(ReplicationGroupId var1);

    public void destroyRaftNodeStorages(RaftNodeId var1, RaftGroupOptions var2);

    public void destroyRaftNodeStoragesDurably(RaftNodeId var1, RaftGroupOptions var2);

    @Nullable
    public IndexWithTerm raftNodeIndex(RaftNodeId var1);

    public List<Peer> localPeers(ReplicationGroupId var1);

    @TestOnly
    public Set<RaftNodeId> localNodes();

    public NodeOptions options();
}

