/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.lowwatermark;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.internal.event.AbstractEventProducer;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.lowwatermark.LowWatermarkCandidate;
import org.apache.ignite.internal.lowwatermark.LowWatermarkLock;
import org.apache.ignite.internal.lowwatermark.ScheduledUpdateLowWatermarkTask;
import org.apache.ignite.internal.lowwatermark.event.ChangeLowWatermarkEventParameters;
import org.apache.ignite.internal.lowwatermark.event.LowWatermarkEvent;
import org.apache.ignite.internal.lowwatermark.event.LowWatermarkEventParameters;
import org.apache.ignite.internal.lowwatermark.message.GetLowWatermarkRequest;
import org.apache.ignite.internal.lowwatermark.message.LowWatermarkMessageGroup;
import org.apache.ignite.internal.lowwatermark.message.LowWatermarkMessagesFactory;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.schema.configuration.LowWatermarkConfiguration;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.vault.VaultEntry;
import org.apache.ignite.internal.vault.VaultManager;
import org.jetbrains.annotations.Nullable;

public class LowWatermarkImpl
extends AbstractEventProducer<LowWatermarkEvent, LowWatermarkEventParameters>
implements LowWatermark,
IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(LowWatermarkImpl.class);
    public static final ByteArray LOW_WATERMARK_VAULT_KEY = new ByteArray("low-watermark");
    private static final LowWatermarkMessagesFactory MESSAGES_FACTORY = new LowWatermarkMessagesFactory();
    private final LowWatermarkConfiguration lowWatermarkConfig;
    private final ClockService clockService;
    private final VaultManager vaultManager;
    private final ScheduledExecutorService scheduledThreadPool;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean closeGuard = new AtomicBoolean();
    @Nullable
    private volatile HybridTimestamp lowWatermark;
    private final AtomicReference<ScheduledFuture<?>> lastScheduledTaskFuture = new AtomicReference();
    private final FailureManager failureManager;
    private final ReadWriteLock updateLowWatermarkLock = new ReentrantReadWriteLock();
    private final MessagingService messagingService;
    private final AtomicReference<LowWatermarkCandidate> lowWatermarkCandidate = new AtomicReference<LowWatermarkCandidate>(new LowWatermarkCandidate(HybridTimestamp.MIN_VALUE, CompletableFutures.nullCompletedFuture()));
    private final Map<UUID, LowWatermarkLock> locks = new ConcurrentHashMap<UUID, LowWatermarkLock>();
    @Nullable
    private ScheduledUpdateLowWatermarkTask lastScheduledUpdateLowWatermarkTask;
    private final Lock scheduleUpdateLowWatermarkTaskLock = new ReentrantLock();

    public LowWatermarkImpl(String nodeName, LowWatermarkConfiguration lowWatermarkConfig, ClockService clockService, VaultManager vaultManager, FailureManager failureManager, MessagingService messagingService) {
        this.lowWatermarkConfig = lowWatermarkConfig;
        this.clockService = clockService;
        this.vaultManager = vaultManager;
        this.failureManager = failureManager;
        this.messagingService = messagingService;
        this.scheduledThreadPool = Executors.newSingleThreadScheduledExecutor((ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"low-watermark-updater", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            this.setLowWatermarkOnRecovery(this.readLowWatermarkFromVault());
            this.messagingService.addMessageHandler(LowWatermarkMessageGroup.class, this::onReceiveNetworkMessage);
            this.lowWatermarkConfig.updateIntervalMillis().listen(ConfigurationListener.fromConsumer(ctx -> this.scheduleUpdates()));
            return CompletableFutures.nullCompletedFuture();
        });
    }

    public void scheduleUpdates() {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, this::scheduleUpdateLowWatermarkBusy);
    }

    @Nullable
    private HybridTimestamp readLowWatermarkFromVault() {
        VaultEntry vaultEntry = this.vaultManager.get(LOW_WATERMARK_VAULT_KEY);
        return vaultEntry == null ? null : HybridTimestamp.fromBytes((byte[])vaultEntry.value());
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.closeGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        ScheduledFuture<?> lastScheduledTaskFuture = this.lastScheduledTaskFuture.get();
        if (lastScheduledTaskFuture != null) {
            lastScheduledTaskFuture.cancel(true);
        }
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.scheduledThreadPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    @Nullable
    public HybridTimestamp getLowWatermark() {
        return (HybridTimestamp)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.lowWatermark);
    }

    @Override
    public void getLowWatermarkSafe(Consumer<@Nullable HybridTimestamp> consumer) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            this.updateLowWatermarkLock.readLock().lock();
            try {
                consumer.accept(this.lowWatermark);
            }
            finally {
                this.updateLowWatermarkLock.readLock().unlock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void scheduleUpdateLowWatermarkBusy() {
        this.scheduleUpdateLowWatermarkTaskLock.lock();
        try {
            ScheduledUpdateLowWatermarkTask lastTask = this.lastScheduledUpdateLowWatermarkTask;
            ScheduledUpdateLowWatermarkTask newTask = new ScheduledUpdateLowWatermarkTask(this, ScheduledUpdateLowWatermarkTask.State.NEW);
            ScheduledUpdateLowWatermarkTask.State lastTaskState = lastTask == null ? ScheduledUpdateLowWatermarkTask.State.COMPLETED : lastTask.state();
            switch (lastTaskState) {
                case NEW: {
                    if (!lastTask.tryCancel()) return;
                    this.lastScheduledUpdateLowWatermarkTask = newTask;
                    this.scheduleUpdateLowWatermarkTaskBusy(newTask);
                    return;
                }
                case IN_PROGRESS: {
                    return;
                }
                case COMPLETED: {
                    this.lastScheduledUpdateLowWatermarkTask = newTask;
                    this.scheduleUpdateLowWatermarkTaskBusy(newTask);
                    return;
                }
                default: {
                    throw new AssertionError((Object)("Unknown state: " + String.valueOf((Object)lastTaskState)));
                }
            }
        }
        finally {
            this.scheduleUpdateLowWatermarkTaskLock.unlock();
        }
    }

    private void scheduleUpdateLowWatermarkTaskBusy(ScheduledUpdateLowWatermarkTask task) {
        ScheduledFuture<?> previousScheduledFuture = this.lastScheduledTaskFuture.get();
        if (previousScheduledFuture != null && !previousScheduledFuture.isDone()) {
            previousScheduledFuture.cancel(true);
        }
        ScheduledFuture<?> newScheduledFuture = this.scheduledThreadPool.schedule(task, (long)((Long)this.lowWatermarkConfig.updateIntervalMillis().value()), TimeUnit.MILLISECONDS);
        boolean casResult = this.lastScheduledTaskFuture.compareAndSet(previousScheduledFuture, newScheduledFuture);
        assert (casResult) : "only one scheduled task is expected";
    }

    HybridTimestamp createNewLowWatermarkCandidate() {
        HybridTimestamp now = this.clockService.now();
        return now.subtractPhysicalTime((Long)this.lowWatermarkConfig.dataAvailabilityTimeMillis().value() + this.clockService.maxClockSkewMillis());
    }

    private void setLowWatermark(HybridTimestamp newLowWatermark) {
        HybridTimestamp lwm = this.lowWatermark;
        assert (lwm == null || newLowWatermark.compareTo(lwm) > 0) : "Low watermark should only grow: [cur=" + String.valueOf(lwm) + ", new=" + String.valueOf(newLowWatermark) + "]";
        this.lowWatermark = newLowWatermark;
    }

    private void setLowWatermarkOnRecovery(@Nullable HybridTimestamp newLowWatermark) {
        this.updateLowWatermarkLock.writeLock().lock();
        try {
            this.lowWatermark = newLowWatermark;
        }
        finally {
            this.updateLowWatermarkLock.writeLock().unlock();
        }
    }

    void onReceiveNetworkMessage(NetworkMessage message, InternalClusterNode sender, @Nullable Long correlationId) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            if (!(message instanceof GetLowWatermarkRequest)) {
                return;
            }
            assert (correlationId != null) : sender;
            this.messagingService.respond(sender, (NetworkMessage)MESSAGES_FACTORY.getLowWatermarkResponse().lowWatermark(HybridTimestamp.hybridTimestampToLong((HybridTimestamp)this.lowWatermark)).build(), correlationId.longValue());
        });
    }

    @Override
    public void updateLowWatermark(HybridTimestamp newLowWatermark) {
        this.updateLowWatermarkAsync(newLowWatermark);
    }

    CompletableFuture<Void> updateLowWatermarkAsync(HybridTimestamp newLowWatermark) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            LowWatermarkCandidate oldLowWatermarkCandidate;
            LowWatermarkCandidate newLowWatermarkCandidate = new LowWatermarkCandidate(newLowWatermark, new CompletableFuture<Void>());
            do {
                if ((oldLowWatermarkCandidate = this.lowWatermarkCandidate.get()).lowWatermark().compareTo(newLowWatermark) < 0) continue;
                return CompletableFutures.nullCompletedFuture();
            } while (!this.lowWatermarkCandidate.compareAndSet(oldLowWatermarkCandidate, newLowWatermarkCandidate));
            return ((CompletableFuture)oldLowWatermarkCandidate.updateFuture().thenComposeAsync(unused -> this.updateAndNotify(newLowWatermark), (Executor)this.scheduledThreadPool)).whenComplete((unused, throwable) -> {
                if (throwable != null) {
                    newLowWatermarkCandidate.updateFuture().completeExceptionally((Throwable)throwable);
                } else {
                    newLowWatermarkCandidate.updateFuture().complete(null);
                }
            });
        });
    }

    @Override
    public boolean tryLock(UUID lockId, HybridTimestamp ts) {
        return (Boolean)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            this.updateLowWatermarkLock.readLock().lock();
            try {
                HybridTimestamp lwm = this.lowWatermark;
                if (lwm != null && ts.compareTo(lwm) < 0) {
                    Boolean bl = false;
                    return bl;
                }
                this.locks.put(lockId, new LowWatermarkLock(ts));
                Boolean bl = true;
                return bl;
            }
            finally {
                this.updateLowWatermarkLock.readLock().unlock();
            }
        });
    }

    @Override
    public void unlock(UUID lockId) {
        LowWatermarkLock lock = this.locks.remove(lockId);
        if (lock == null) {
            return;
        }
        lock.future().complete(null);
    }

    CompletableFuture<Void> updateAndNotify(HybridTimestamp newLowWatermark) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            this.vaultManager.put(LOW_WATERMARK_VAULT_KEY, newLowWatermark.toBytes());
            return ((CompletableFuture)this.waitForLocksAndSetLowWatermark(newLowWatermark).thenComposeAsync(unused2 -> this.fireEvent(LowWatermarkEvent.LOW_WATERMARK_CHANGED, new ChangeLowWatermarkEventParameters(newLowWatermark)), (Executor)this.scheduledThreadPool)).whenCompleteAsync((unused, throwable) -> {
                if (throwable != null) {
                    if (!ExceptionUtils.hasCause((Throwable)throwable, (Class[])new Class[]{NodeStoppingException.class})) {
                        LOG.error("Failed to update low watermark: {}", throwable, new Object[]{newLowWatermark});
                        this.failureManager.process(new FailureContext(FailureType.CRITICAL_ERROR, throwable));
                    }
                } else {
                    LOG.info("Successful low watermark update: {}", new Object[]{newLowWatermark});
                }
            }, (Executor)this.scheduledThreadPool);
        });
    }

    private CompletableFuture<Void> waitForLocksAndSetLowWatermark(HybridTimestamp newLowWatermark) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            this.updateLowWatermarkLock.writeLock().lock();
            try {
                for (LowWatermarkLock lock : this.locks.values()) {
                    if (lock.timestamp().compareTo(newLowWatermark) >= 0) continue;
                    CompletionStage completionStage = lock.future().thenCompose(unused -> this.waitForLocksAndSetLowWatermark(newLowWatermark));
                    return completionStage;
                }
                this.setLowWatermark(newLowWatermark);
                CompletableFuture completableFuture = CompletableFutures.nullCompletedFuture();
                return completableFuture;
            }
            finally {
                this.updateLowWatermarkLock.writeLock().unlock();
            }
        });
    }
}

