/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Nullable;

public class RaftGroupConfigurationSerializer
extends VersionedSerializer<RaftGroupConfiguration> {
    public static final RaftGroupConfigurationSerializer INSTANCE = new RaftGroupConfigurationSerializer();

    protected byte getProtocolVersion() {
        return 2;
    }

    protected void writeExternalData(RaftGroupConfiguration config, IgniteDataOutput out) throws IOException {
        out.writeLong(config.index());
        out.writeLong(config.term());
        RaftGroupConfigurationSerializer.writeStringList(config.peers(), out);
        RaftGroupConfigurationSerializer.writeStringList(config.learners(), out);
        RaftGroupConfigurationSerializer.writeNullableStringList(config.oldPeers(), out);
        RaftGroupConfigurationSerializer.writeNullableStringList(config.oldLearners(), out);
    }

    private static void writeStringList(List<String> strings, IgniteDataOutput out) throws IOException {
        out.writeVarInt((long)strings.size());
        for (String str : strings) {
            out.writeUTF(str);
        }
    }

    private static void writeNullableStringList(@Nullable List<String> strings, IgniteDataOutput out) throws IOException {
        if (strings == null) {
            out.writeVarInt(-1L);
        } else {
            RaftGroupConfigurationSerializer.writeStringList(strings, out);
        }
    }

    protected RaftGroupConfiguration readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        long term;
        long index;
        if (protoVer >= 2) {
            index = in.readLong();
            term = in.readLong();
        } else {
            index = -1L;
            term = -1L;
        }
        List<String> peers = RaftGroupConfigurationSerializer.readStringList(in);
        List<String> learners = RaftGroupConfigurationSerializer.readStringList(in);
        List<String> oldPeers = RaftGroupConfigurationSerializer.readNullableStringList(in);
        List<String> oldLearners = RaftGroupConfigurationSerializer.readNullableStringList(in);
        return new RaftGroupConfiguration(index, term, peers, learners, oldPeers, oldLearners);
    }

    private static List<String> readStringList(IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        return RaftGroupConfigurationSerializer.readStringList(length, in);
    }

    private static List<String> readStringList(int length, IgniteDataInput in) throws IOException {
        assert (length >= 0) : "Invalid length: " + length;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            list.add(in.readUTF());
        }
        return list;
    }

    @Nullable
    private static List<String> readNullableStringList(IgniteDataInput in) throws IOException {
        int lengthOrMinusOne = in.readVarIntAsInt();
        if (lengthOrMinusOne == -1) {
            return null;
        }
        return RaftGroupConfigurationSerializer.readStringList(lengthOrMinusOne, in);
    }
}

