/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.loader;

import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.compute.loader.JobClassLoaderImpl;
import org.apache.ignite.internal.compute.loader.JobClasspath;
import org.apache.ignite.internal.deployunit.DisposableDeploymentUnit;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;

public class JobClassLoader
implements AutoCloseable {
    private static final IgniteLogger LOG = Loggers.forClass(JobClassLoader.class);
    private final List<DisposableDeploymentUnit> units;
    private final ClassLoader parent;
    private volatile JobClassLoaderImpl impl;

    public JobClassLoader(List<DisposableDeploymentUnit> units, ClassLoader parent) {
        this.units = units;
        this.parent = parent;
    }

    public List<DisposableDeploymentUnit> units() {
        return this.units;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader classLoader() {
        if (this.impl == null) {
            JobClassLoader jobClassLoader = this;
            synchronized (jobClassLoader) {
                if (this.impl == null) {
                    this.impl = this.createClassLoader();
                }
            }
        }
        return this.impl;
    }

    private JobClassLoaderImpl createClassLoader() {
        return AccessController.doPrivileged(() -> {
            Object[] classpath = (URL[])this.units.stream().map(DisposableDeploymentUnit::path).flatMap(JobClasspath::collectClasspath).toArray(URL[]::new);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created class loader with classpath: {}", new Object[]{Arrays.toString(classpath)});
            }
            return new JobClassLoaderImpl(this.units, (URL[])classpath, this.parent);
        });
    }

    @Override
    public void close() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (DisposableDeploymentUnit unit : this.units) {
            try {
                unit.release();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        try {
            JobClassLoaderImpl impl0 = this.impl;
            if (impl0 != null) {
                impl0.close();
            }
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            IgniteException igniteException = new IgniteException(ErrorGroups.Compute.CLASS_LOADER_ERR, "Failed to close class loader");
            for (Exception exception : exceptions) {
                igniteException.addSuppressed((Throwable)exception);
            }
            throw igniteException;
        }
    }
}

