/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.tree;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongArrays;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.lang.IgniteTuple3;
import org.apache.ignite.internal.pagememory.CorruptedDataStructureException;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.datastructure.DataStructure;
import org.apache.ignite.internal.pagememory.io.IoVersions;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.reuse.LongListReuseBag;
import org.apache.ignite.internal.pagememory.reuse.ReuseBag;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.tree.BplusTreeRuntimeException;
import org.apache.ignite.internal.pagememory.tree.CorruptedTreeException;
import org.apache.ignite.internal.pagememory.tree.IgniteTree;
import org.apache.ignite.internal.pagememory.tree.IgniteTreePrinter;
import org.apache.ignite.internal.pagememory.tree.io.BplusInnerIo;
import org.apache.ignite.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite.internal.pagememory.tree.io.BplusLeafIo;
import org.apache.ignite.internal.pagememory.tree.io.BplusMetaIo;
import org.apache.ignite.internal.pagememory.util.GradualTask;
import org.apache.ignite.internal.pagememory.util.PageHandler;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.FastTimestamps;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

public abstract class BplusTree<L, T extends L>
extends DataStructure
implements IgniteTree<L, T> {
    private static final String CONC_DESTROY_MSG = "Tree is being concurrently destroyed: ";
    private static final String IGNITE_BPLUS_TREE_LOCK_RETRIES = "IGNITE_BPLUS_TREE_LOCK_RETRIES";
    private static final int LOCK_RETRIES = IgniteSystemProperties.getInteger((String)"IGNITE_BPLUS_TREE_LOCK_RETRIES", (int)1000);
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final float minFill;
    private final float maxFill;
    protected final long metaPageId;
    private boolean canGetRowFromInner;
    private IoVersions<? extends BplusInnerIo<L>> innerIos;
    private IoVersions<? extends BplusLeafIo<L>> leafIos;
    private IoVersions<? extends BplusMetaIo> metaIos;
    private final AtomicLong globalRmvId;
    private volatile TreeMetaData treeMeta;
    private boolean sequentialWriteOptsEnabled;
    private final IgniteTreePrinter<Long> treePrinter = new IgniteTreePrinter<Long>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        @Override
        protected List<Long> getChildren(Long pageId) {
            if (pageId == null || pageId == 0L) {
                return null;
            }
            try {
                long page = BplusTree.this.acquirePage(pageId);
                try {
                    ArrayList<Long> arrayList;
                    BplusIo io;
                    long pageAddr;
                    block17: {
                        pageAddr = BplusTree.this.readLock(pageId, page);
                        if (pageAddr == 0L) {
                            List<Long> list = null;
                            return list;
                        }
                        io = BplusTree.this.io(pageAddr);
                        if (!io.isLeaf()) break block17;
                        List<Long> list = Collections.emptyList();
                        BplusTree.this.readUnlock(pageId, page, pageAddr);
                        return list;
                    }
                    try {
                        ArrayList<Long> res;
                        int cnt = io.getCount(pageAddr);
                        assert (cnt >= 0) : cnt;
                        if (cnt > 0) {
                            res = new ArrayList<Long>(cnt + 1);
                            for (int i = 0; i < cnt; ++i) {
                                res.add(BplusTree.inner(io).getLeft(pageAddr, i, BplusTree.this.partId));
                            }
                            res.add(BplusTree.inner(io).getRight(pageAddr, cnt - 1, BplusTree.this.partId));
                        } else {
                            long left = BplusTree.inner(io).getLeft(pageAddr, 0, BplusTree.this.partId);
                            res = left == 0L ? Collections.emptyList() : Collections.singletonList(left);
                        }
                        arrayList = res;
                    }
                    catch (Throwable throwable) {
                        BplusTree.this.readUnlock(pageId, page, pageAddr);
                        throw throwable;
                    }
                    BplusTree.this.readUnlock(pageId, page, pageAddr);
                    return arrayList;
                }
                finally {
                    BplusTree.this.releasePage(pageId, page);
                }
            }
            catch (IgniteInternalCheckedException ignored) {
                throw new AssertionError((Object)"Can not acquire page.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        @Override
        protected String formatTreeNode(Long pageId) {
            if (pageId == null) {
                return ">NPE<";
            }
            if (pageId == 0L) {
                return "<Zero>";
            }
            try {
                long page = BplusTree.this.acquirePage(pageId);
                try {
                    String string;
                    long pageAddr = BplusTree.this.readLock(pageId, page);
                    if (pageAddr == 0L) {
                        String string2 = "<Obsolete>";
                        return string2;
                    }
                    try {
                        BplusIo io = BplusTree.this.io(pageAddr);
                        string = BplusTree.this.printPage(io, pageAddr, true);
                    }
                    catch (Throwable throwable) {
                        BplusTree.this.readUnlock(pageId, page, pageAddr);
                        throw throwable;
                    }
                    BplusTree.this.readUnlock(pageId, page, pageAddr);
                    return string;
                }
                finally {
                    BplusTree.this.releasePage(pageId, page);
                }
            }
            catch (IgniteInternalCheckedException e) {
                throw new IllegalStateException(e);
            }
        }
    };
    private final PageHandler<Get, Result> askNeighbor;
    private final PageHandler<Get, Result> search;
    private final PageHandler<Put, Result> replace;
    private final PageHandler<Put, Result> insert;
    private final PageHandler<Remove, Result> rmvFromLeaf;
    private final PageHandler<Remove, Result> lockBackAndRmvFromLeaf;
    private final PageHandler<Remove, Result> lockBackAndTail;
    private final PageHandler<Remove, Result> lockTailForward;
    private final PageHandler<Update, Result> lockTailExact;
    private final PageHandler<Remove, Result> lockTail;
    private final PageHandler<Void, Bool> cutRoot = new CutRoot();
    private final PageHandler<Long, Bool> addRoot = new AddRoot();
    private final PageHandler<Long, Bool> initRoot = new InitRoot();

    protected BplusTree(String treeNamePrefix, int grpId, @Nullable String grpName, int partId, PageMemory pageMem, AtomicLong globalRmvId, long metaPageId, @Nullable ReuseList reuseList, IoVersions<? extends BplusInnerIo<L>> innerIos, IoVersions<? extends BplusLeafIo<L>> leafIos, IoVersions<? extends BplusMetaIo> metaIos) {
        this(treeNamePrefix, grpId, grpName, partId, pageMem, globalRmvId, metaPageId, reuseList);
        this.setIos(innerIos, leafIos, metaIos);
    }

    protected BplusTree(String treeNamePrefix, int grpId, @Nullable String grpName, int partId, PageMemory pageMem, AtomicLong globalRmvId, long metaPageId, @Nullable ReuseList reuseList) {
        super(treeNamePrefix, grpId, grpName, partId, pageMem, (byte)2);
        this.minFill = 0.0f;
        this.maxFill = 0.0f;
        assert (metaPageId != 0L);
        this.metaPageId = metaPageId;
        this.reuseList = reuseList;
        this.globalRmvId = globalRmvId;
        this.askNeighbor = new AskNeighbor();
        this.search = new Search();
        this.lockTailExact = new LockTailExact();
        this.lockTail = new LockTail();
        this.lockTailForward = new LockTailForward();
        this.lockBackAndTail = new LockBackAndTail();
        this.lockBackAndRmvFromLeaf = new LockBackAndRmvFromLeaf();
        this.rmvFromLeaf = new RemoveFromLeaf();
        this.insert = new Insert();
        this.replace = new Replace();
    }

    public void setIos(IoVersions<? extends BplusInnerIo<L>> innerIos, IoVersions<? extends BplusLeafIo<L>> leafIos, IoVersions<? extends BplusMetaIo> metaIos) {
        this.canGetRowFromInner = innerIos.latest().canGetRow();
        this.innerIos = innerIos;
        this.leafIos = leafIos;
        this.metaIos = metaIos;
    }

    public void enableSequentialWriteMode() {
        this.sequentialWriteOptsEnabled = true;
    }

    protected final void initTree(boolean initNew) throws IgniteInternalCheckedException {
        if (initNew) {
            long rootId = this.allocatePage(null);
            this.init(rootId, this.latestLeafIo());
            Bool res = this.write(this.metaPageId, this.initRoot, this.latestMetaIo(), Long.valueOf(rootId), 0, Bool.FALSE);
            assert (res == Bool.TRUE) : res;
            assert (this.treeMeta != null);
        }
    }

    private TreeMetaData treeMeta() throws IgniteInternalCheckedException {
        return this.treeMeta(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeMetaData treeMeta(long metaPageAddr) throws IgniteInternalCheckedException {
        TreeMetaData meta0 = this.treeMeta;
        if (meta0 != null) {
            return meta0;
        }
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            long pageAddr;
            if (metaPageAddr == 0L) {
                pageAddr = this.readLock(this.metaPageId, metaPage);
                assert (pageAddr != 0L) : "Failed to read lock meta page [metaPageId=" + StringUtils.hexLong((long)this.metaPageId) + "]";
            } else {
                pageAddr = metaPageAddr;
            }
            try {
                BplusMetaIo io = this.metaIos.forPage(pageAddr);
                int rootLvl = io.getRootLevel(pageAddr);
                long rootId = io.getFirstPageId(pageAddr, rootLvl, this.partId);
                this.treeMeta = meta0 = new TreeMetaData(rootLvl, rootId);
            }
            finally {
                if (metaPageAddr == 0L) {
                    this.readUnlock(this.metaPageId, metaPage, pageAddr);
                }
            }
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
        return meta0;
    }

    private int getRootLevel() throws IgniteInternalCheckedException {
        return this.getRootLevel(0L);
    }

    private int getRootLevel(long metaPageAddr) throws IgniteInternalCheckedException {
        TreeMetaData meta0 = this.treeMeta(metaPageAddr);
        assert (meta0 != null);
        return meta0.rootLvl;
    }

    private long getFirstPageId(long metaId, long metaPage, int lvl) {
        return this.getFirstPageId(metaId, metaPage, lvl, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getFirstPageId(long metaId, long metaPage, int lvl, long metaPageAddr) {
        long pageAddr = metaPageAddr != 0L ? metaPageAddr : this.readLock(metaId, metaPage);
        try {
            BplusMetaIo io = this.metaIos.forPage(pageAddr);
            if (lvl < 0) {
                lvl = io.getRootLevel(pageAddr);
            }
            if (lvl >= io.getLevelsCount(pageAddr)) {
                long l = 0L;
                return l;
            }
            long l = io.getFirstPageId(pageAddr, lvl, this.partId);
            return l;
        }
        finally {
            if (metaPageAddr == 0L) {
                this.readUnlock(metaId, metaPage, pageAddr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> Cursor<R> findLowerUnbounded(@Nullable L upper, boolean upIncl, @Nullable TreeRowMapClosure<L, T, R> c, @Nullable Object x) throws IgniteInternalCheckedException {
        long firstPageId;
        ForwardCursor<R> cursor = new ForwardCursor<R>(upper, upIncl, c, x);
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            firstPageId = this.getFirstPageId(this.metaPageId, metaPage, 0);
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
        try {
            long firstPage = this.acquirePage(firstPageId);
            try {
                long pageAddr = this.readLock(firstPageId, firstPage);
                try {
                    cursor.init(pageAddr, this.io(pageAddr), -1);
                }
                finally {
                    this.readUnlock(firstPageId, firstPage, pageAddr);
                }
            }
            finally {
                this.releasePage(firstPageId, firstPage);
            }
        }
        catch (AssertionError | RuntimeException e) {
            throw new BplusTreeRuntimeException((Throwable)e, this.grpId, this.metaPageId, firstPageId);
        }
        return cursor;
    }

    protected final void checkDestroyed() throws IgniteInternalCheckedException {
        if (this.destroyed.get()) {
            throw new IgniteInternalCheckedException(CONC_DESTROY_MSG + this.name());
        }
    }

    @Override
    public final Cursor<T> find(@Nullable L lower, @Nullable L upper) throws IgniteInternalCheckedException {
        return this.find(lower, upper, null);
    }

    @Override
    public final Cursor<T> find(@Nullable L lower, @Nullable L upper, @Nullable Object x) throws IgniteInternalCheckedException {
        return this.find(lower, upper, null, x);
    }

    public <R> Cursor<R> find(@Nullable L lower, @Nullable L upper, @Nullable TreeRowMapClosure<L, T, R> c, @Nullable Object x) throws IgniteInternalCheckedException {
        return this.find(lower, upper, true, true, c, x);
    }

    public <R> Cursor<R> find(@Nullable L lower, @Nullable L upper, boolean lowIncl, boolean upIncl, @Nullable TreeRowMapClosure<L, T, R> c, @Nullable Object x) throws IgniteInternalCheckedException {
        this.checkDestroyed();
        ForwardCursor<R> cursor = new ForwardCursor<R>(lower, upper, lowIncl, upIncl, c, x);
        try {
            if (lower == null) {
                Cursor<R> cursor2 = this.findLowerUnbounded(upper, upIncl, c, x);
                return cursor2;
            }
            cursor.find();
            ForwardCursor<R> forwardCursor = cursor;
            return forwardCursor;
        }
        catch (CorruptedDataStructureException e) {
            throw e;
        }
        catch (IgniteInternalCheckedException e) {
            throw new IgniteInternalCheckedException("Runtime failure on bounds: [lower=" + String.valueOf(lower) + ", upper=" + String.valueOf(upper) + "]", (Throwable)e);
        }
        catch (AssertionError | RuntimeException e) {
            long[] pageIds = BplusTree.pages(lower == null || cursor.getCursor == null, () -> new long[]{cursor.getCursor.pageId});
            throw this.corruptedTreeException("Runtime failure on bounds: [lower=" + String.valueOf(lower) + ", upper=" + String.valueOf(upper) + "]", (Throwable)e, this.grpId, pageIds);
        }
        finally {
            this.checkDestroyed();
        }
    }

    public void iterate(L lower, L upper, TreeRowClosure<L, T> c) throws IgniteInternalCheckedException {
        this.checkDestroyed();
        ClosureCursor cursor = new ClosureCursor(lower, upper, c);
        try {
            cursor.iterate();
        }
        catch (CorruptedDataStructureException e) {
            throw e;
        }
        catch (IgniteInternalCheckedException e) {
            throw new IgniteInternalCheckedException("Runtime failure on bounds: [lower=" + String.valueOf(lower) + ", upper=" + String.valueOf(upper) + "]", (Throwable)e);
        }
        catch (AssertionError | RuntimeException e) {
            throw this.corruptedTreeException("Runtime failure on bounds: [lower=" + String.valueOf(lower) + ", upper=" + String.valueOf(upper) + "]", (Throwable)e, this.grpId, BplusTree.pages(cursor.getCursor != null, () -> new long[]{cursor.getCursor.pageId}));
        }
        finally {
            this.checkDestroyed();
        }
    }

    public void visit(L lower, L upper, TreeVisitorClosure<L, T> c) throws IgniteInternalCheckedException {
        this.checkDestroyed();
        try {
            new TreeVisitor(lower, upper, c).visit();
        }
        catch (IgniteInternalCheckedException e) {
            throw new IgniteInternalCheckedException("Runtime failure on bounds: [lower=" + String.valueOf(lower) + ", upper=" + String.valueOf(upper) + "]", (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new IgniteInternalException("Runtime failure on bounds: [lower=" + String.valueOf(lower) + ", upper=" + String.valueOf(upper) + "]", (Throwable)e);
        }
        catch (AssertionError e) {
            throw new AssertionError("Assertion error on bounds: [lower=" + String.valueOf(lower) + ", upper=" + String.valueOf(upper) + "]", (Throwable)((Object)e));
        }
        finally {
            this.checkDestroyed();
        }
    }

    @Override
    public T findFirst() throws IgniteInternalCheckedException {
        return this.findFirst(null);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public T findFirst(@Nullable TreeRowClosure<L, T> filter) throws IgniteInternalCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 29[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public T findLast() throws IgniteInternalCheckedException {
        return this.findLast(null);
    }

    @Nullable
    public T findLast(@Nullable TreeRowClosure<L, T> c) throws IgniteInternalCheckedException {
        this.checkDestroyed();
        Get g = null;
        try {
            GetLast getLast;
            if (c == null) {
                GetOne getOne = new GetOne(null, null, null, true);
                g = getOne;
                this.doFind(g);
                Object r = getOne.res;
                return (T)r;
            }
            g = getLast = new GetLast(c);
            Object t = getLast.find();
            return t;
        }
        catch (CorruptedDataStructureException e) {
            throw e;
        }
        catch (IgniteInternalCheckedException e) {
            throw new IgniteInternalCheckedException("Runtime failure on last row lookup", (Throwable)e);
        }
        catch (AssertionError | RuntimeException e) {
            GetLast g0 = g;
            long[] pageIds = BplusTree.pages(g == null, () -> new long[]{g0.pageId});
            throw this.corruptedTreeException("Runtime failure on last row lookup", (Throwable)e, this.grpId, pageIds);
        }
        finally {
            this.checkDestroyed();
        }
    }

    @Nullable
    public final <R> R findOne(L row, @Nullable Object x) throws IgniteInternalCheckedException {
        return this.findOne(row, null, x);
    }

    @Nullable
    public final <R> R findOne(L row, @Nullable TreeRowMapClosure<L, T, R> c, @Nullable Object x) throws IgniteInternalCheckedException {
        this.checkDestroyed();
        GetOne<R> g = new GetOne<R>(row, c, x, false);
        try {
            this.doFind(g);
            Object r = g.res;
            return r;
        }
        catch (CorruptedDataStructureException e) {
            throw e;
        }
        catch (IgniteInternalCheckedException e) {
            throw new IgniteInternalCheckedException("Runtime failure on lookup row: " + String.valueOf(row), (Throwable)e);
        }
        catch (AssertionError | RuntimeException e) {
            throw this.corruptedTreeException("Runtime failure on lookup row: " + String.valueOf(row), (Throwable)e, this.grpId, g.pageId);
        }
        finally {
            this.checkDestroyed();
        }
    }

    @Override
    public final T findOne(L row) throws IgniteInternalCheckedException {
        return (T)this.findOne(row, null, null);
    }

    @Nullable
    public final T findNext(L lowerBound, boolean includeRow) throws IgniteInternalCheckedException {
        this.checkDestroyed();
        GetNext g = new GetNext(lowerBound, includeRow);
        try {
            this.doFind(g);
            Object t = g.nextRow;
            return t;
        }
        catch (CorruptedDataStructureException e) {
            throw e;
        }
        catch (IgniteInternalCheckedException e) {
            throw new IgniteInternalCheckedException("Runtime failure on lookup next row: " + String.valueOf(lowerBound), (Throwable)e);
        }
        catch (AssertionError | RuntimeException e) {
            throw this.corruptedTreeException("Runtime failure on lookup next row: " + String.valueOf(lowerBound), (Throwable)e, this.grpId, g.pageId);
        }
        finally {
            this.checkDestroyed();
        }
    }

    private void doFind(Get g) throws IgniteInternalCheckedException {
        assert (!this.sequentialWriteOptsEnabled);
        block3: while (true) {
            g.init();
            switch (this.findDown(g, g.rootId, 0L, g.rootLvl).ordinal()) {
                case 4: 
                case 5: {
                    continue block3;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result findDown(Get g, long pageId, long fwdId, int lvl) throws IgniteInternalCheckedException {
        long page = this.acquirePage(pageId);
        try {
            Result res;
            block9: while (true) {
                g.checkLockRetry();
                g.pageId = pageId;
                g.fwdId = fwdId;
                res = this.read(pageId, page, this.search, g, lvl, Result.RETRY);
                switch (res.ordinal()) {
                    case 0: 
                    case 1: {
                        assert (g.pageId != pageId);
                        assert (g.fwdId != fwdId || fwdId == 0L);
                        if ((res = this.findDown(g, g.pageId, g.fwdId, lvl - 1)) == Result.RETRY) continue block9;
                        Result result = res;
                        return result;
                    }
                    case 3: {
                        assert (lvl == 0) : lvl;
                        g.row = null;
                        Result result = res;
                        return result;
                    }
                }
                break;
            }
            Result result = res;
            return result;
        }
        finally {
            if (g.canRelease(pageId, lvl)) {
                this.releasePage(pageId, page);
            }
        }
    }

    public static String treeName(String instance, String type) {
        return instance + "##" + type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String printTree() throws IgniteInternalCheckedException {
        long rootPageId;
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            rootPageId = this.getFirstPageId(this.metaPageId, metaPage, -1);
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
        return this.treePrinter.print(rootPageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void validateTree() throws IgniteInternalCheckedException {
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            int rootLvl = this.getRootLevel();
            if (rootLvl < 0) {
                BplusTree.fail("Root level: " + rootLvl);
            }
            this.validateFirstPages(this.metaPageId, metaPage, rootLvl);
            long rootPageId = this.getFirstPageId(this.metaPageId, metaPage, rootLvl);
            this.validateDownPages(rootPageId, 0L, rootLvl);
            this.validateDownKeys(rootPageId, null, rootLvl);
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateDownKeys(long pageId, @Nullable L minRow, int lvl) throws IgniteInternalCheckedException {
        long page = this.acquirePage(pageId);
        try {
            long pageAddr = this.readLock(pageId, page);
            try {
                BplusIo<L> io = this.io(pageAddr);
                int cnt = io.getCount(pageAddr);
                if (cnt < 0) {
                    BplusTree.fail("Negative count: " + cnt);
                }
                if (io.isLeaf()) {
                    for (int i = 0; i < cnt; ++i) {
                        if (minRow != null && this.compare(lvl, io, pageAddr, i, minRow) <= 0) {
                            BplusTree.fail("Wrong sort order: " + StringUtils.hexLong((long)pageId) + " , at " + i + " , minRow: " + String.valueOf(minRow));
                        }
                        minRow = io.getLookupRow(this, pageAddr, i);
                    }
                    return;
                }
                for (int i = 0; i < cnt; ++i) {
                    long leftId;
                    L leafRow;
                    int cmp;
                    L row = io.getLookupRow(this, pageAddr, i);
                    if (minRow != null && this.compare(lvl, io, pageAddr, i, minRow) <= 0) {
                        BplusTree.fail("Min row violated: " + String.valueOf(row) + " , minRow: " + String.valueOf(minRow));
                    }
                    if ((cmp = this.compare(lvl, io, pageAddr, i, leafRow = this.getGreatestRowInSubTree(leftId = BplusTree.inner(io).getLeft(pageAddr, i, this.partId)))) < 0 || cmp != 0 && this.canGetRowFromInner) {
                        BplusTree.fail("Wrong inner row: " + StringUtils.hexLong((long)pageId) + " , at: " + i + " , leaf:  " + String.valueOf(leafRow) + " , inner: " + String.valueOf(row));
                    }
                    this.validateDownKeys(leftId, minRow, lvl - 1);
                    minRow = row;
                }
                long rightId = BplusTree.inner(io).getLeft(pageAddr, cnt, this.partId);
                this.validateDownKeys(rightId, minRow, lvl - 1);
            }
            finally {
                this.readUnlock(pageId, page, pageAddr);
            }
        }
        finally {
            this.releasePage(pageId, page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private L getGreatestRowInSubTree(long pageId) throws IgniteInternalCheckedException {
        long page = this.acquirePage(pageId);
        try {
            int cnt;
            BplusIo<L> io;
            long pageAddr;
            block9: {
                L l;
                pageAddr = this.readLock(pageId, page);
                try {
                    io = this.io(pageAddr);
                    cnt = io.getCount(pageAddr);
                    if (!io.isLeaf()) break block9;
                    if (cnt <= 0) {
                        BplusTree.fail("Invalid leaf count: " + cnt + " " + StringUtils.hexLong((long)pageId));
                    }
                    l = io.getLookupRow(this, pageAddr, cnt - 1);
                }
                catch (Throwable throwable) {
                    this.readUnlock(pageId, page, pageAddr);
                    throw throwable;
                }
                this.readUnlock(pageId, page, pageAddr);
                return l;
            }
            long rightId = BplusTree.inner(io).getLeft(pageAddr, cnt, this.partId);
            L l = this.getGreatestRowInSubTree(rightId);
            this.readUnlock(pageId, page, pageAddr);
            return l;
        }
        finally {
            this.releasePage(pageId, page);
        }
    }

    private void validateFirstPages(long metaId, long metaPage, int rootLvl) throws IgniteInternalCheckedException {
        for (int lvl = rootLvl; lvl > 0; --lvl) {
            this.validateFirstPage(metaId, metaPage, lvl);
        }
    }

    private static void fail(Object msg) {
        throw new AssertionError(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateFirstPage(long metaId, long metaPage, int lvl) throws IgniteInternalCheckedException {
        long leftmostChildId;
        if (lvl == 0) {
            BplusTree.fail("Leaf level: " + lvl);
        }
        long pageId = this.getFirstPageId(metaId, metaPage, lvl);
        long page = this.acquirePage(pageId);
        try {
            long pageAddr = this.readLock(pageId, page);
            try {
                BplusIo<L> io = this.io(pageAddr);
                if (io.isLeaf()) {
                    BplusTree.fail("Leaf.");
                }
                leftmostChildId = BplusTree.inner(io).getLeft(pageAddr, 0, this.partId);
            }
            finally {
                this.readUnlock(pageId, page, pageAddr);
            }
        }
        finally {
            this.releasePage(pageId, page);
        }
        long firstDownPageId = this.getFirstPageId(metaId, metaPage, lvl - 1);
        if (firstDownPageId != leftmostChildId) {
            BplusTree.fail(new IgniteStringBuilder("First: meta ").appendHex(firstDownPageId).app(", child ").appendHex(leftmostChildId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateDownPages(long pageId, long fwdId, int lvl) throws IgniteInternalCheckedException {
        block21: {
            long page = this.acquirePage(pageId);
            try {
                long pageAddr = this.readLock(pageId, page);
                try {
                    int cnt;
                    long actualFwdId;
                    BplusIo<L> io;
                    long realPageId = BplusIo.getPageId(pageAddr);
                    if (realPageId != pageId) {
                        BplusTree.fail(new IgniteStringBuilder("ABA on page ID: ref ").appendHex(pageId).app(", buf ").appendHex(realPageId));
                    }
                    if ((io = this.io(pageAddr)).isLeaf() != (lvl == 0)) {
                        BplusTree.fail("Leaf level mismatch: " + lvl);
                    }
                    if ((actualFwdId = io.getForward(pageAddr, this.partId)) != fwdId) {
                        BplusTree.fail(new IgniteStringBuilder("Triangle: expected fwd ").appendHex(fwdId).app(", actual fwd ").appendHex(actualFwdId));
                    }
                    if ((cnt = io.getCount(pageAddr)) < 0) {
                        BplusTree.fail("Negative count: " + cnt);
                    }
                    if (io.isLeaf()) {
                        if (cnt == 0 && this.getRootLevel() != 0) {
                            BplusTree.fail("Empty leaf page.");
                        }
                        break block21;
                    }
                    for (int i = 0; i < cnt; ++i) {
                        this.validateDownPages(BplusTree.inner(io).getLeft(pageAddr, i, this.partId), BplusTree.inner(io).getRight(pageAddr, i, this.partId), lvl - 1);
                    }
                    if (fwdId != 0L) {
                        long fwdId0 = fwdId;
                        long fwdPage = this.acquirePage(fwdId0);
                        try {
                            long fwdPageAddr = this.readLock(fwdId0, fwdPage);
                            try {
                                if (this.io(fwdPageAddr) != io) {
                                    BplusTree.fail("IO on the same level must be the same");
                                }
                                fwdId = BplusTree.inner(io).getLeft(fwdPageAddr, 0, this.partId);
                            }
                            finally {
                                this.readUnlock(fwdId0, fwdPage, fwdPageAddr);
                            }
                        }
                        finally {
                            this.releasePage(fwdId0, fwdPage);
                        }
                    }
                    long leftId = BplusTree.inner(io).getLeft(pageAddr, cnt, this.partId);
                    this.validateDownPages(leftId, fwdId, lvl - 1);
                }
                finally {
                    this.readUnlock(pageId, page, pageAddr);
                }
            }
            finally {
                this.releasePage(pageId, page);
            }
        }
    }

    private String printPage(BplusIo<L> io, long pageAddr, boolean keys) throws IgniteInternalCheckedException {
        StringBuilder b = new StringBuilder();
        b.append(BplusTree.formatPageId(PageIo.getPageId(pageAddr))).append(" [ ").append(io.isLeaf() ? "L " : "I ");
        int cnt = io.getCount(pageAddr);
        long fwdId = io.getForward(pageAddr, this.partId);
        b.append("cnt=").append(cnt).append(' ').append("fwd=").append(BplusTree.formatPageId(fwdId)).append(' ');
        if (!io.isLeaf()) {
            b.append("lm=").append(BplusTree.formatPageId(BplusTree.inner(io).getLeft(pageAddr, 0, this.partId))).append(' ');
            if (cnt > 0) {
                b.append("rm=").append(BplusTree.formatPageId(BplusTree.inner(io).getRight(pageAddr, cnt - 1, this.partId))).append(' ');
            }
        }
        if (keys) {
            b.append("keys=").append(this.printPageKeys(io, pageAddr)).append(' ');
        }
        b.append(']');
        return b.toString();
    }

    private String printPageKeys(BplusIo<L> io, long pageAddr) throws IgniteInternalCheckedException {
        int cnt = io.getCount(pageAddr);
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < cnt; ++i) {
            if (i != 0) {
                b.append(',');
            }
            b.append(io.isLeaf() || this.canGetRowFromInner ? this.getRow(io, pageAddr, i) : io.getLookupRow(this, pageAddr, i));
        }
        b.append(']');
        return b.toString();
    }

    private static String formatPageId(long x) {
        return StringUtils.hexLong((long)x);
    }

    private static int fix(int idx) {
        assert (BplusTree.checkIndex(idx)) : idx;
        if (idx < 0) {
            idx = -idx - 1;
        }
        return idx;
    }

    private static boolean checkIndex(int idx) {
        return idx > -32767 && idx < Short.MAX_VALUE;
    }

    @Override
    public final T remove(L row) throws IgniteInternalCheckedException {
        return this.doRemove(row, true);
    }

    public final boolean removex(L row) throws IgniteInternalCheckedException {
        Boolean res = (Boolean)this.doRemove(row, false);
        return res != null ? res : false;
    }

    @Override
    public void invoke(L row, @Nullable Object z, IgniteTree.InvokeClosure<T> c) throws IgniteInternalCheckedException {
        this.checkDestroyed();
        Invoke x = new Invoke(row, z, c);
        try {
            block12: {
                Result res;
                block10: while (true) {
                    x.init();
                    res = this.invokeDown(x, x.rootId, 0L, 0L, x.rootLvl);
                    switch (res.ordinal()) {
                        case 4: 
                        case 5: {
                            continue block10;
                        }
                    }
                    if (x.isFinished()) break block12;
                    res = x.tryFinish();
                    if (res != Result.RETRY && res != Result.RETRY_ROOT) break;
                }
                assert (x.isFinished()) : res;
            }
            return;
        }
        catch (CorruptedDataStructureException e) {
            throw e;
        }
        catch (IgniteInternalCheckedException e) {
            throw new IgniteInternalCheckedException("Runtime failure on search row: " + String.valueOf(row), (Throwable)e);
        }
        catch (AssertionError | RuntimeException e) {
            throw this.corruptedTreeException("Runtime failure on search row: " + String.valueOf(row), (Throwable)e, this.grpId, x.pageId);
        }
        finally {
            x.releaseAll();
            this.checkDestroyed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result invokeDown(Invoke x, long pageId, long backId, long fwdId, int lvl) throws IgniteInternalCheckedException {
        assert (lvl >= 0) : lvl;
        if (x.isTail(pageId, lvl)) {
            return Result.FOUND;
        }
        long page = this.acquirePage(pageId);
        try {
            Result readResult;
            block14: while (true) {
                x.checkLockRetry();
                x.pageId(pageId);
                x.fwdId(fwdId);
                x.backId(backId);
                readResult = this.read(pageId, page, this.search, x, lvl, Result.RETRY);
                switch (readResult.ordinal()) {
                    case 1: {
                        assert (backId != 0L);
                        assert (x.backId == 0L);
                        x.backId(pageId);
                        Result askNeighborResult = this.askNeighbor(backId, x, true);
                        if (askNeighborResult != Result.FOUND) {
                            Result result = askNeighborResult;
                            return result;
                        }
                        assert (x.backId != pageId);
                    }
                    case 0: {
                        Result invokeDownResult = this.invokeDown(x, x.pageId, x.backId, x.fwdId, lvl - 1);
                        if (invokeDownResult != Result.RETRY_ROOT && !x.isFinished()) continue block14;
                        Result result = invokeDownResult;
                        return result;
                        if (invokeDownResult == Result.RETRY) continue block14;
                        assert (x.op != null);
                        Result result2 = x.op.finishOrLockTail(pageId, page, backId, fwdId, lvl);
                        return result2;
                    }
                    case 3: {
                        if (lvl == 0) {
                            x.invokeClosure();
                        }
                        assert (lvl == (x.isPut() ? (int)((Put)x.op).btmLvl : 0)) : "NOT_FOUND on the wrong level  [lvl=" + lvl + ", x=" + String.valueOf(x) + ", btmLvl=" + (x.isPut() ? ((Put)x.op).btmLvl : (short)0) + "]";
                        Result result = x.onNotFound(pageId, page, fwdId, lvl);
                        return result;
                    }
                    case 2: {
                        assert (lvl == 0) : "Invoke found an item in an inner node instead of going down: lvl=" + lvl;
                        x.invokeClosure();
                        Result result = x.onFound(pageId, page, backId, fwdId, lvl);
                        return result;
                    }
                }
                break;
            }
            Result result = readResult;
            return result;
        }
        finally {
            x.levelExit();
            if (x.canRelease(pageId, lvl)) {
                this.releasePage(pageId, page);
            }
        }
    }

    private T doRemove(L row, boolean needOld) throws IgniteInternalCheckedException {
        assert (!this.sequentialWriteOptsEnabled);
        this.checkDestroyed();
        Remove r = new Remove(row, needOld);
        try {
            block14: {
                Result res;
                block15: {
                    block10: while (true) {
                        r.init();
                        res = this.removeDown(r, r.rootId, 0L, 0L, r.rootLvl);
                        switch (res.ordinal()) {
                            case 4: 
                            case 5: {
                                continue block10;
                            }
                        }
                        if (r.isFinished()) break block14;
                        res = r.finishTail();
                        if (res != Result.RETRY && res != Result.NOT_FOUND) break block15;
                        if (!$assertionsDisabled && !r.checkTailLevel(this.getRootLevel())) break;
                    }
                    throw new AssertionError((Object)("tail=" + String.valueOf(r.tail) + ", res=" + String.valueOf((Object)res)));
                }
                assert (res == Result.FOUND) : res;
            }
            assert (r.isFinished());
            Object t = r.rmvd;
            return t;
        }
        catch (CorruptedDataStructureException e) {
            throw e;
        }
        catch (IgniteInternalCheckedException e) {
            throw new IgniteInternalCheckedException("Runtime failure on search row: " + String.valueOf(row), (Throwable)e);
        }
        catch (AssertionError | RuntimeException e) {
            throw this.corruptedTreeException("Runtime failure on search row: " + String.valueOf(row), (Throwable)e, this.grpId, r.pageId);
        }
        finally {
            r.releaseAll();
            this.checkDestroyed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result removeDown(Remove r, long pageId, long backId, long fwdId, int lvl) throws IgniteInternalCheckedException {
        assert (lvl >= 0) : lvl;
        if (r.isTail(pageId, lvl)) {
            return Result.FOUND;
        }
        long page = this.acquirePage(pageId);
        try {
            Result res;
            block14: while (true) {
                r.checkLockRetry();
                r.pageId = pageId;
                r.fwdId = fwdId;
                r.backId = backId;
                res = this.read(pageId, page, this.search, r, lvl, Result.RETRY);
                switch (res.ordinal()) {
                    case 1: {
                        assert (backId != 0L);
                        assert (r.backId == 0L);
                        r.backId = pageId;
                        res = this.askNeighbor(backId, r, true);
                        if (res != Result.FOUND) {
                            Result result = res;
                            return result;
                        }
                        assert (r.backId != pageId);
                    }
                    case 0: {
                        if ((res = this.removeDown(r, r.pageId, r.backId, r.fwdId, lvl - 1)) == Result.RETRY) continue block14;
                        if (res == Result.RETRY_ROOT || r.isFinished()) {
                            Result result = res;
                            return result;
                        }
                        Result result = res = r.finishOrLockTail(pageId, page, backId, fwdId, lvl);
                        return result;
                    }
                    case 3: {
                        assert (lvl == 0) : lvl;
                        r.finish();
                        Result result = res;
                        return result;
                    }
                    case 2: {
                        Result result = r.tryRemoveFromLeaf(pageId, page, backId, fwdId, lvl);
                        return result;
                    }
                }
                break;
            }
            Result result = res;
            return result;
        }
        finally {
            r.page = 0L;
            if (r.canRelease(pageId, lvl)) {
                this.releasePage(pageId, page);
            }
        }
    }

    private boolean mayMerge(int cnt, int cap) {
        int minCnt = (int)(this.minFill * (float)cap);
        if (cnt <= minCnt) {
            assert (cnt == 0);
            return true;
        }
        assert (cnt > 0);
        int maxCnt = (int)(this.maxFill * (float)cap);
        if (cnt > maxCnt) {
            return false;
        }
        assert (false);
        return BplusTree.randomInt(maxCnt - minCnt) >= cnt - minCnt;
    }

    public final int rootLevel() throws IgniteInternalCheckedException {
        this.checkDestroyed();
        return this.getRootLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEmpty() throws IgniteInternalCheckedException {
        this.checkDestroyed();
        while (true) {
            TreeMetaData treeMeta = this.treeMeta();
            long rootId = treeMeta.rootId;
            long rootPage = this.acquirePage(rootId);
            try {
                boolean bl;
                long rootAddr = this.readLock(rootId, rootPage);
                if (rootAddr == 0L) {
                    this.checkDestroyed();
                    continue;
                }
                try {
                    BplusIo<L> io = this.io(rootAddr);
                    bl = io.getCount(rootAddr) == 0;
                }
                catch (Throwable throwable) {
                    this.readUnlock(rootId, rootPage, rootAddr);
                    throw throwable;
                }
                this.readUnlock(rootId, rootPage, rootAddr);
                return bl;
            }
            finally {
                this.releasePage(rootId, rootPage);
                continue;
            }
            break;
        }
    }

    @Override
    public final long size() throws IgniteInternalCheckedException {
        return this.size(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public long size(@Nullable TreeRowClosure<L, T> filter) throws IgniteInternalCheckedException {
        this.checkDestroyed();
        while (true) {
            metaPage = this.acquirePage(this.metaPageId);
            try {
                curPageId = this.getFirstPageId(this.metaPageId, metaPage, 0);
            }
            finally {
                this.releasePage(this.metaPageId, metaPage);
            }
            cnt = 0L;
            curPage = this.acquirePage(curPageId);
            try {
                curPageAddr = this.readLock(curPageId, curPage);
                if (curPageAddr == 0L) continue;
                io = this.io(curPageAddr);
                if (!BplusTree.$assertionsDisabled && !io.isLeaf()) {
                    throw new AssertionError();
                }
                while (true) lbl-1000:
                // 5 sources

                {
                    curPageSize = io.getCount(curPageAddr);
                    if (filter == null) {
                        cnt += (long)curPageSize;
                    } else {
                        for (i = 0; i < curPageSize; ++i) {
                            if (!filter.apply(this, io, curPageAddr, i)) continue;
                            ++cnt;
                        }
                    }
                    nextPageId = io.getForward(curPageAddr, this.partId);
                    if (nextPageId == 0L) {
                        this.checkDestroyed();
                        var16_12 = cnt;
                        return var16_12;
                    }
                    nextPage = this.acquirePage(nextPageId);
                    try {
                        nextPageAddr = this.readLock(nextPageId, nextPage);
                        if (!BplusTree.$assertionsDisabled && nextPageAddr == 0L) {
                            throw new AssertionError(nextPageAddr);
                        }
                        try {
                            pa = curPageAddr;
                            curPageAddr = 0L;
                            this.readUnlock(curPageId, curPage, pa);
                            p = curPage;
                            curPage = 0L;
                            this.releasePage(curPageId, p);
                            curPageId = nextPageId;
                            curPage = nextPage;
                            curPageAddr = nextPageAddr;
                            nextPage = 0L;
                            nextPageAddr = 0L;
                        }
                        finally {
                            if (nextPageAddr == 0L) ** GOTO lbl-1000
                            this.readUnlock(nextPageId, nextPage, nextPageAddr);
                        }
                    }
                    finally {
                        if (nextPage == 0L) continue;
                        this.releasePage(nextPageId, nextPage);
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
                finally {
                    if (curPageAddr != 0L) {
                        this.readUnlock(curPageId, curPage, curPageAddr);
                    }
                }
            }
            finally {
                if (curPage == 0L) continue;
                this.releasePage(curPageId, curPage);
                continue;
            }
            break;
        }
    }

    @Override
    public final T put(T row) throws IgniteInternalCheckedException {
        return this.doPut(row, true);
    }

    public boolean putx(T row) throws IgniteInternalCheckedException {
        Boolean res = (Boolean)this.doPut(row, false);
        return res != null ? res : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private T doPut(T row, boolean needOld) throws IgniteInternalCheckedException {
        this.checkDestroyed();
        Put p = new Put(row, needOld);
        try {
            Result res;
            block12: while (true) {
                p.init();
                res = this.putDown(p, p.rootId, 0L, p.rootLvl);
                switch (res.ordinal()) {
                    case 4: 
                    case 5: {
                        continue block12;
                    }
                    case 2: {
                        if (!(p.isFinished() || (res = p.finishTail()) != Result.RETRY && res != Result.NOT_FOUND)) {
                            p.releaseTail();
                            assert (p.checkTailLevel(this.getRootLevel())) : "tail=" + String.valueOf(p.tail) + ", res=" + String.valueOf((Object)res);
                            continue block12;
                        }
                        Object t = p.oldRow;
                        return t;
                    }
                }
                break;
            }
            try {
                throw new IllegalStateException("Result: " + String.valueOf((Object)res));
            }
            catch (CorruptedDataStructureException e) {
                throw e;
            }
            catch (IgniteInternalCheckedException e) {
                throw new IgniteInternalCheckedException("Runtime failure on row: " + String.valueOf(row), (Throwable)e);
            }
            catch (AssertionError | RuntimeException e) {
                throw this.corruptedTreeException("Runtime failure on row: " + String.valueOf(row), (Throwable)e, this.grpId, p.pageId);
            }
        }
        finally {
            this.checkDestroyed();
        }
    }

    protected void temporaryReleaseLock() {
    }

    private void temporaryReleaseLock(Deque<IgniteTuple3<Long, Long, Long>> lockedPages) {
        lockedPages.iterator().forEachRemaining(t -> this.writeUnlock((Long)t.get1(), (Long)t.get2(), (Long)t.get3(), true));
        this.temporaryReleaseLock();
        lockedPages.descendingIterator().forEachRemaining(t -> this.writeLock((Long)t.get1(), (Long)t.get2()));
    }

    protected long maxLockHoldTime() {
        return Long.MAX_VALUE;
    }

    public final long destroy() throws IgniteInternalCheckedException {
        return this.destroy(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long destroy(@Nullable Consumer<L> c, boolean forceDestroy) throws IgniteInternalCheckedException {
        this.close();
        if (!this.markDestroyed() && !forceDestroy) {
            return 0L;
        }
        if (this.reuseList == null) {
            return -1L;
        }
        LongListReuseBag bag = new LongListReuseBag();
        long pagesCnt = 0L;
        AtomicLong lockHoldStartTime = new AtomicLong(FastTimestamps.coarseCurrentTimeMillis());
        LinkedList<IgniteTuple3<Long, Long, Long>> lockedPages = new LinkedList<IgniteTuple3<Long, Long, Long>>();
        long lockMaxTime = this.maxLockHoldTime();
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            long metaPageAddr = this.writeLock(this.metaPageId, metaPage);
            lockedPages.push(new IgniteTuple3((Object)this.metaPageId, (Object)metaPage, (Object)metaPageAddr));
            try {
                assert (metaPageAddr != 0L);
                int rootLvl = this.getRootLevel(metaPageAddr);
                if (rootLvl < 0) {
                    BplusTree.fail("Root level: " + rootLvl);
                }
                long rootPageId = this.getFirstPageId(this.metaPageId, metaPage, rootLvl, metaPageAddr);
                pagesCnt += this.destroyDownPages(bag, rootPageId, rootLvl, c, lockHoldStartTime, lockMaxTime, lockedPages);
                bag.addFreePage(BplusTree.recyclePage(this.metaPageId, metaPageAddr));
            }
            finally {
                this.writeUnlock(this.metaPageId, metaPage, metaPageAddr, true);
                lockedPages.pop();
            }
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
        this.addForRecycle(bag);
        return ++pagesCnt;
    }

    private void addForRecycle(LongListReuseBag bag) throws IgniteInternalCheckedException {
        this.reuseList.addForRecycle(bag);
        assert (bag.isEmpty()) : bag.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long destroyDownPages(LongListReuseBag bag, long pageId, int lvl, @Nullable Consumer<L> c, AtomicLong lockHoldStartTime, long lockMaxTime, Deque<IgniteTuple3<Long, Long, Long>> lockedPages) throws IgniteInternalCheckedException {
        if (pageId == 0L) {
            return 0L;
        }
        long pagesCnt = 0L;
        long page = this.acquirePage(pageId);
        try {
            long pageAddr = this.writeLock(pageId, page);
            if (pageAddr == 0L) {
                long l = 0L;
                return l;
            }
            lockedPages.push((IgniteTuple3<Long, Long, Long>)new IgniteTuple3((Object)pageId, (Object)page, (Object)pageAddr));
            try {
                int cnt;
                BplusIo<L> io = this.io(pageAddr);
                if (io.isLeaf() != (lvl == 0)) {
                    BplusTree.fail("Leaf level mismatch: " + lvl);
                }
                if ((cnt = io.getCount(pageAddr)) < 0) {
                    BplusTree.fail("Negative count: " + cnt);
                }
                if (!io.isLeaf()) {
                    for (int i = 0; i <= cnt; ++i) {
                        long leftId = BplusTree.inner(io).getLeft(pageAddr, i, this.partId);
                        BplusTree.inner(io).setLeft(pageAddr, i, 0L);
                        pagesCnt += this.destroyDownPages(bag, leftId, lvl - 1, c, lockHoldStartTime, lockMaxTime, lockedPages);
                    }
                }
                if (c != null && io.isLeaf()) {
                    io.visit(this, pageAddr, c);
                }
                bag.addFreePage(BplusTree.recyclePage(pageId, pageAddr));
                ++pagesCnt;
            }
            finally {
                this.writeUnlock(pageId, page, pageAddr, true);
                lockedPages.pop();
            }
            if (FastTimestamps.coarseCurrentTimeMillis() - lockHoldStartTime.get() > lockMaxTime) {
                this.temporaryReleaseLock(lockedPages);
                lockHoldStartTime.set(FastTimestamps.coarseCurrentTimeMillis());
            }
        }
        finally {
            this.releasePage(pageId, page);
        }
        if (bag.size() == 128) {
            this.addForRecycle(bag);
        }
        return pagesCnt;
    }

    public final GradualTask startGradualDestruction(@Nullable Consumer<L> c, boolean forceDestroy, int maxWorkUnits) throws IgniteInternalCheckedException {
        this.close();
        if (!this.markDestroyed() && !forceDestroy) {
            return GradualTask.completed();
        }
        if (this.reuseList == null) {
            return GradualTask.completed();
        }
        LongListReuseBag bag = new LongListReuseBag();
        RootPageIdAndLevel rootPageIdAndLevel = this.detachMetaPage(bag);
        return new DestroyTreeTask(bag, c, rootPageIdAndLevel.level, rootPageIdAndLevel.pageId, maxWorkUnits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RootPageIdAndLevel detachMetaPage(LongListReuseBag bag) throws IgniteInternalCheckedException {
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            RootPageIdAndLevel rootPageIdAndLevel;
            long metaPageAddr = this.writeLock(this.metaPageId, metaPage);
            try {
                assert (metaPageAddr != 0L);
                int rootLvl = this.getRootLevel(metaPageAddr);
                if (rootLvl < 0) {
                    BplusTree.fail("Root level: " + rootLvl);
                }
                long rootPageId = this.getFirstPageId(this.metaPageId, metaPage, rootLvl, metaPageAddr);
                bag.addFreePage(BplusTree.recyclePage(this.metaPageId, metaPageAddr));
                rootPageIdAndLevel = new RootPageIdAndLevel(rootPageId, rootLvl);
            }
            catch (Throwable throwable) {
                this.writeUnlock(this.metaPageId, metaPage, metaPageAddr, true);
                throw throwable;
            }
            this.writeUnlock(this.metaPageId, metaPage, metaPageAddr, true);
            return rootPageIdAndLevel;
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
    }

    public boolean markDestroyed() {
        return this.destroyed.compareAndSet(false, true);
    }

    public boolean destroyed() {
        return this.destroyed.get();
    }

    protected Iterable<Long> getFirstPageIds(long pageAddr) {
        ArrayList<Long> res = new ArrayList<Long>();
        BplusMetaIo mio = this.metaIos.forPage(pageAddr);
        for (int lvl = mio.getRootLevel(pageAddr); lvl >= 0; --lvl) {
            res.add(mio.getFirstPageId(pageAddr, lvl, this.partId));
        }
        return res;
    }

    private boolean splitPage(long pageAddr, BplusIo<L> io, long fwdId, long fwdBuf, int idx) throws IgniteInternalCheckedException {
        int cnt = io.getCount(pageAddr);
        int mid = this.sequentialWriteOptsEnabled ? (int)((double)cnt * 0.85) : cnt >>> 1;
        boolean res = false;
        if (idx > mid) {
            ++mid;
            res = true;
        }
        io.splitForwardPage(pageAddr, fwdId, fwdBuf, mid, cnt, this.pageSize(), this.partId);
        io.splitExistingPage(pageAddr, mid, fwdId);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUnlockAndClose(long pageId, long page, long pageAddr) {
        try {
            this.writeUnlock(pageId, page, pageAddr, true);
        }
        finally {
            this.releasePage(pageId, page);
        }
    }

    private Result askNeighbor(long pageId, Get g, boolean back) throws IgniteInternalCheckedException {
        return this.read(pageId, this.askNeighbor, g, back ? Bool.TRUE.ordinal() : Bool.FALSE.ordinal(), Result.RETRY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result putDown(Put p, long pageId, long fwdId, int lvl) throws IgniteInternalCheckedException {
        assert (lvl >= 0) : lvl;
        long page = this.acquirePage(pageId);
        try {
            Result res;
            block12: while (true) {
                p.checkLockRetry();
                p.pageId = pageId;
                p.fwdId = fwdId;
                res = this.read(pageId, page, this.search, p, lvl, Result.RETRY);
                switch (res.ordinal()) {
                    case 0: 
                    case 1: {
                        assert (lvl > 0) : lvl;
                        assert (p.pageId != pageId);
                        assert (p.fwdId != fwdId || fwdId == 0L);
                        res = this.putDown(p, p.pageId, p.fwdId, lvl - 1);
                        if (res != Result.RETRY_ROOT && !p.isFinished()) continue block12;
                        Result result = res;
                        return result;
                        if (res == Result.RETRY) continue block12;
                        Result result2 = res = p.finishOrLockTail(pageId, page, 0L, fwdId, lvl);
                        return result2;
                    }
                    case 2: {
                        assert (lvl == 0) : "This replace can happen only at the bottom level.";
                        Result result = p.tryReplace(pageId, page, fwdId, lvl);
                        return result;
                    }
                    case 3: {
                        assert (lvl == p.btmLvl) : "must insert at the bottom level";
                        Result result = p.tryInsert(pageId, page, fwdId, lvl);
                        return result;
                    }
                }
                break;
            }
            Result result = res;
            return result;
        }
        finally {
            if (p.canRelease(pageId, lvl)) {
                this.releasePage(pageId, page);
            }
        }
    }

    private void doVisit(TreeVisitor c) throws IgniteInternalCheckedException {
        block3: while (true) {
            c.init();
            switch (this.visitDown(c, c.rootId, 0L, c.rootLvl).ordinal()) {
                case 4: 
                case 5: {
                    continue block3;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result visitDown(TreeVisitor v, long pageId, long fwdId, int lvl) throws IgniteInternalCheckedException {
        long page = this.acquirePage(pageId);
        try {
            Result res;
            block10: while (true) {
                v.checkLockRetry();
                v.pageId = pageId;
                v.fwdId = fwdId;
                res = this.read(pageId, page, this.search, v, lvl, Result.RETRY);
                switch (res.ordinal()) {
                    case 0: 
                    case 1: {
                        assert (v.pageId != pageId);
                        assert (v.fwdId != fwdId || fwdId == 0L);
                        if ((res = this.visitDown(v, v.pageId, v.fwdId, lvl - 1)) == Result.RETRY) continue block10;
                        Result result = res;
                        return result;
                    }
                    case 3: {
                        assert (lvl == 0) : lvl;
                        Result result = v.init(pageId, page, fwdId);
                        return result;
                    }
                    case 2: {
                        throw new IllegalStateException();
                    }
                }
                break;
            }
            Result result = res;
            return result;
        }
        finally {
            if (v.canRelease(pageId, lvl)) {
                this.releasePage(pageId, page);
            }
        }
    }

    private long doAskNeighbor(BplusIo<L> io, long pageAddr, boolean back) {
        long res;
        if (back) {
            int cnt = io.getCount(pageAddr);
            res = BplusTree.inner(io).getLeft(pageAddr, cnt, this.partId);
        } else {
            res = BplusTree.inner(io).getLeft(pageAddr, 0, this.partId);
        }
        assert (res != 0L) : "inner page with no route down: " + StringUtils.hexLong((long)PageIo.getPageId(pageAddr));
        return res;
    }

    public String toString() {
        return S.toString(BplusTree.class, (Object)this);
    }

    private int findInsertionPoint(int lvl, BplusIo<L> io, long buf, int low, int cnt, @Nullable L row, int shift) throws IgniteInternalCheckedException {
        assert (row != null);
        if (this.sequentialWriteOptsEnabled) {
            assert (io.getForward(buf, this.partId) == 0L);
            return -cnt - 1;
        }
        int high = cnt - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = this.compare(lvl, io, buf, mid, row);
            if (cmp == 0) {
                cmp = -shift;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private BplusIo<L> io(long pageAddr) {
        assert (pageAddr != 0L);
        int type = PageIo.getType(pageAddr);
        int ver = PageIo.getVersion(pageAddr);
        if (this.innerIos.getType() == type) {
            return this.innerIos.forVersion(ver);
        }
        if (this.leafIos.getType() == type) {
            return this.leafIos.forVersion(ver);
        }
        throw new IllegalStateException("Unknown page type: " + type + " pageId: " + StringUtils.hexLong((long)PageIo.getPageId(pageAddr)));
    }

    private static <L> BplusInnerIo<L> inner(BplusIo<L> io) {
        assert (!io.isLeaf());
        return (BplusInnerIo)io;
    }

    public final BplusInnerIo<L> latestInnerIo() {
        return this.innerIos.latest();
    }

    public final BplusLeafIo<L> latestLeafIo() {
        return this.leafIos.latest();
    }

    public final BplusMetaIo latestMetaIo() {
        return this.metaIos.latest();
    }

    protected abstract int compare(BplusIo<L> var1, long var2, int var4, @Nullable L var5) throws IgniteInternalCheckedException;

    protected int compare(int lvl, BplusIo<L> io, long pageAddr, int idx, @Nullable L row) throws IgniteInternalCheckedException {
        return this.compare(io, pageAddr, idx, row);
    }

    public final T getRow(BplusIo<L> io, long pageAddr, int idx) throws IgniteInternalCheckedException {
        return this.getRow(io, pageAddr, idx, null);
    }

    public abstract T getRow(BplusIo<L> var1, long var2, int var4, @Nullable Object var5) throws IgniteInternalCheckedException;

    protected int getLockRetries() {
        return LOCK_RETRIES;
    }

    private static long[] pages(boolean empty, Supplier<long[]> pages) {
        return empty ? LongArrays.EMPTY_ARRAY : pages.get();
    }

    protected CorruptedTreeException corruptedTreeException(String msg, Throwable cause, int grpId, long ... pageIds) {
        return new CorruptedTreeException(msg, cause, this.grpName, grpId, pageIds);
    }

    public long getMetaPageId() {
        return this.metaPageId;
    }

    protected String lockRetryErrorMessage(String op) {
        return "Maximum number of retries " + this.getLockRetries() + " reached for " + op + " operation (the tree may be corrupted). Increase IGNITE_BPLUS_TREE_LOCK_RETRIES system property if you regularly see this message (current value is " + this.getLockRetries() + "). " + this.getClass().getSimpleName() + " [grpName=" + this.grpName + ", treeName=" + this.name() + ", metaPageId=" + StringUtils.hexLong((long)this.metaPageId) + "].";
    }

    private class CutRoot
    implements PageHandler<Void, Bool> {
        private CutRoot() {
        }

        @Override
        public Bool run(int groupId, long metaId, long metaPage, long metaAddr, PageIo iox, Void ignore, int lvl) {
            BplusMetaIo io = (BplusMetaIo)iox;
            assert (lvl == io.getRootLevel(metaAddr));
            io.cutRoot(metaAddr);
            int newLvl = lvl - 1;
            assert (io.getRootLevel(metaAddr) == newLvl);
            BplusTree.this.treeMeta = new TreeMetaData(newLvl, io.getFirstPageId(metaAddr, newLvl, BplusTree.this.partId));
            return Bool.TRUE;
        }
    }

    private class AddRoot
    implements PageHandler<Long, Bool> {
        private AddRoot() {
        }

        @Override
        public Bool run(int groupId, long metaId, long metaPage, long pageAddr, PageIo iox, Long rootPageId, int lvl) {
            assert (rootPageId != null);
            BplusMetaIo io = (BplusMetaIo)iox;
            assert (lvl == io.getLevelsCount(pageAddr));
            io.addRoot(pageAddr, rootPageId);
            assert (io.getRootLevel(pageAddr) == lvl);
            assert (io.getFirstPageId(pageAddr, lvl, BplusTree.this.partId) == rootPageId.longValue());
            BplusTree.this.treeMeta = new TreeMetaData(lvl, rootPageId);
            return Bool.TRUE;
        }
    }

    private class InitRoot
    implements PageHandler<Long, Bool> {
        private InitRoot() {
        }

        @Override
        public Bool run(int groupId, long metaId, long metaPage, long pageAddr, PageIo iox, Long rootId, int notUsed) {
            assert (rootId != null);
            BplusMetaIo io = (BplusMetaIo)iox;
            io.initRoot(pageAddr, rootId);
            assert (io.getRootLevel(pageAddr) == 0);
            assert (io.getFirstPageId(pageAddr, 0, BplusTree.this.partId) == rootId.longValue());
            BplusTree.this.treeMeta = new TreeMetaData(0, rootId);
            return Bool.TRUE;
        }
    }

    private class AskNeighbor
    extends GetPageHandler<Get> {
        private AskNeighbor() {
        }

        @Override
        public Result run0(long pageId, long page, long pageAddr, BplusIo<L> io, Get g, int isBack) {
            assert (!io.isLeaf());
            boolean back = isBack == Bool.TRUE.ordinal();
            long res = BplusTree.this.doAskNeighbor(io, pageAddr, back);
            if (back) {
                if (io.getForward(pageAddr, BplusTree.this.partId) != g.backId) {
                    return Result.RETRY;
                }
                g.backId(res);
            } else {
                assert (isBack == Bool.FALSE.ordinal()) : isBack;
                g.fwdId(res);
            }
            return Result.FOUND;
        }
    }

    public class Search
    extends GetPageHandler<Get> {
        @Override
        public Result run0(long pageId, long page, long pageAddr, BplusIo<L> io, Get g, int lvl) throws IgniteInternalCheckedException {
            boolean found;
            if (io.getForward(pageAddr, BplusTree.this.partId) != g.fwdId) {
                return Result.RETRY;
            }
            boolean needBackIfRouting = g.backId != 0L;
            g.backId(0L);
            int cnt = io.getCount(pageAddr);
            int idx = g.findLast ? (io.isLeaf() ? cnt - 1 : -cnt - 1) : BplusTree.this.findInsertionPoint(lvl, io, pageAddr, 0, cnt, g.row, g.shift);
            boolean bl = found = idx >= 0;
            if (found) {
                assert (g.getClass() != GetCursor.class);
                if (g.found(io, pageAddr, idx, lvl)) {
                    return Result.FOUND;
                }
            } else if (g.notFound(io, pageAddr, idx = BplusTree.fix(idx), lvl)) {
                return Result.NOT_FOUND;
            }
            assert (!io.isLeaf()) : io;
            g.pageId(BplusTree.inner(io).getLeft(pageAddr, idx, BplusTree.this.partId));
            if (idx < cnt) {
                g.fwdId(BplusTree.inner(io).getRight(pageAddr, idx, BplusTree.this.partId));
            } else {
                assert (idx == cnt);
                long fwdId = io.getForward(pageAddr, BplusTree.this.partId);
                if (fwdId == 0L) {
                    g.fwdId(0L);
                } else {
                    Result res = BplusTree.this.askNeighbor(fwdId, g, false);
                    if (res != Result.FOUND) {
                        return res;
                    }
                }
                if (cnt != 0) {
                    g.backId(BplusTree.inner(io).getLeft(pageAddr, cnt - 1, BplusTree.this.partId));
                } else if (needBackIfRouting) {
                    return Result.GO_DOWN_X;
                }
            }
            return Result.GO_DOWN;
        }
    }

    private class LockTailExact
    extends GetPageHandler<Update> {
        private LockTailExact() {
        }

        @Override
        protected Result run0(long pageId, long page, long pageAddr, BplusIo<L> io, Update u, int lvl) {
            if (io.getForward(pageAddr, BplusTree.this.partId) != u.fwdId) {
                return Result.RETRY;
            }
            u.addTail(pageId, page, pageAddr, io, lvl, (byte)1);
            return Result.FOUND;
        }
    }

    private class LockTail
    extends GetPageHandler<Remove> {
        private LockTail() {
        }

        @Override
        public Result run0(long pageId, long page, long pageAddr, BplusIo<L> io, Remove r, int lvl) throws IgniteInternalCheckedException {
            Result res;
            assert (lvl > 0) : lvl;
            if (io.getForward(pageAddr, BplusTree.this.partId) != r.fwdId) {
                return Result.RETRY;
            }
            if (r.fwdId != 0L && r.backId == 0L && (res = r.lockForward(lvl)) != Result.FOUND) {
                return res;
            }
            r.addTail(pageId, page, pageAddr, io, lvl, (byte)1);
            return Result.FOUND;
        }
    }

    private class LockTailForward
    extends GetPageHandler<Remove> {
        private LockTailForward() {
        }

        @Override
        protected Result run0(long pageId, long page, long pageAddr, BplusIo<L> io, Remove r, int lvl) {
            r.addTail(pageId, page, pageAddr, io, lvl, (byte)2);
            return Result.FOUND;
        }
    }

    private class LockBackAndTail
    extends GetPageHandler<Remove> {
        private LockBackAndTail() {
        }

        @Override
        public Result run0(long backId, long backPage, long backAddr, BplusIo<L> io, Remove r, int lvl) throws IgniteInternalCheckedException {
            if (io.getForward(backAddr, BplusTree.this.partId) != r.pageId) {
                return Result.RETRY;
            }
            Result res = r.doLockTail(lvl);
            if (res == Result.FOUND) {
                r.addTail(backId, backPage, backAddr, io, lvl, (byte)0);
            }
            return res;
        }
    }

    private class LockBackAndRmvFromLeaf
    extends GetPageHandler<Remove> {
        private LockBackAndRmvFromLeaf() {
        }

        @Override
        protected Result run0(long backId, long backPage, long backAddr, BplusIo<L> io, Remove r, int lvl) throws IgniteInternalCheckedException {
            if (io.getForward(backAddr, BplusTree.this.partId) != r.pageId) {
                return Result.RETRY;
            }
            Result res = r.doRemoveFromLeaf();
            if (res == Result.FOUND && r.tail != null) {
                r.addTail(backId, backPage, backAddr, io, lvl, (byte)0);
            }
            return res;
        }
    }

    private class RemoveFromLeaf
    extends GetPageHandler<Remove> {
        private RemoveFromLeaf() {
        }

        @Override
        public Result run0(long leafId, long leafPage, long leafAddr, BplusIo<L> io, Remove r, int lvl) throws IgniteInternalCheckedException {
            boolean needReplaceInner;
            assert (lvl == 0) : lvl;
            if (io.getForward(leafAddr, BplusTree.this.partId) != r.fwdId) {
                return Result.RETRY;
            }
            int cnt = io.getCount(leafAddr);
            assert (cnt <= Short.MAX_VALUE) : cnt;
            int idx = BplusTree.this.findInsertionPoint(lvl, io, leafAddr, 0, cnt, r.row, 0);
            if (idx < 0) {
                return Result.RETRY;
            }
            assert (idx >= 0 && idx < cnt) : idx;
            boolean bl = needReplaceInner = BplusTree.this.canGetRowFromInner && idx == cnt - 1 && io.getForward(leafAddr, BplusTree.this.partId) != 0L;
            if (needReplaceInner || (r.fwdId != 0L || r.backId != 0L) && BplusTree.this.mayMerge(cnt - 1, io.getMaxCount(leafAddr, BplusTree.this.pageSize()))) {
                if (r.fwdId != 0L && r.backId == 0L) {
                    Result res = r.lockForward(0);
                    if (res != Result.FOUND) {
                        assert (r.tail == null);
                        return res;
                    }
                    assert (r.tail != null);
                }
                assert (!r.needReplaceInner && r.needMergeEmptyBranch == Bool.FALSE) : "needReplaceInner=" + r.needReplaceInner + ", needMergeEmptyBranch=" + String.valueOf((Object)r.needMergeEmptyBranch);
                if (cnt == 1) {
                    r.needMergeEmptyBranch = Bool.TRUE;
                }
                r.needReplaceInner = needReplaceInner;
                Tail t = r.addTail(leafId, leafPage, leafAddr, io, 0, (byte)1);
                t.idx = (short)idx;
                return Result.FOUND;
            }
            r.removeDataRowFromLeaf(leafAddr, io, cnt, idx);
            return Result.FOUND;
        }
    }

    public class Insert
    extends GetPageHandler<Put> {
        @Override
        public Result run0(long pageId, long page, long pageAddr, BplusIo<L> io, Put p, int lvl) throws IgniteInternalCheckedException {
            assert (p.btmLvl == lvl) : "we must always insert at the bottom level: " + p.btmLvl + " " + lvl;
            if (io.getForward(pageAddr, BplusTree.this.partId) != p.fwdId) {
                return Result.RETRY;
            }
            int cnt = io.getCount(pageAddr);
            int idx = BplusTree.this.findInsertionPoint(lvl, io, pageAddr, 0, cnt, p.row, 0);
            if (idx >= 0) {
                throw new IllegalStateException("Duplicate row in index.");
            }
            Object moveUpRow = p.insert(pageId, pageAddr, io, idx = BplusTree.fix(idx), lvl);
            if (moveUpRow != null) {
                p.btmLvl = (short)(p.btmLvl + 1);
                p.row = moveUpRow;
                if (p.invoke != null) {
                    p.invoke.row = moveUpRow;
                }
                p.rightId = io.getForward(pageAddr, BplusTree.this.partId);
                p.setTailForSplit(pageId, page, pageAddr, io, p.btmLvl - 1);
                assert (p.rightId != 0L);
            } else {
                p.finish();
            }
            return Result.FOUND;
        }
    }

    public class Replace
    extends GetPageHandler<Put> {
        @Override
        public Result run0(long pageId, long page, long pageAddr, BplusIo<L> io, Put p, int lvl) throws IgniteInternalCheckedException {
            if (io.getForward(pageAddr, BplusTree.this.partId) != p.fwdId) {
                return Result.RETRY;
            }
            assert (p.btmLvl == 0) : "split is impossible with replace";
            assert (lvl == 0) : "Replace via page handler is only possible on the leaves level.";
            int cnt = io.getCount(pageAddr);
            int idx = BplusTree.this.findInsertionPoint(lvl, io, pageAddr, 0, cnt, p.row, 0);
            if (idx < 0) {
                return Result.RETRY;
            }
            assert (p.oldRow == null) : "The old row must be set only once.";
            if (BplusTree.this.canGetRowFromInner && idx + 1 == cnt && p.fwdId != 0L) {
                Tail tail = p.addTail(pageId, page, pageAddr, io, lvl, (byte)1);
                tail.idx = (short)idx;
                return Result.FOUND;
            }
            p.oldRow = p.needOld ? BplusTree.this.getRow(io, pageAddr, idx) : Boolean.TRUE;
            p.replaceRowInPage(io, pageAddr, idx);
            p.finish();
            return Result.FOUND;
        }
    }

    static enum Bool {
        FALSE,
        TRUE,
        READY,
        DONE;

    }

    private static class TreeMetaData {
        final int rootLvl;
        final long rootId;

        TreeMetaData(int rootLvl, long rootId) {
            this.rootLvl = rootLvl;
            this.rootId = rootId;
        }

        public String toString() {
            return S.toString(TreeMetaData.class, (Object)this);
        }
    }

    private final class ForwardCursor<R>
    extends AbstractForwardCursor
    implements Cursor<R> {
        @Nullable
        private final Object arg;
        @Nullable
        private @Nullable R @Nullable [] results;
        @Nullable
        private T lastRow;
        private int row;
        @Nullable
        private final TreeRowMapClosure<L, T, R> treeRowClosure;
        @Nullable
        private Boolean hasNext;

        ForwardCursor(L upperBound, @Nullable boolean upIncl, @Nullable TreeRowMapClosure<L, T, R> treeRowClosure, Object arg) {
            this(null, upperBound, true, upIncl, treeRowClosure, arg);
        }

        ForwardCursor(@Nullable L lowerBound, L upperBound, boolean lowIncl, @Nullable boolean upIncl, @Nullable TreeRowMapClosure<L, T, R> treeRowClosure, Object arg) {
            super(lowerBound, upperBound, lowIncl, upIncl);
            this.results = ArrayUtils.OBJECT_EMPTY_ARRAY;
            this.row = -1;
            this.hasNext = null;
            this.treeRowClosure = treeRowClosure;
            this.arg = arg;
        }

        @Override
        boolean fillFromBuffer0(long pageAddr, BplusIo<L> io, int startIdx, int cnt) throws IgniteInternalCheckedException {
            int cnt0;
            if (startIdx == -1) {
                startIdx = this.lowerBound != null ? this.findLowerBound(pageAddr, io, cnt) : 0;
            }
            if (this.upperBound != null && cnt != startIdx) {
                cnt = this.findUpperBound(pageAddr, io, startIdx, cnt);
            }
            if ((cnt0 = cnt - startIdx) == 0) {
                return false;
            }
            if (this.results == ArrayUtils.OBJECT_EMPTY_ARRAY) {
                this.results = new Object[cnt0];
            }
            int resCnt = 0;
            for (int idx = startIdx; idx < cnt; ++idx) {
                if (this.treeRowClosure != null && !this.treeRowClosure.apply(BplusTree.this, io, pageAddr, idx)) continue;
                Object treeRow = BplusTree.this.getRow(io, pageAddr, idx, this.arg);
                Object result = this.treeRowClosure != null ? this.treeRowClosure.map(treeRow) : treeRow;
                this.results = ArrayUtils.set((Object[])this.results, (int)resCnt++, result);
                this.lastRow = treeRow;
            }
            if (resCnt == 0) {
                this.results = ArrayUtils.OBJECT_EMPTY_ARRAY;
                return false;
            }
            ArrayUtils.clearTail((Object[])this.results, (int)resCnt);
            return true;
        }

        @Override
        boolean reinitialize0() {
            this.hasNext = null;
            return this.hasNext();
        }

        @Override
        void onNotFound(boolean readDone) {
            if (readDone) {
                this.results = null;
            } else if (this.results != ArrayUtils.OBJECT_EMPTY_ARRAY) {
                assert (this.results.length > 0);
                this.results[0] = null;
            }
        }

        @Override
        void init0() {
            this.row = -1;
        }

        public boolean hasNext() {
            if (this.results == null) {
                return false;
            }
            if (this.hasNext == null) {
                this.hasNext = this.advance();
            }
            return this.hasNext;
        }

        private void clearLastResult() {
            if (this.row == 0) {
                return;
            }
            int last = this.row - 1;
            assert (this.results[last] != null);
            this.results[last] = null;
        }

        public R next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            R r = this.results[this.row];
            assert (r != null);
            this.hasNext = null;
            return r;
        }

        private boolean advance() {
            if (++this.row < this.results.length && this.results[this.row] != null) {
                this.clearLastResult();
                return true;
            }
            this.clearLastResult();
            this.row = 0;
            Object lastRow = this.lastRow;
            this.lastRow = null;
            try {
                return this.nextPage(lastRow);
            }
            catch (IgniteInternalCheckedException e) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Unable to read the next page", (Throwable)e);
            }
        }

        public void close() {
        }
    }

    public static interface TreeRowMapClosure<L, T extends L, R>
    extends TreeRowClosure<L, T> {
        @Override
        default public boolean apply(BplusTree<L, T> tree, BplusIo<L> io, long pageAddr, int idx) throws IgniteInternalCheckedException {
            return true;
        }

        @Nullable
        default public R map(@Nullable T treeRow) {
            return (R)treeRow;
        }
    }

    private final class GetCursor
    extends Get {
        AbstractForwardCursor cursor;

        GetCursor(L lower, int shift, AbstractForwardCursor cursor) {
            super(lower, false);
            assert (shift != 0);
            this.shift = shift;
            this.cursor = cursor;
        }

        @Override
        boolean found(BplusIo<L> io, long pageAddr, int idx, int lvl) {
            throw new IllegalStateException();
        }

        @Override
        boolean notFound(BplusIo<L> io, long pageAddr, int idx, int lvl) throws IgniteInternalCheckedException {
            if (lvl != 0) {
                return false;
            }
            this.cursor.init(pageAddr, io, idx);
            return true;
        }
    }

    private final class ClosureCursor
    extends AbstractForwardCursor {
        private final TreeRowClosure<L, T> predicate;
        @Nullable
        private L lastRow;

        ClosureCursor(L lowerBound, L upperBound, TreeRowClosure<L, T> predicate) {
            super(lowerBound, upperBound, true, true);
            this.predicate = predicate;
        }

        @Override
        void init0() {
        }

        @Override
        boolean fillFromBuffer0(long pageAddr, BplusIo<L> io, int startIdx, int cnt) throws IgniteInternalCheckedException {
            if (startIdx == -1) {
                startIdx = this.findLowerBound(pageAddr, io, cnt);
            }
            if (cnt == startIdx) {
                return false;
            }
            for (int i = startIdx; i < cnt; ++i) {
                boolean stop;
                int cmp = BplusTree.this.compare(0, io, pageAddr, i, this.upperBound);
                if (cmp > 0) {
                    this.nextPageId = 0L;
                    return false;
                }
                boolean bl = stop = !this.predicate.apply(BplusTree.this, io, pageAddr, i);
                if (!stop) continue;
                this.nextPageId = 0L;
                return true;
            }
            if (this.nextPageId != 0L) {
                this.lastRow = io.getLookupRow(BplusTree.this, pageAddr, cnt - 1);
            }
            return true;
        }

        @Override
        boolean reinitialize0() {
            return true;
        }

        @Override
        void onNotFound(boolean readDone) {
            this.nextPageId = 0L;
        }

        private void iterate() throws IgniteInternalCheckedException {
            this.find();
            if (this.nextPageId == 0L) {
                return;
            }
            do {
                Object lastRow0 = this.lastRow;
                this.lastRow = null;
                this.nextPage(lastRow0);
            } while (this.nextPageId != 0L);
        }
    }

    @FunctionalInterface
    public static interface TreeRowClosure<L, T extends L> {
        public boolean apply(BplusTree<L, T> var1, BplusIo<L> var2, long var3, int var5) throws IgniteInternalCheckedException;
    }

    private final class TreeVisitor
    extends Get {
        long nextPageId;
        L upper;
        TreeVisitorClosure<L, T> pred;
        private boolean dirty;
        private boolean writing;

        TreeVisitor(L lower, L upper, TreeVisitorClosure<L, T> pred) {
            super(lower, false);
            this.shift = -1;
            this.upper = upper;
            this.pred = pred;
        }

        @Override
        boolean found(BplusIo<L> io, long pageAddr, int idx, int lvl) {
            throw new IllegalStateException();
        }

        @Override
        boolean notFound(BplusIo<L> io, long pageAddr, int idx, int lvl) throws IgniteInternalCheckedException {
            if (lvl != 0) {
                return false;
            }
            boolean bl = this.writing = (this.pred.state() & 2) != 0;
            if (!this.writing) {
                this.init(pageAddr, io, idx);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Result init(long pageId, long page, long fwdId) throws IgniteInternalCheckedException {
            this.pageId = pageId;
            this.fwdId = fwdId;
            if (this.writing) {
                long pageAddr = BplusTree.this.writeLock(pageId, page);
                if (pageAddr == 0L) {
                    return Result.RETRY;
                }
                try {
                    BplusIo io = BplusTree.this.io(pageAddr);
                    if (io.getForward(pageAddr, BplusTree.this.partId) != fwdId) {
                        Result result = Result.RETRY;
                        return result;
                    }
                    this.init(pageAddr, io, -1);
                }
                finally {
                    this.unlock(pageId, page, pageAddr);
                }
            }
            return Result.NOT_FOUND;
        }

        private void init(long pageAddr, BplusIo<L> io, int startIdx) throws IgniteInternalCheckedException {
            this.nextPageId = 0L;
            int cnt = io.getCount(pageAddr);
            if (cnt != 0) {
                this.visit(pageAddr, io, startIdx, cnt);
            }
        }

        private void visit(long pageAddr, BplusIo<L> io, int startIdx, int cnt) throws IgniteInternalCheckedException {
            assert (io.isLeaf()) : io;
            assert (cnt != 0) : cnt;
            assert (startIdx >= -1) : startIdx;
            assert (cnt >= startIdx);
            BplusTree.this.checkDestroyed();
            this.nextPageId = io.getForward(pageAddr, BplusTree.this.partId);
            if (startIdx == -1) {
                startIdx = this.findLowerBound(pageAddr, io, cnt);
            }
            if (cnt == startIdx) {
                return;
            }
            cnt = this.findUpperBound(pageAddr, io, startIdx, cnt);
            for (int i = startIdx; i < cnt; ++i) {
                boolean stop;
                int state = this.pred.visit(BplusTree.this, io, pageAddr, i);
                boolean bl = stop = (state & 1) != 0;
                if (this.writing) {
                    boolean bl2 = this.dirty = this.dirty || (state & 4) != 0;
                }
                if (!stop) continue;
                this.nextPageId = 0L;
                return;
            }
            if (this.nextPageId != 0L) {
                this.row = io.getLookupRow(BplusTree.this, pageAddr, cnt - 1);
                this.shift = 1;
            }
        }

        private void visit() throws IgniteInternalCheckedException {
            BplusTree.this.doVisit(this);
            while (this.nextPageId != 0L) {
                this.nextPage();
            }
        }

        private int findLowerBound(long pageAddr, BplusIo<L> io, int cnt) throws IgniteInternalCheckedException {
            assert (io.isLeaf());
            int cmp = BplusTree.this.compare(0, io, pageAddr, 0, this.row);
            if (cmp < 0 || cmp == 0 && this.shift == 1) {
                int idx = BplusTree.this.findInsertionPoint(0, io, pageAddr, 0, cnt, this.row, this.shift);
                assert (idx < 0);
                return BplusTree.fix(idx);
            }
            return 0;
        }

        private int findUpperBound(long pageAddr, BplusIo<L> io, int low, int cnt) throws IgniteInternalCheckedException {
            assert (io.isLeaf());
            int cmp = BplusTree.this.compare(0, io, pageAddr, cnt - 1, this.upper);
            if (cmp > 0) {
                int idx = BplusTree.this.findInsertionPoint(0, io, pageAddr, low, cnt, this.upper, 1);
                assert (idx < 0);
                cnt = BplusTree.fix(idx);
                this.nextPageId = 0L;
            }
            return cnt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void nextPage() throws IgniteInternalCheckedException {
            while (true) {
                if (this.nextPageId == 0L) {
                    return;
                }
                long pageId = this.nextPageId;
                long page = BplusTree.this.acquirePage(pageId);
                try {
                    long pageAddr = this.lock(pageId, page);
                    if (pageAddr == 0L) break;
                    try {
                        BplusIo io = BplusTree.this.io(pageAddr);
                        this.visit(pageAddr, io, -1, io.getCount(pageAddr));
                        continue;
                    }
                    finally {
                        this.unlock(pageId, page, pageAddr);
                        continue;
                    }
                }
                finally {
                    BplusTree.this.releasePage(pageId, page);
                    continue;
                }
                break;
            }
            BplusTree.this.doVisit(this);
        }

        private void unlock(long pageId, long page, long pageAddr) {
            if (this.writing) {
                BplusTree.this.writeUnlock(pageId, page, pageAddr, this.dirty);
                this.dirty = false;
            } else {
                BplusTree.this.readUnlock(pageId, page, pageAddr);
            }
        }

        private long lock(long pageId, long page) {
            boolean bl = this.writing = (this.pred.state() & 2) != 0;
            if (this.writing) {
                return BplusTree.this.writeLock(pageId, page);
            }
            return BplusTree.this.readLock(pageId, page);
        }
    }

    public static interface TreeVisitorClosure<L, T extends L> {
        public static final int STOP = 1;
        public static final int CAN_WRITE = 2;
        public static final int DIRTY = 4;

        public int visit(BplusTree<L, T> var1, BplusIo<L> var2, long var3, int var5) throws IgniteInternalCheckedException;

        public int state();
    }

    private final class GetOne<R>
    extends Get {
        @Nullable
        private final Object arg;
        @Nullable
        private final TreeRowMapClosure<L, T, R> treeRowClosure;
        @Nullable
        private R res;

        private GetOne(@Nullable L row, @Nullable TreeRowMapClosure<L, T, R> treeRowClosure, Object arg, boolean findLast) {
            super(row, findLast);
            this.treeRowClosure = treeRowClosure;
            this.arg = arg;
        }

        @Override
        boolean found(BplusIo<L> io, long pageAddr, int idx, int lvl) throws IgniteInternalCheckedException {
            if (lvl != 0 && !BplusTree.this.canGetRowFromInner) {
                return false;
            }
            if (this.treeRowClosure == null || this.treeRowClosure.apply(BplusTree.this, io, pageAddr, idx)) {
                Object treeRow = BplusTree.this.getRow(io, pageAddr, idx, this.arg);
                this.res = this.treeRowClosure != null ? this.treeRowClosure.map(treeRow) : treeRow;
            }
            return true;
        }

        @Override
        boolean notFound(BplusIo<L> io, long pageAddr, int idx, int lvl) {
            assert (lvl >= 0) : lvl;
            if (lvl == 0) {
                this.res = this.treeRowClosure == null ? null : this.treeRowClosure.map(null);
                return true;
            }
            return false;
        }
    }

    public abstract class Get {
        long rmvId;
        int rootLvl;
        long rootId;
        @Nullable
        L row;
        long pageId;
        long fwdId;
        long backId;
        int shift;
        Invoke invoke;
        boolean findLast;
        int lockRetriesCnt;

        Get(L row, boolean findLast) {
            this.lockRetriesCnt = BplusTree.this.getLockRetries();
            assert (findLast ^ row != null);
            this.row = row;
            this.findLast = findLast;
        }

        final void copyFrom(Get g) {
            this.rmvId = g.rmvId;
            this.rootLvl = g.rootLvl;
            this.pageId = g.pageId;
            this.fwdId = g.fwdId;
            this.backId = g.backId;
            this.shift = g.shift;
            this.findLast = g.findLast;
        }

        final void init() throws IgniteInternalCheckedException {
            TreeMetaData meta0 = BplusTree.this.treeMeta();
            assert (meta0 != null);
            this.restartFromRoot(meta0.rootId, meta0.rootLvl, BplusTree.this.globalRmvId.get());
        }

        void restartFromRoot(long rootId, int rootLvl, long rmvId) {
            this.rootId = rootId;
            this.rootLvl = rootLvl;
            this.rmvId = rmvId;
        }

        boolean found(BplusIo<L> io, long pageAddr, int idx, int lvl) throws IgniteInternalCheckedException {
            assert (lvl >= 0);
            return lvl == 0;
        }

        boolean notFound(BplusIo<L> io, long pageAddr, int idx, int lvl) throws IgniteInternalCheckedException {
            assert (lvl >= 0);
            return lvl == 0;
        }

        public boolean canRelease(long pageId, int lvl) {
            return pageId != 0L;
        }

        void backId(long backId) {
            this.backId = backId;
        }

        void pageId(long pageId) {
            this.pageId = pageId;
        }

        void fwdId(long fwdId) {
            this.fwdId = fwdId;
        }

        boolean isFinished() {
            throw new IllegalStateException();
        }

        void checkLockRetry() throws IgniteInternalCheckedException {
            if (this.lockRetriesCnt == 0) {
                String errMsg = BplusTree.this.lockRetryErrorMessage(this.getClass().getSimpleName());
                throw new IgniteInternalCheckedException(errMsg);
            }
            --this.lockRetriesCnt;
        }

        public L row() {
            return this.row;
        }
    }

    private final class GetLast
    extends Get {
        private final TreeRowClosure<L, T> filter;
        private boolean retry;
        private long lastPageId;
        private T row0;

        public GetLast(TreeRowClosure<L, T> filter) {
            super(null, true);
            this.retry = true;
            assert (filter != null);
            this.filter = filter;
        }

        @Override
        boolean found(BplusIo<L> io, long pageAddr, int idx, int lvl) throws IgniteInternalCheckedException {
            if (lvl != 0) {
                return false;
            }
            for (int i = idx; i >= 0; --i) {
                if (!this.filter.apply(BplusTree.this, io, pageAddr, i)) continue;
                this.retry = false;
                this.row0 = BplusTree.this.getRow(io, pageAddr, i);
                return true;
            }
            if (this.pageId == this.rootId) {
                this.retry = false;
            }
            if (this.retry) {
                this.findLast = false;
                this.row0 = BplusTree.this.getRow(io, pageAddr, 0);
                this.shift = -1;
                this.lastPageId = this.pageId;
            }
            return true;
        }

        @Override
        boolean notFound(BplusIo<L> io, long pageAddr, int idx, int lvl) throws IgniteInternalCheckedException {
            if (lvl != 0) {
                return false;
            }
            if (io.getCount(pageAddr) == 0) {
                this.retry = false;
                return true;
            }
            if (idx == 0 && this.lastPageId == this.pageId) {
                this.retry = false;
                this.row0 = null;
                return true;
            }
            for (int i = idx; i >= 0; --i) {
                if (!this.filter.apply(BplusTree.this, io, pageAddr, i)) continue;
                this.retry = false;
                this.row0 = BplusTree.this.getRow(io, pageAddr, i);
                break;
            }
            if (this.retry) {
                this.row0 = BplusTree.this.getRow(io, pageAddr, 0);
                this.lastPageId = this.pageId;
            }
            return true;
        }

        public T find() throws IgniteInternalCheckedException {
            while (this.retry) {
                this.row = this.row0;
                BplusTree.this.doFind(this);
            }
            return this.row0;
        }
    }

    private final class GetNext
    extends Get {
        @Nullable
        private T nextRow;

        private GetNext(L row, boolean includeRow) {
            super(row, false);
            this.shift = includeRow ? -1 : 1;
        }

        @Override
        boolean found(BplusIo<L> io, long pageAddr, int idx, int lvl) {
            throw new IllegalStateException();
        }

        @Override
        boolean notFound(BplusIo<L> io, long pageAddr, int idx, int lvl) throws IgniteInternalCheckedException {
            if (lvl != 0) {
                return false;
            }
            int cnt = io.getCount(pageAddr);
            if (cnt == 0) {
                assert (io.getForward(pageAddr, BplusTree.this.partId) == 0L);
            } else {
                assert (io.isLeaf()) : io;
                assert (cnt > 0) : cnt;
                assert (idx >= 0) : idx;
                assert (cnt >= idx) : "cnt=" + cnt + ", idx=" + idx;
                BplusTree.this.checkDestroyed();
                if (idx < cnt) {
                    this.nextRow = BplusTree.this.getRow(io, pageAddr, idx);
                }
            }
            return true;
        }
    }

    public static enum Result {
        GO_DOWN,
        GO_DOWN_X,
        FOUND,
        NOT_FOUND,
        RETRY,
        RETRY_ROOT;

    }

    public final class Invoke
    extends Get {
        Object arg;
        IgniteTree.InvokeClosure<T> clo;
        Bool closureInvoked;
        T foundRow;
        Update op;

        private Invoke(L row, Object arg, IgniteTree.InvokeClosure<T> clo) {
            super(row, false);
            this.closureInvoked = Bool.FALSE;
            assert (clo != null);
            this.clo = clo;
            this.arg = arg;
        }

        @Override
        void pageId(long pageId) {
            this.pageId = pageId;
            if (this.op != null) {
                this.op.pageId = pageId;
            }
        }

        @Override
        void fwdId(long fwdId) {
            this.fwdId = fwdId;
            if (this.op != null) {
                this.op.fwdId = fwdId;
            }
        }

        @Override
        void backId(long backId) {
            this.backId = backId;
            if (this.op != null) {
                this.op.backId = backId;
            }
        }

        @Override
        void restartFromRoot(long rootId, int rootLvl, long rmvId) {
            super.restartFromRoot(rootId, rootLvl, rmvId);
            if (this.op != null) {
                this.op.restartFromRoot(rootId, rootLvl, rmvId);
            }
        }

        @Override
        boolean found(BplusIo<L> io, long pageAddr, int idx, int lvl) throws IgniteInternalCheckedException {
            if (this.op != null) {
                return this.op.found(io, pageAddr, idx, lvl);
            }
            if (lvl == 0) {
                if (this.closureInvoked == Bool.FALSE) {
                    this.closureInvoked = Bool.READY;
                    this.foundRow = BplusTree.this.getRow(io, pageAddr, idx, this.arg);
                }
                return true;
            }
            return false;
        }

        @Override
        boolean notFound(BplusIo<L> io, long pageAddr, int idx, int lvl) throws IgniteInternalCheckedException {
            if (this.op != null) {
                return this.op.notFound(io, pageAddr, idx, lvl);
            }
            if (lvl == 0) {
                if (this.closureInvoked == Bool.FALSE) {
                    this.closureInvoked = Bool.READY;
                }
                return true;
            }
            return false;
        }

        private void invokeClosure() throws IgniteInternalCheckedException {
            if (this.closureInvoked != Bool.READY) {
                return;
            }
            this.closureInvoked = Bool.DONE;
            this.clo.call(this.foundRow);
            switch (this.clo.operationType()) {
                case PUT: {
                    Object newRow = this.clo.newRow();
                    assert (newRow != null);
                    this.op = new Put(newRow, false, this.clo::onUpdate);
                    break;
                }
                case REMOVE: {
                    assert (this.foundRow != null);
                    this.op = new Remove(this.row, false, this.clo::onUpdate);
                    break;
                }
                case NOOP: 
                case IN_PLACE: {
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.op.copyFrom(this);
            this.op.invoke = this;
        }

        @Override
        public boolean canRelease(long pageId, int lvl) {
            return pageId != 0L && (this.op == null || this.op.canRelease(pageId, lvl));
        }

        private boolean isPut() {
            return this.op != null && this.op.getClass() == Put.class;
        }

        private boolean isRemove() {
            return this.op != null && this.op.getClass() == Remove.class;
        }

        private boolean isTail(long pageId, int lvl) {
            return this.op != null && this.op.isTail(pageId, lvl);
        }

        private void levelExit() {
            if (this.isRemove()) {
                ((Remove)this.op).page = 0L;
            }
        }

        private void releaseAll() throws IgniteInternalCheckedException {
            if (this.isRemove()) {
                ((Remove)this.op).releaseAll();
            }
        }

        private Result onNotFound(long pageId, long page, long fwdId, int lvl) throws IgniteInternalCheckedException {
            if (this.op == null) {
                return Result.NOT_FOUND;
            }
            if (this.isRemove()) {
                assert (lvl == 0);
                ((Remove)this.op).finish();
                return Result.NOT_FOUND;
            }
            return ((Put)this.op).tryInsert(pageId, page, fwdId, lvl);
        }

        private Result onFound(long pageId, long page, long backId, long fwdId, int lvl) throws IgniteInternalCheckedException {
            if (this.op == null) {
                return Result.FOUND;
            }
            if (this.isRemove()) {
                return ((Remove)this.op).tryRemoveFromLeaf(pageId, page, backId, fwdId, lvl);
            }
            return ((Put)this.op).tryReplace(pageId, page, fwdId, lvl);
        }

        private Result tryFinish() throws IgniteInternalCheckedException {
            assert (this.op != null);
            Result res = this.op.finishTail();
            if (res == Result.NOT_FOUND) {
                res = Result.RETRY;
            }
            if (res == Result.RETRY && this.isPut()) {
                this.op.releaseTail();
            }
            assert (res == Result.FOUND || res == Result.RETRY) : res;
            return res;
        }

        @Override
        boolean isFinished() {
            return this.closureInvoked == Bool.DONE && (this.op == null || this.op.isFinished());
        }
    }

    private abstract class Update
    extends Get {
        @Nullable
        Tail<L> tail;
        @Nullable
        final Runnable onUpdateCallback;

        private Update(L row) {
            this(row, null);
        }

        private Update(@Nullable L row, Runnable onUpdateCallback) {
            super(row, false);
            this.onUpdateCallback = onUpdateCallback;
        }

        protected abstract Result finishOrLockTail(long var1, long var3, long var5, long var7, int var9) throws IgniteInternalCheckedException;

        protected abstract Result finishTail() throws IgniteInternalCheckedException;

        protected final void releaseTail() {
            this.doReleaseTail(this.tail);
            this.tail = null;
        }

        protected final boolean checkTailLevel(int rootLvl) {
            return this.tail == null || this.tail.lvl < rootLvl;
        }

        protected final void doReleaseTail(@Nullable Tail<L> t) {
            while (t != null) {
                BplusTree.this.writeUnlockAndClose(t.pageId, t.page, t.buf);
                Tail s = t.sibling;
                if (s != null) {
                    BplusTree.this.writeUnlockAndClose(s.pageId, s.page, s.buf);
                }
                t = t.down;
            }
        }

        @Override
        public final boolean canRelease(long pageId, int lvl) {
            return pageId != 0L && !this.isTail(pageId, lvl);
        }

        protected final boolean isTail(long pageId, int lvl) {
            Tail t = this.tail;
            while (t != null) {
                if (t.lvl < lvl) {
                    return false;
                }
                if (t.lvl == lvl) {
                    if (t.pageId == pageId) {
                        return true;
                    }
                    t = t.sibling;
                    return t != null && t.pageId == pageId;
                }
                t = t.down;
            }
            return false;
        }

        protected final Tail<L> addTail(long pageId, long page, long pageAddr, BplusIo<L> io, int lvl, byte type) {
            Tail t = new Tail(pageId, page, pageAddr, io, type, lvl);
            if (this.tail == null) {
                this.tail = t;
            } else if (this.tail.lvl == lvl) {
                assert (this.tail.sibling == null);
                if (type == 1) {
                    assert (this.tail.type != 1);
                    if (this.tail.down != null) {
                        t.down = this.tail.down;
                        this.tail.down = null;
                    }
                    t.sibling = this.tail;
                    this.tail = t;
                } else {
                    assert (this.tail.type == 1) : this.tail.type;
                    this.tail.sibling = t;
                }
            } else {
                assert (this.tail.lvl == lvl - 1) : "tail=" + String.valueOf(this.tail) + ", lvl=" + lvl;
                t.down = this.tail;
                this.tail = t;
            }
            return t;
        }

        protected final Tail<L> getTail(Tail<L> tail, int lvl) {
            assert (tail != null);
            assert (lvl >= 0 && lvl <= tail.lvl) : lvl;
            Tail t = tail;
            while (t.lvl != lvl) {
                t = t.down;
            }
            assert (t.type == 1) : t.type;
            return t;
        }

        protected final int insertionPoint(Tail<L> tail) throws IgniteInternalCheckedException {
            assert (tail.type == 1) : tail.type;
            if (tail.idx == Short.MIN_VALUE) {
                int idx = BplusTree.this.findInsertionPoint(tail.lvl, tail.io, tail.buf, 0, tail.getCount(), this.row, 0);
                assert (BplusTree.checkIndex(idx)) : idx;
                tail.idx = (short)idx;
            }
            return tail.idx;
        }

        protected final String printTail(boolean keys) throws IgniteInternalCheckedException {
            IgniteStringBuilder sb = new IgniteStringBuilder("");
            Tail t = this.tail;
            while (t != null) {
                sb.app(t.lvl).app(": ").app(BplusTree.this.printPage(t.io, t.buf, keys));
                Tail d = t.down;
                t = t.sibling;
                if (t != null) {
                    sb.app(" -> ").app(t.type == 2 ? "F" : "B").app(' ').app(BplusTree.this.printPage(t.io, t.buf, keys));
                }
                sb.app('\n');
                t = d;
            }
            return sb.toString();
        }
    }

    public final class Put
    extends Update {
        long rightId;
        T oldRow;
        short btmLvl;
        final boolean needOld;

        private Put(T row, boolean needOld) {
            this(row, needOld, null);
        }

        private Put(T row, @Nullable boolean needOld, Runnable onUpdateCallback) {
            super(row, onUpdateCallback);
            this.needOld = needOld;
        }

        @Override
        boolean notFound(BplusIo<L> io, long pageAddr, int idx, int lvl) {
            assert (this.btmLvl >= 0) : this.btmLvl;
            assert (lvl >= this.btmLvl) : lvl;
            return lvl == this.btmLvl;
        }

        @Override
        protected Result finishOrLockTail(long pageId, long page, long backId, long fwdId, int lvl) throws IgniteInternalCheckedException {
            if (this.btmLvl == lvl) {
                return this.tryInsert(pageId, page, fwdId, lvl);
            }
            Result res = this.finishTail();
            if (res == Result.NOT_FOUND) {
                this.fwdId(fwdId);
                res = (Result)((Object)BplusTree.this.write(pageId, page, BplusTree.this.lockTailExact, this, lvl, (Object)Result.RETRY));
            }
            if (res == Result.RETRY) {
                this.releaseTail();
            }
            return res;
        }

        @Override
        protected Result finishTail() throws IgniteInternalCheckedException {
            if (this.tail.lvl == 0) {
                return Result.NOT_FOUND;
            }
            int idx = this.insertionPoint(this.tail);
            if (idx < 0) {
                BplusInnerIo io = (BplusInnerIo)this.tail.io;
                if (io.getLeft(this.tail.buf, idx = BplusTree.fix(idx), BplusTree.this.partId) != this.tail.down.pageId) {
                    this.releaseTail();
                    return Result.RETRY;
                }
                return Result.NOT_FOUND;
            }
            assert (this.oldRow == null) : "The old row must be set only once.";
            this.replaceRowInPage(this.tail.io, this.tail.buf, idx);
            while (this.tail.lvl != 0) {
                BplusTree.this.writeUnlockAndClose(this.tail.pageId, this.tail.page, this.tail.buf);
                this.tail = this.tail.down;
            }
            this.oldRow = this.needOld ? BplusTree.this.getRow(this.tail.io, this.tail.buf, this.tail.idx) : Boolean.TRUE;
            this.replaceRowInPage(this.tail.io, this.tail.buf, this.tail.idx);
            this.finish();
            return Result.FOUND;
        }

        private void setTailForSplit(long tailId, long tailPage, long tailPageAddr, BplusIo<L> io, int lvl) {
            assert (tailId != 0L && tailPage != 0L && tailPageAddr != 0L);
            this.releaseTail();
            this.addTail(tailId, tailPage, tailPageAddr, io, lvl, (byte)1);
        }

        private void finish() {
            this.row = null;
            this.rightId = 0L;
            this.releaseTail();
        }

        @Override
        boolean isFinished() {
            return this.row == null;
        }

        @Nullable
        private L insert(long pageId, long pageAddr, BplusIo<L> io, int idx, int lvl) throws IgniteInternalCheckedException {
            int maxCnt = io.getMaxCount(pageAddr, BplusTree.this.pageSize());
            int cnt = io.getCount(pageAddr);
            if (cnt == maxCnt) {
                return this.insertWithSplit(pageId, pageAddr, io, idx, lvl);
            }
            this.insertSimple(pageAddr, io, idx);
            return null;
        }

        private void insertSimple(long pageAddr, BplusIo<L> io, int idx) throws IgniteInternalCheckedException {
            io.insert(pageAddr, idx, this.row, null, this.rightId, false);
            if (this.onUpdateCallback != null) {
                this.onUpdateCallback.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private L insertWithSplit(long pageId, long pageAddr, BplusIo<L> io, int idx, int lvl) throws IgniteInternalCheckedException {
            long fwdId = BplusTree.this.allocatePage(null);
            long fwdPage = BplusTree.this.acquirePage(fwdId);
            try {
                Object moveUpRow;
                long fwdPageAddr;
                block22: {
                    Object l;
                    boolean hadFwd = io.getForward(pageAddr, BplusTree.this.partId) != 0L;
                    fwdPageAddr = BplusTree.this.writeLock(fwdId, fwdPage);
                    assert (fwdPageAddr != 0L);
                    try {
                        boolean midShift = BplusTree.this.splitPage(pageAddr, io, fwdId, fwdPageAddr, idx);
                        int cnt = io.getCount(pageAddr);
                        if (idx < cnt || idx == cnt && !midShift) {
                            this.insertSimple(pageAddr, io, idx);
                            if (idx == cnt && !io.isLeaf()) {
                                BplusTree.inner(io).setLeft(fwdPageAddr, 0, this.rightId);
                            }
                        } else {
                            this.insertSimple(fwdPageAddr, io, idx - cnt);
                        }
                        cnt = io.getCount(pageAddr);
                        moveUpRow = io.getLookupRow(BplusTree.this, pageAddr, cnt - 1);
                        if (!io.isLeaf()) {
                            io.setCount(pageAddr, cnt - 1);
                        }
                        if (hadFwd || lvl != BplusTree.this.getRootLevel()) break block22;
                        long newRootId = BplusTree.this.allocatePage(null);
                        long newRootPage = BplusTree.this.acquirePage(newRootId);
                        try {
                            if (io.isLeaf()) {
                                io = BplusTree.this.latestInnerIo();
                            }
                            long newRootAddr = BplusTree.this.writeLock(newRootId, newRootPage);
                            assert (newRootAddr != 0L);
                            try {
                                BplusTree.inner(io).initNewRoot(newRootAddr, newRootId, pageId, moveUpRow, null, fwdId, BplusTree.this.pageSize(), false);
                            }
                            finally {
                                BplusTree.this.writeUnlock(newRootId, newRootPage, newRootAddr, true);
                            }
                        }
                        finally {
                            BplusTree.this.releasePage(newRootId, newRootPage);
                        }
                        Bool res = (Bool)((Object)BplusTree.this.write(BplusTree.this.metaPageId, BplusTree.this.addRoot, newRootId, lvl + 1, (Object)Bool.FALSE));
                        assert (res == Bool.TRUE) : res;
                        l = null;
                    }
                    catch (Throwable throwable) {
                        BplusTree.this.writeUnlock(fwdId, fwdPage, fwdPageAddr, true);
                        throw throwable;
                    }
                    BplusTree.this.writeUnlock(fwdId, fwdPage, fwdPageAddr, true);
                    return l;
                }
                Object l = moveUpRow;
                BplusTree.this.writeUnlock(fwdId, fwdPage, fwdPageAddr, true);
                return l;
            }
            finally {
                BplusTree.this.releasePage(fwdId, fwdPage);
            }
        }

        private Result tryInsert(long pageId, long page, long fwdId, int lvl) throws IgniteInternalCheckedException {
            this.pageId = pageId;
            this.fwdId = fwdId;
            return (Result)((Object)BplusTree.this.write(pageId, page, BplusTree.this.insert, this, lvl, (Object)Result.RETRY));
        }

        private Result tryReplace(long pageId, long page, long fwdId, int lvl) throws IgniteInternalCheckedException {
            this.pageId = pageId;
            this.fwdId = fwdId;
            return (Result)((Object)BplusTree.this.write(pageId, page, BplusTree.this.replace, this, lvl, (Object)Result.RETRY));
        }

        private void replaceRowInPage(BplusIo<L> io, long pageAddr, int idx) throws IgniteInternalCheckedException {
            io.store(pageAddr, idx, this.row, null, false);
            if (this.onUpdateCallback != null) {
                this.onUpdateCallback.run();
            }
        }

        @Override
        void checkLockRetry() throws IgniteInternalCheckedException {
            if (this.tail == null) {
                super.checkLockRetry();
            }
        }
    }

    public final class Remove
    extends Update
    implements ReuseBag {
        boolean needReplaceInner;
        Bool needMergeEmptyBranch;
        T rmvd;
        long page;
        @Nullable
        Object freePages;
        final boolean needOld;

        private Remove(L row, boolean needOld) {
            this(row, needOld, null);
        }

        private Remove(L row, @Nullable boolean needOld, Runnable onRemoveCallback) {
            super(row, onRemoveCallback);
            this.needMergeEmptyBranch = Bool.FALSE;
            this.needOld = needOld;
        }

        @Override
        public long pollFreePage() {
            if (this.freePages == null) {
                return 0L;
            }
            if (this.freePages instanceof LongArrayFIFOQueue) {
                LongArrayFIFOQueue pages = (LongArrayFIFOQueue)this.freePages;
                return pages.isEmpty() ? 0L : pages.dequeueLastLong();
            }
            long res = (Long)this.freePages;
            this.freePages = null;
            return res;
        }

        @Override
        public void addFreePage(long pageId) {
            assert (pageId != 0L);
            if (this.freePages == null) {
                this.freePages = pageId;
            } else {
                LongArrayFIFOQueue pages;
                if (this.freePages instanceof LongArrayFIFOQueue) {
                    pages = (LongArrayFIFOQueue)this.freePages;
                } else {
                    pages = new LongArrayFIFOQueue(4);
                    pages.enqueue(((Long)this.freePages).longValue());
                    this.freePages = pages;
                }
                pages.enqueue(pageId);
            }
        }

        @Override
        public boolean isEmpty() {
            if (this.freePages == null) {
                return true;
            }
            if (this.freePages instanceof LongArrayFIFOQueue) {
                return ((LongArrayFIFOQueue)this.freePages).isEmpty();
            }
            return false;
        }

        @Override
        boolean notFound(BplusIo<L> io, long pageAddr, int idx, int lvl) {
            if (lvl == 0) {
                assert (this.tail == null);
                return true;
            }
            return false;
        }

        private void finish() {
            assert (this.tail == null);
            this.row = null;
        }

        @Nullable
        private Tail<L> mergeEmptyBranch() throws IgniteInternalCheckedException {
            assert (this.needMergeEmptyBranch == Bool.TRUE) : this.needMergeEmptyBranch;
            Tail t = this.tail;
            Tail t0 = t.down;
            while (t0.lvl != 0) {
                assert (t0.type == 1) : t0.type;
                if (t0.getCount() != 0) {
                    t = t0;
                }
                t0 = t0.down;
            }
            int cnt = t.getCount();
            int idx = BplusTree.fix(this.insertionPoint(t));
            assert (cnt > 0) : cnt;
            if (idx == cnt) {
                --idx;
            }
            if (!this.checkChildren(t, t.getLeftChild(), t.getRightChild(), idx)) {
                return t;
            }
            this.removeDataRowFromLeafTail(t);
            while (t.lvl != 0) {
                boolean res = this.merge(t);
                assert (res) : String.valueOf((Object)this.needMergeEmptyBranch) + "\n" + this.printTail(true);
                if (this.needMergeEmptyBranch == Bool.TRUE) {
                    this.needMergeEmptyBranch = Bool.READY;
                }
                t = t.down;
            }
            return null;
        }

        private void mergeBottomUp(Tail<L> t) throws IgniteInternalCheckedException {
            assert (this.needMergeEmptyBranch == Bool.FALSE || this.needMergeEmptyBranch == Bool.DONE) : this.needMergeEmptyBranch;
            if (t.down == null || t.down.sibling == null) {
                if (t.lvl == 0 && !this.isRemoved()) {
                    this.removeDataRowFromLeafTail(t);
                }
                return;
            }
            this.mergeBottomUp(t.down);
            this.merge(t);
        }

        private boolean isInnerKeyInTail() throws IgniteInternalCheckedException {
            assert (this.tail.lvl > 0) : this.tail.lvl;
            return this.insertionPoint(this.tail) >= 0;
        }

        private boolean isRemoved() {
            return this.rmvd != null;
        }

        private boolean releaseForRetry(Tail<L> t) {
            Tail newTail;
            if (t.lvl <= 1) {
                assert (!this.isRemoved()) : "removed";
                this.needReplaceInner = false;
                this.needMergeEmptyBranch = Bool.FALSE;
                this.releaseTail();
                return true;
            }
            if (t.down != null && (newTail = t.down.down) != null) {
                t.down.down = null;
                this.releaseTail();
                this.tail = newTail;
                return true;
            }
            assert (this.isRemoved() && !this.needReplaceInner && this.needMergeEmptyBranch != Bool.TRUE) : "isRemoved=" + this.isRemoved() + ", needReplaceInner=" + this.needReplaceInner + ", needMergeEmptyBranch=" + String.valueOf((Object)this.needMergeEmptyBranch);
            return false;
        }

        @Override
        protected Result finishTail() throws IgniteInternalCheckedException {
            assert (!this.isFinished() && this.tail.type == 1 && this.tail.lvl >= 0 && this.needMergeEmptyBranch != Bool.READY) : "isFinished=" + this.isFinished() + ", tail=" + String.valueOf(this.tail) + ", needMergeEmptyBranch=" + String.valueOf((Object)this.needMergeEmptyBranch);
            if (this.tail.lvl == 0) {
                assert (this.tail.sibling != null) : this.tail;
                return Result.NOT_FOUND;
            }
            if (!this.validateTail()) {
                if (this.releaseForRetry(this.tail)) {
                    return Result.RETRY;
                }
            } else {
                if (this.needReplaceInner && !this.isInnerKeyInTail()) {
                    return Result.NOT_FOUND;
                }
                if (this.needMergeEmptyBranch == Bool.TRUE) {
                    if (this.tail.getCount() == 0) {
                        return Result.NOT_FOUND;
                    }
                    Tail t = this.mergeEmptyBranch();
                    if (t != null) {
                        boolean ok = this.releaseForRetry(t);
                        assert (ok);
                        return Result.RETRY;
                    }
                    this.needMergeEmptyBranch = Bool.DONE;
                }
                this.mergeBottomUp(this.tail);
                if (this.needReplaceInner) {
                    this.replaceInner();
                    this.needReplaceInner = false;
                }
                while (this.tail.getCount() == 0 && this.tail.lvl != 0 && BplusTree.this.getRootLevel() == this.tail.lvl) {
                    this.cutRoot(this.tail.lvl);
                    this.freePage(this.tail.pageId, this.tail.page, this.tail.buf, true);
                    this.tail = this.tail.down;
                    assert (this.tail.sibling == null) : this.tail;
                }
                if (this.tail.sibling != null && this.tail.getCount() + this.tail.sibling.getCount() < this.tail.io.getMaxCount(this.tail.buf, BplusTree.this.pageSize())) {
                    this.doReleaseTail(this.tail.down);
                    this.tail.down = null;
                    return Result.NOT_FOUND;
                }
            }
            assert (this.isRemoved());
            this.releaseTail();
            this.finish();
            return Result.FOUND;
        }

        private void removeDataRowFromLeafTail(Tail<L> t) throws IgniteInternalCheckedException {
            assert (!this.isRemoved());
            Tail leaf = this.getTail(t, 0);
            this.removeDataRowFromLeaf(leaf.buf, leaf.io, leaf.getCount(), this.insertionPoint(leaf));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Result removeFromLeaf(long leafId, long leafPage, long backId, long fwdId) throws IgniteInternalCheckedException {
            this.pageId = leafId;
            this.page = leafPage;
            this.backId = backId;
            this.fwdId = fwdId;
            if (backId == 0L) {
                return this.doRemoveFromLeaf();
            }
            long backPage = BplusTree.this.acquirePage(backId);
            try {
                Result result = (Result)((Object)BplusTree.this.write(backId, backPage, BplusTree.this.lockBackAndRmvFromLeaf, this, 0, (Object)Result.RETRY));
                return result;
            }
            finally {
                if (this.canRelease(backId, 0)) {
                    BplusTree.this.releasePage(backId, backPage);
                }
            }
        }

        private Result doRemoveFromLeaf() throws IgniteInternalCheckedException {
            assert (this.page != 0L);
            return (Result)((Object)BplusTree.this.write(this.pageId, this.page, BplusTree.this.rmvFromLeaf, this, 0, (Object)Result.RETRY));
        }

        private Result doLockTail(int lvl) throws IgniteInternalCheckedException {
            assert (this.page != 0L);
            return (Result)((Object)BplusTree.this.write(this.pageId, this.page, BplusTree.this.lockTail, this, lvl, (Object)Result.RETRY));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Result lockTail(long pageId, long page, long backId, long fwdId, int lvl) throws IgniteInternalCheckedException {
            assert (this.tail != null);
            this.pageId = pageId;
            this.page = page;
            this.fwdId = fwdId;
            this.backId = backId;
            if (backId == 0L) {
                return this.doLockTail(lvl);
            }
            long backPage = BplusTree.this.acquirePage(backId);
            try {
                Result result = (Result)((Object)BplusTree.this.write(backId, backPage, BplusTree.this.lockBackAndTail, this, lvl, (Object)Result.RETRY));
                return result;
            }
            finally {
                if (this.canRelease(backId, lvl)) {
                    BplusTree.this.releasePage(backId, backPage);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Result lockForward(int lvl) throws IgniteInternalCheckedException {
            assert (this.fwdId != 0L) : this.fwdId;
            assert (this.backId == 0L) : this.backId;
            long fwdId = this.fwdId;
            long fwdPage = BplusTree.this.acquirePage(fwdId);
            try {
                Result result = (Result)((Object)BplusTree.this.write(fwdId, fwdPage, BplusTree.this.lockTailForward, this, lvl, (Object)Result.RETRY));
                return result;
            }
            finally {
                if (this.canRelease(fwdId, lvl)) {
                    BplusTree.this.releasePage(fwdId, fwdPage);
                }
            }
        }

        private void removeDataRowFromLeaf(long pageAddr, BplusIo<L> io, int cnt, int idx) throws IgniteInternalCheckedException {
            assert (idx >= 0 && idx < cnt) : idx;
            assert (io.isLeaf()) : "inner";
            assert (!this.isRemoved()) : "already removed";
            this.rmvd = this.needOld ? BplusTree.this.getRow(io, pageAddr, idx) : Boolean.TRUE;
            this.doRemove(pageAddr, io, cnt, idx);
            assert (this.isRemoved());
            if (this.onUpdateCallback != null) {
                this.onUpdateCallback.run();
            }
        }

        private void doRemove(long pageAddr, BplusIo<L> io, int cnt, int idx) throws IgniteInternalCheckedException {
            assert (cnt > 0) : cnt;
            assert (idx >= 0 && idx < cnt) : idx + " " + cnt;
            io.remove(pageAddr, idx, cnt);
        }

        private boolean validateTail() throws IgniteInternalCheckedException {
            int idx;
            Tail s;
            Tail t = this.tail;
            if (t.down == null) {
                assert (this.needMergeEmptyBranch != Bool.TRUE && !this.needReplaceInner) : "needMergeEmptyBranch=" + String.valueOf((Object)this.needMergeEmptyBranch) + ", needReplaceInner" + this.needReplaceInner;
                return true;
            }
            Tail left = t.getLeftChild();
            Tail right = t.getRightChild();
            assert (left.pageId != right.pageId);
            int cnt = t.getCount();
            if (cnt != 0) {
                int idx2 = BplusTree.fix(this.insertionPoint(t));
                if (idx2 == cnt) {
                    --idx2;
                }
                if (this.isChild(t, left, idx2, cnt, false) && this.isChild(t, right, idx2, cnt, true)) {
                    return true;
                }
            }
            if ((s = t.sibling) == null) {
                return false;
            }
            int n = idx = cnt == 0 ? 0 : cnt - 1;
            if (s.type == 2) {
                return this.isChild(t, left, idx, cnt, true) && this.isChild(s, right, 0, 0, false);
            }
            assert (s.type == 0);
            if (!this.isChild(t, right, 0, 0, false)) {
                return false;
            }
            cnt = s.getCount();
            idx = cnt == 0 ? 0 : cnt - 1;
            return this.isChild(s, left, idx, cnt, true);
        }

        private boolean isChild(Tail<L> prnt, Tail<L> child, int idx, int cnt, boolean right) {
            if (right && cnt != 0) {
                ++idx;
            }
            return BplusTree.inner(prnt.io).getLeft(prnt.buf, idx, BplusTree.this.partId) == child.pageId;
        }

        private boolean checkChildren(Tail<L> prnt, Tail<L> left, Tail<L> right, int idx) {
            assert (idx >= 0 && idx < prnt.getCount()) : idx;
            return BplusTree.inner(prnt.io).getLeft(prnt.buf, idx, BplusTree.this.partId) == left.pageId && BplusTree.inner(prnt.io).getRight(prnt.buf, idx, BplusTree.this.partId) == right.pageId;
        }

        private boolean doMerge(Tail<L> prnt, Tail<L> left, Tail<L> right) throws IgniteInternalCheckedException {
            boolean emptyBranch;
            assert (right.io == left.io);
            assert (left.io.getForward(left.buf, BplusTree.this.partId) == right.pageId);
            int prntCnt = prnt.getCount();
            int prntIdx = BplusTree.fix(this.insertionPoint(prnt));
            if (prntIdx == prntCnt) {
                --prntIdx;
            }
            if (this.needMergeEmptyBranch == Bool.READY) {
                assert (left.getCount() == 0 || right.getCount() == 0);
            } else if (!this.checkChildren(prnt, left, right, prntIdx)) {
                return false;
            }
            boolean bl = emptyBranch = this.needMergeEmptyBranch == Bool.TRUE || this.needMergeEmptyBranch == Bool.READY;
            if (!left.io.merge(prnt.io, prnt.buf, prntIdx, left.buf, right.buf, emptyBranch, BplusTree.this.pageSize())) {
                return false;
            }
            prnt.idx = (short)Short.MIN_VALUE;
            left.idx = (short)Short.MIN_VALUE;
            if (this.needMergeEmptyBranch != Bool.READY) {
                this.doRemove(prnt.buf, prnt.io, prntCnt, prntIdx);
            }
            this.freePage(right.pageId, right.page, right.buf, true);
            return true;
        }

        private void freePage(long pageId, long page, long pageAddr, boolean release) {
            long effectivePageId = PageIdUtils.effectivePageId(pageId);
            long recycled = BplusTree.recyclePage(pageId, pageAddr);
            if (effectivePageId != PageIdUtils.effectivePageId(pageId)) {
                throw new IllegalStateException("Effective page ID must stay the same.");
            }
            if (release) {
                BplusTree.this.writeUnlockAndClose(pageId, page, pageAddr);
            }
            this.addFreePage(recycled);
        }

        private void cutRoot(int lvl) throws IgniteInternalCheckedException {
            Bool res = (Bool)((Object)BplusTree.this.write(BplusTree.this.metaPageId, BplusTree.this.cutRoot, lvl, (Object)Bool.FALSE));
            assert (res == Bool.TRUE) : res;
        }

        private void reuseFreePages() throws IgniteInternalCheckedException {
            if (BplusTree.this.reuseList != null && this.freePages != null) {
                BplusTree.this.reuseList.addForRecycle(this);
            }
        }

        private void replaceInner() throws IgniteInternalCheckedException {
            int innerIdx;
            assert (this.needReplaceInner);
            Tail inner = this.tail;
            while (true) {
                assert (inner.type == 1) : inner.type;
                assert (inner.lvl > 0) : "leaf " + this.tail.lvl;
                innerIdx = this.insertionPoint(inner);
                if (innerIdx >= 0) break;
                if (inner.lvl == 1) {
                    return;
                }
                inner = inner.down;
            }
            Tail leaf = this.getTail(inner, 0);
            int leafCnt = leaf.getCount();
            assert (leafCnt > 0) : leafCnt;
            int leafIdx = leafCnt - 1;
            long rmvId = BplusTree.this.globalRmvId.incrementAndGet();
            inner.io.store(inner.buf, innerIdx, leaf.io, leaf.buf, leafIdx);
            inner.io.setRemoveId(inner.buf, rmvId);
            leaf.io.setRemoveId(leaf.buf, rmvId);
        }

        private boolean merge(Tail<L> prnt) throws IgniteInternalCheckedException {
            Tail right;
            if (prnt.getCount() == 0 && this.needMergeEmptyBranch != Bool.READY) {
                return false;
            }
            Tail left = prnt.getLeftChild();
            if (!this.doMerge(prnt, left, right = prnt.getRightChild())) {
                return false;
            }
            if (left.type == 0) {
                assert (left.sibling == null);
                left.down = right.down;
                left.type = 1;
                prnt.down = left;
            } else {
                assert (left.type == 1) : left.type;
                assert (left.sibling != null);
                left.sibling = null;
            }
            return true;
        }

        @Override
        boolean isFinished() {
            return this.row == null;
        }

        private void releaseAll() throws IgniteInternalCheckedException {
            this.releaseTail();
            this.reuseFreePages();
        }

        @Override
        protected Result finishOrLockTail(long pageId, long page, long backId, long fwdId, int lvl) throws IgniteInternalCheckedException {
            Result res = this.finishTail();
            if (res == Result.NOT_FOUND) {
                res = this.lockTail(pageId, page, backId, fwdId, lvl);
            }
            return res;
        }

        private Result tryRemoveFromLeaf(long pageId, long page, long backId, long fwdId, int lvl) throws IgniteInternalCheckedException {
            assert (lvl == 0) : lvl;
            Result res = this.removeFromLeaf(pageId, page, backId, fwdId);
            if (res == Result.FOUND && this.tail == null) {
                this.finish();
            }
            return res;
        }
    }

    private static final class Tail<L> {
        static final byte BACK = 0;
        static final byte EXACT = 1;
        static final byte FORWARD = 2;
        private final long pageId;
        private final long page;
        private final long buf;
        private final BplusIo<L> io;
        private byte type;
        private final int lvl;
        private short idx = (short)Short.MIN_VALUE;
        @Nullable
        private Tail<L> sibling;
        @Nullable
        private Tail<L> down;

        private Tail(long pageId, long page, long buf, BplusIo<L> io, byte type, int lvl) {
            assert (type == 0 || type == 1 || type == 2) : type;
            assert (lvl >= 0 && lvl <= 127) : lvl;
            assert (pageId != 0L);
            assert (page != 0L);
            assert (buf != 0L);
            this.pageId = pageId;
            this.page = page;
            this.buf = buf;
            this.io = io;
            this.type = type;
            this.lvl = (byte)lvl;
        }

        private int getCount() {
            return this.io.getCount(this.buf);
        }

        public String toString() {
            return new IgniteStringBuilder("Tail[").app("pageId=").appendHex(this.pageId).app(", cnt= ").app(this.getCount()).app(", lvl=" + this.lvl).app(", sibling=").app(this.sibling).app("]").toString();
        }

        private Tail<L> getLeftChild() {
            Tail<L> s = this.down.sibling;
            return s.type == 0 ? s : this.down;
        }

        private Tail<L> getRightChild() {
            Tail<L> s = this.down.sibling;
            return s.type == 2 ? s : this.down;
        }
    }

    private static class RootPageIdAndLevel {
        private final long pageId;
        private final int level;

        private RootPageIdAndLevel(long pageId, int level) {
            this.pageId = pageId;
            this.level = level;
        }
    }

    private class DestroyTreeTask
    implements GradualTask {
        private final LongListReuseBag bag;
        @Nullable
        private final Consumer<L> actOnEachElement;
        private final int rootLevel;
        private final int maxWorkUnits;
        private final long[][] childrenPageIds;
        private final int[] currentChildIndices;
        private int currentLevel;
        private long currentPageId;
        private boolean finished = false;

        private DestroyTreeTask(@Nullable LongListReuseBag bag, Consumer<L> actOnEachElement, int rootLevel, long rootPageId, int maxWorkUnits) {
            this.bag = bag;
            this.actOnEachElement = actOnEachElement;
            this.rootLevel = rootLevel;
            this.maxWorkUnits = maxWorkUnits;
            this.childrenPageIds = new long[rootLevel + 1][];
            this.currentChildIndices = new int[rootLevel + 1];
            this.currentLevel = rootLevel;
            this.currentPageId = rootPageId;
        }

        @Override
        public void runStep() throws Exception {
            this.destroyNextBatch();
            if (this.finished) {
                BplusTree.this.addForRecycle(this.bag);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void destroyNextBatch() throws IgniteInternalCheckedException {
            int workDone = 0;
            while (!this.finished && workDone < this.maxWorkUnits) {
                long pageId = this.currentPageId;
                long page = BplusTree.this.acquirePage(pageId);
                try {
                    long pageAddr = BplusTree.this.writeLock(pageId, page);
                    if (pageAddr == 0L) {
                        ++workDone;
                        this.positionToNextPageId();
                        continue;
                    }
                    try {
                        int cnt;
                        BplusIo io = BplusTree.this.io(pageAddr);
                        if (io.isLeaf() != (this.currentLevel == 0)) {
                            BplusTree.fail("Leaf level mismatch: " + this.currentLevel);
                        }
                        if ((cnt = io.getCount(pageAddr)) < 0) {
                            BplusTree.fail("Negative count: " + cnt);
                        }
                        if (!io.isLeaf()) {
                            this.readChildrenPageIdsAndDescend(pageAddr, io, cnt);
                        } else {
                            if (this.actOnEachElement != null) {
                                io.visit(BplusTree.this, pageAddr, this.actOnEachElement);
                                workDone += io.getCount(pageAddr);
                            }
                            this.positionToNextPageId();
                        }
                        this.bag.addFreePage(BplusTree.recyclePage(pageId, pageAddr));
                    }
                    finally {
                        BplusTree.this.writeUnlock(pageId, page, pageAddr, true);
                    }
                }
                finally {
                    BplusTree.this.releasePage(pageId, page);
                    continue;
                }
                ++workDone;
                if (this.bag.size() < 128) continue;
                BplusTree.this.addForRecycle(this.bag);
            }
        }

        private void readChildrenPageIdsAndDescend(long pageAddr, BplusIo<L> io, int cnt) {
            long[] pageIds = new long[cnt + 1];
            for (int i = 0; i <= cnt; ++i) {
                long leftId = BplusTree.inner(io).getLeft(pageAddr, i, BplusTree.this.partId);
                BplusTree.inner(io).setLeft(pageAddr, i, 0L);
                pageIds[i] = leftId;
            }
            --this.currentLevel;
            this.childrenPageIds[this.currentLevel] = pageIds;
            this.currentChildIndices[this.currentLevel] = 0;
            this.currentPageId = this.childrenPageIds[this.currentLevel][this.currentChildIndices[this.currentLevel]];
        }

        private void positionToNextPageId() {
            while (this.currentLevel < this.rootLevel) {
                if (this.currentChildIndices[this.currentLevel] + 1 < this.childrenPageIds[this.currentLevel].length) {
                    int n = this.currentLevel;
                    this.currentChildIndices[n] = this.currentChildIndices[n] + 1;
                    this.currentPageId = this.childrenPageIds[this.currentLevel][this.currentChildIndices[this.currentLevel]];
                    return;
                }
                ++this.currentLevel;
            }
            this.finished = true;
        }

        @Override
        public boolean isCompleted() {
            return this.finished;
        }
    }

    private abstract class GetPageHandler<G extends Get>
    implements PageHandler<G, Result> {
        private GetPageHandler() {
        }

        @Override
        public Result run(int groupId, long pageId, long page, long pageAddr, PageIo iox, G g, int lvl) throws IgniteInternalCheckedException {
            assert (PageIo.getPageId(pageAddr) == pageId) : "pageId mismatch [requested=" + pageId + ", stored=" + PageIo.getPageId(pageAddr) + "]";
            BplusIo io = (BplusIo)iox;
            if (lvl == 0 && ((Get)g).rmvId < io.getRemoveId(pageAddr)) {
                return Result.RETRY_ROOT;
            }
            return this.run0(pageId, page, pageAddr, io, g, lvl);
        }

        protected abstract Result run0(long var1, long var3, long var5, BplusIo<L> var7, G var8, int var9) throws IgniteInternalCheckedException;

        @Override
        public boolean releaseAfterWrite(int cacheId, long pageId, long page, long pageAddr, G g, int lvl) {
            return ((Get)g).canRelease(pageId, lvl);
        }
    }

    private abstract class AbstractForwardCursor {
        long nextPageId;
        @Nullable
        L lowerBound;
        private int lowerShift;
        @Nullable
        final L upperBound;
        private final int upperShift;
        public GetCursor getCursor;

        AbstractForwardCursor(@Nullable L lowerBound, L upperBound, boolean lowIncl, boolean upIncl) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.lowerShift = lowIncl ? -1 : 1;
            this.upperShift = upIncl ? 1 : -1;
        }

        abstract void init0();

        abstract boolean fillFromBuffer0(long var1, BplusIo<L> var3, int var4, int var5) throws IgniteInternalCheckedException;

        abstract boolean reinitialize0() throws IgniteInternalCheckedException;

        abstract void onNotFound(boolean var1);

        final void init(long pageAddr, BplusIo<L> io, int startIdx) throws IgniteInternalCheckedException {
            this.nextPageId = 0L;
            this.init0();
            int cnt = io.getCount(pageAddr);
            if (cnt == 0) {
                assert (io.getForward(pageAddr, BplusTree.this.partId) == 0L);
                this.onNotFound(true);
            } else if (!this.fillFromBuffer(pageAddr, io, startIdx, cnt)) {
                this.onNotFound(false);
            }
        }

        final int findLowerBound(long pageAddr, BplusIo<L> io, int cnt) throws IgniteInternalCheckedException {
            assert (io.isLeaf());
            int cmp = BplusTree.this.compare(0, io, pageAddr, 0, this.lowerBound);
            if (cmp < 0 || cmp == 0 && this.lowerShift == 1) {
                int idx = BplusTree.this.findInsertionPoint(0, io, pageAddr, 0, cnt, this.lowerBound, this.lowerShift);
                assert (idx < 0);
                return BplusTree.fix(idx);
            }
            return 0;
        }

        final int findUpperBound(long pageAddr, BplusIo<L> io, int low, int cnt) throws IgniteInternalCheckedException {
            assert (io.isLeaf());
            int cmp = BplusTree.this.compare(0, io, pageAddr, cnt - 1, this.upperBound);
            if (cmp > 0 || cmp == 0 && this.upperShift == -1) {
                int idx = BplusTree.this.findInsertionPoint(0, io, pageAddr, low, cnt, this.upperBound, this.upperShift);
                assert (idx < 0);
                cnt = BplusTree.fix(idx);
                this.nextPageId = 0L;
            }
            return cnt;
        }

        private boolean fillFromBuffer(long pageAddr, BplusIo<L> io, int startIdx, int cnt) throws IgniteInternalCheckedException {
            assert (io.isLeaf()) : io;
            assert (cnt != 0) : cnt;
            assert (startIdx >= 0 || startIdx == -1) : startIdx;
            assert (cnt >= startIdx);
            BplusTree.this.checkDestroyed();
            this.nextPageId = io.getForward(pageAddr, BplusTree.this.partId);
            return this.fillFromBuffer0(pageAddr, io, startIdx, cnt);
        }

        final void find() throws IgniteInternalCheckedException {
            assert (this.lowerBound != null);
            this.getCursor = new GetCursor(this.lowerBound, this.lowerShift, this);
            BplusTree.this.doFind(this.getCursor);
        }

        private boolean reinitialize() throws IgniteInternalCheckedException {
            this.find();
            return this.reinitialize0();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean nextPage(@Nullable L lastRow) throws IgniteInternalCheckedException {
            BplusTree.this.checkDestroyed();
            this.updateLowerBound(lastRow);
            while (true) {
                if (this.nextPageId == 0L) {
                    this.onNotFound(true);
                    return false;
                }
                long pageId = this.nextPageId;
                long page = BplusTree.this.acquirePage(pageId);
                try {
                    long pageAddr = BplusTree.this.readLock(pageId, page);
                    if (pageAddr == 0L) break;
                    try {
                        BplusIo io = BplusTree.this.io(pageAddr);
                        if (!this.fillFromBuffer(pageAddr, io, -1, io.getCount(pageAddr))) continue;
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        BplusTree.this.readUnlock(pageId, page, pageAddr);
                        continue;
                    }
                }
                catch (CorruptedDataStructureException e) {
                    throw e;
                }
                catch (AssertionError | RuntimeException e) {
                    throw BplusTree.this.corruptedTreeException("Runtime failure on cursor iteration", (Throwable)e, BplusTree.this.grpId, pageId);
                }
                finally {
                    BplusTree.this.releasePage(pageId, page);
                    continue;
                }
                break;
            }
            return this.reinitialize();
        }

        private void updateLowerBound(@Nullable L lower) {
            if (lower != null) {
                this.lowerShift = 1;
                this.lowerBound = lower;
            }
        }
    }
}

