/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class CatalogSchemaDescriptor
extends CatalogObjectDescriptor
implements MarshallableEntry {
    private final CatalogTableDescriptor[] tables;
    private final CatalogIndexDescriptor[] indexes;
    private final CatalogSystemViewDescriptor[] systemViews;
    @IgniteToStringExclude
    private Map<String, CatalogTableDescriptor> tablesMap;
    @IgniteToStringExclude
    private Map<String, CatalogIndexDescriptor> indexesMap;
    @IgniteToStringExclude
    private Map<String, CatalogSystemViewDescriptor> systemViewsMap;

    public CatalogSchemaDescriptor(int id, String name, CatalogTableDescriptor[] tables, CatalogIndexDescriptor[] indexes, CatalogSystemViewDescriptor[] systemViews, HybridTimestamp timestamp) {
        super(id, CatalogObjectDescriptor.Type.SCHEMA, name, timestamp);
        this.tables = Objects.requireNonNull(tables, "tables");
        this.indexes = Objects.requireNonNull(indexes, "indexes");
        this.systemViews = Objects.requireNonNull(systemViews, "systemViews");
        this.rebuildMaps();
    }

    public CatalogTableDescriptor[] tables() {
        return this.tables;
    }

    public CatalogIndexDescriptor[] indexes() {
        return this.indexes;
    }

    public CatalogSystemViewDescriptor[] systemViews() {
        return this.systemViews;
    }

    @Nullable
    public CatalogTableDescriptor table(String name) {
        return this.tablesMap.get(name);
    }

    @Nullable
    public CatalogIndexDescriptor aliveIndex(String name) {
        return this.indexesMap.get(name);
    }

    @Nullable
    public CatalogSystemViewDescriptor systemView(String name) {
        return this.systemViewsMap.get(name);
    }

    public boolean isEmpty() {
        return this.tables.length == 0 && this.indexes.length == 0 && this.systemViews.length == 0;
    }

    private void rebuildMaps() {
        this.tablesMap = Arrays.stream(this.tables).collect(Collectors.toUnmodifiableMap(CatalogObjectDescriptor::name, Function.identity()));
        this.indexesMap = Arrays.stream(this.indexes).filter(index -> index.status().isAlive()).collect(Collectors.toUnmodifiableMap(CatalogObjectDescriptor::name, Function.identity()));
        this.systemViewsMap = Arrays.stream(this.systemViews).collect(Collectors.toUnmodifiableMap(CatalogObjectDescriptor::name, Function.identity()));
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DESCRIPTOR_SCHEMA.id();
    }

    @Override
    public String toString() {
        return S.toString(CatalogSchemaDescriptor.class, (Object)this, (String)super.toString());
    }
}

