/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.ColumnParams;
import org.apache.ignite.internal.catalog.commands.CreateSystemViewCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.storage.NewSystemViewEntry;
import org.apache.ignite.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.util.CollectionUtils;

public class CreateSystemViewCommand
implements CatalogCommand {
    private final String name;
    private final List<ColumnParams> columns;
    private final CatalogSystemViewDescriptor.SystemViewType systemViewType;

    private CreateSystemViewCommand(String name, List<ColumnParams> columns, CatalogSystemViewDescriptor.SystemViewType systemViewType) {
        this.name = name;
        this.columns = CollectionUtils.copyOrNull(columns);
        this.systemViewType = systemViewType;
        this.validate();
    }

    public String name() {
        return this.name;
    }

    public List<ColumnParams> columns() {
        return this.columns;
    }

    public CatalogSystemViewDescriptor.SystemViewType systemViewType() {
        return this.systemViewType;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        int id = catalog.objectIdGenState();
        CatalogSchemaDescriptor systemSchema = CatalogUtils.schemaOrThrow(catalog, "SYSTEM");
        List<CatalogTableColumnDescriptor> viewColumns = this.columns.stream().map(CatalogUtils::fromParams).collect(Collectors.toList());
        CatalogSystemViewDescriptor descriptor = new CatalogSystemViewDescriptor(id, systemSchema.id(), this.name, viewColumns, this.systemViewType);
        CatalogSystemViewDescriptor existingSystemView = systemSchema.systemView(this.name);
        if (existingSystemView == null) {
            CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(systemSchema, this.name);
        } else if (descriptor.equals(existingSystemView)) {
            return List.of();
        }
        return List.of(new NewSystemViewEntry(descriptor), new ObjectIdGenUpdateEntry(1));
    }

    private void validate() {
        CatalogParamsValidationUtils.validateIdentifier(this.name, "Name of the system view");
        if (CollectionUtils.nullOrEmpty(this.columns)) {
            throw new CatalogValidationException("System view should have at least one column.");
        }
        if (this.systemViewType == null) {
            throw new CatalogValidationException("System view type is not specified.");
        }
        HashSet<String> columnNames = new HashSet<String>();
        for (ColumnParams column : this.columns) {
            if (columnNames.add(column.name())) continue;
            throw new CatalogValidationException("Column with name '{}' specified more than once.", column.name());
        }
    }

    public static CreateSystemViewCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements CreateSystemViewCommandBuilder {
        private String name;
        private List<ColumnParams> columns;
        private CatalogSystemViewDescriptor.SystemViewType systemViewType;

        Builder() {
        }

        @Override
        public CreateSystemViewCommandBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public CreateSystemViewCommandBuilder type(CatalogSystemViewDescriptor.SystemViewType systemViewType) {
            this.systemViewType = systemViewType;
            return this;
        }

        @Override
        public CreateSystemViewCommandBuilder columns(List<ColumnParams> columns) {
            this.columns = columns;
            return this;
        }

        @Override
        public CreateSystemViewCommand build() {
            return new CreateSystemViewCommand(this.name, this.columns, this.systemViewType);
        }
    }
}

